package com.tisza.komal.i390;

import java.util.*;

import android.animation.*;
import android.app.*;
import android.graphics.*;
import android.os.*;
import android.view.*;
import android.widget.*;

public class MainActivity extends Activity
{
	private static final int COLOR_FALSE = Color.RED, COLOR_TRUE = Color.BLUE;
	private static final int MIN_SIZE = 1, DEFAULT_SIZE = 5, MAX_SIZE = 10;
	
	private int currentSize;
	private boolean[] board;
	private BoardLayout gameView;
	private TextView nTextView;
	private SeekBar sizeSeekBar;
	private Button startButton;
	
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		
		setContentView(R.layout.activity_main);
		
		gameView = (BoardLayout)findViewById(R.id.board);
		nTextView = (TextView)findViewById(R.id.n_text);
		sizeSeekBar = (SeekBar)findViewById(R.id.board_size_seekbar);
		startButton = (Button)findViewById(R.id.start_button);
				
		if (savedInstanceState == null)
		{
			currentSize = DEFAULT_SIZE;
			createRandomBoard();
		}
		else
		{
			currentSize = savedInstanceState.getInt("n");
			board = savedInstanceState.getBooleanArray("board");
		}
		
		sizeSeekBar.setMax(MAX_SIZE - MIN_SIZE);
		sizeSeekBar.setProgress(currentSize - MIN_SIZE);
		
		updateUI();
	}
	
	protected void onSaveInstanceState(Bundle outState)
	{
		super.onSaveInstanceState(outState);
		outState.putInt("n", currentSize);
		outState.putBooleanArray("board", board);
	}
	
	protected void onStart()
	{
		super.onStart();
		
		startButton.setOnClickListener(new View.OnClickListener()
		{
			public void onClick(View v)
			{
				currentSize = calcSeekBarValue();
				createRandomBoard();
				updateUI();
			}
		});
		
		sizeSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener()
		{
			public void onStopTrackingTouch(SeekBar seekBar)
			{
			}
			
			public void onStartTrackingTouch(SeekBar seekBar)
			{
			}
			
			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser)
			{
				nTextView.setText(calcSeekBarValue() + "");
			}
		});
	}

	private int calcSeekBarValue()
	{
		return sizeSeekBar.getProgress() + MIN_SIZE;
	}
	
	private void createRandomBoard()
	{
		board = new boolean[currentSize * currentSize];
		Arrays.fill(board, true);
		
		Random rnd = new Random();
		int filps = 1000 + rnd.nextInt(1000);
		for (int i = 0; i < filps; i++)
		{
			flip(rnd.nextInt(currentSize), rnd.nextInt(currentSize), false);
		}
	}
	
	private void updateUI()
	{		
		gameView.removeAllViews(); //would be nicer, if it was an apapter view
		gameView.setN(currentSize);
		for (int y = 0; y < currentSize; y++)
		{
			for (int x = 0; x < currentSize; x++)
			{
				View tile = new View(this);
				tile.setBackgroundColor(board[y * currentSize + x] ? COLOR_TRUE : COLOR_FALSE);
				final int xf = x, yf = y;
				tile.setOnClickListener(new View.OnClickListener()
				{
					public void onClick(View v)
					{
						flip(xf, yf, true);
					}
				});
				gameView.addView(tile);
			}
		}
	}
	
	private void flip(int x, int y, boolean fromUser)
	{
		for (int[] xyarr : new int[][]{{x - 1, y}, {x + 1, y}, {x, y - 1}, {x, y + 1}})
		{
			if (xyarr[0] < 0 || xyarr[0] >= currentSize || xyarr[1] < 0 || xyarr[1] >= currentSize) continue;
			
			final int pos = xyarr[1] * currentSize + xyarr[0];
			board[pos] ^= true;
			
			if (fromUser)
			{
				final View tile = gameView.getChildAt(pos);
				
				ObjectAnimator anim0 = ObjectAnimator.ofFloat(tile, "scaleX", 1, 0);
				anim0.setInterpolator(TileFlipInterpolator.first);
				anim0.setDuration(100);
				anim0.addListener(new AnimatorListenerAdapter()
				{
					public void onAnimationEnd(Animator animation)
					{
						tile.setBackgroundColor(board[pos] ? COLOR_TRUE : COLOR_FALSE);
					}
				});
				
				ObjectAnimator anim1 = ObjectAnimator.ofFloat(tile, "scaleX", 0, 1);
				anim1.setInterpolator(TileFlipInterpolator.second);
				anim1.setDuration(100);
				anim1.addListener(new AnimatorListenerAdapter()
				{
					public void onAnimationEnd(Animator animation)
					{
						if (isDone())
						{
							onWon();
						}
					}
				});
				
				AnimatorSet animSet = new AnimatorSet();
				animSet.playSequentially(anim0, anim1);
				animSet.start();
			}
		}
	}
	
	private boolean isDone()
	{
		for (boolean b : board)
		{
			if (!b) return false;
		}
		return true;
	}
	
	private void onWon()
	{
		finish(); //haha, you won't get any appreciative message
	}
}
