package hu.i477;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Point;

import javax.swing.JFrame;
import javax.swing.border.EmptyBorder;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class I477Frame extends JFrame {

	/**
	 * 
	 */
	
	public static int nagy=1, kicsi=3;
	
	private static final long serialVersionUID = -7039113494801581692L;
	private I477Panel contentPane;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		Calculate.init();
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					I477Frame frame = new I477Frame();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public I477Frame() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 800, 800);
		contentPane = new I477Panel();
		contentPane.addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(MouseEvent e) {
				if(e.getButton()==nagy) {
					Calculate.megragad="KK";
				} else
				if(e.getButton()==kicsi){
					Calculate.megragad=Calculate.nearestKozep(e.getX(), e.getY());
				} else {
					return;
				}
				Point p=Calculate.lekerdez(Calculate.megragad);
				double irx = e.getX()-p.x;
				double iry = p.y-e.getY();
				double szog=Math.atan(iry/irx);
				szog=Math.toDegrees(szog);
				if(irx<0) {
					szog+=180;
				}
				if(irx>=0&&iry<0) {
					szog+=360;
				}
				Calculate.kezdoszog=szog;
				Calculate.most=szog;
			}
			@Override
			public void mouseReleased(MouseEvent e) {
				if(e.getButton()==nagy||e.getButton()==kicsi) {
					double sz=Calculate.most-Calculate.kezdoszog;
					sz/=60;
					sz=Math.round(sz);
					sz+=12;
					switch(Calculate.megragad.charAt(1)) {
					case 'K':
						sz=24-sz;
						for(int i=0;i<sz;i++) {
							contentPane.tipp=Math.max(1, contentPane.tipp);
							Calculate.leptetKozep();
						}
						break;
					case 'F':
						for(int i=0;i<sz;i++) {
							contentPane.tipp=Math.max(2, contentPane.tipp);
							Calculate.leptetFel();
						}
						break;
					case 'B':
						for(int i=0;i<sz;i++) {
							contentPane.tipp=Math.max(2, contentPane.tipp);
							Calculate.leptetBal();
						}
						break;
					case 'J':
						for(int i=0;i<sz;i++) {
							contentPane.tipp=Math.max(2, contentPane.tipp);
							Calculate.leptetJobb();
						}
						break;
					}
	
					Calculate.megragad="";
					Calculate.most=0;
					Calculate.kezdoszog=0;
					contentPane.repaint();
				}
			}
		});
		contentPane.addMouseMotionListener(
				new MouseMotionAdapter() {
					@Override
					public void mouseDragged(MouseEvent e) {
						Point p=Calculate.lekerdez(Calculate.megragad);
						double irx = e.getX()-p.x;
						double iry = p.y-e.getY();
						double szog=Math.atan(iry/irx);
						szog=Math.toDegrees(szog);
						if(irx<0) {
							szog+=180;
						}
						if(irx>=0&&iry<0) {
							szog+=360;
						}
						Calculate.most=szog;
						contentPane.repaint();
					}
				}
			);
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
	}

}