﻿//S. 47.
//Kovács 125 András
//Budaörs Illyés Gyula Gimn. és KSZKI
//e-mail: kovand11@freemail.hu
//compiler: Visual Studio 2008 (Visual C# .NET framework 3.5)

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

//A kimenet tesztelve WordPad-re és Excel 2007-re!!!
//Az hogy a be ill. kimenet tizedespontot vagy tizedesvesszőt használ a Windows regionális beállításaitól függ
//ha magyar, akkor a specifikációnak megfelelő tizedesvesszőt használja.
//a #Kör hibaüzenet kompatibilitási okokból #Kor-re lett cserélve 

namespace s47
{
    class Program
    {
        static void Main(string[] args)
        {
            cellTable table = new cellTable();//a cellákat tárolja
            refExp.assignedTable = table;//megmondja hogy a hivatkozás melyik táblázatra vonatkozik
            if (args.Length != 2)
            {
                args = new string[2];
                Console.Write("Bemeneti FILE: "); args[0] = Console.ReadLine();
                Console.Write("Kimeneti FILE: "); args[1] = Console.ReadLine();
            }
            System.IO.StreamReader inStream;//bemenet
            System.IO.StreamWriter outStream;//kimenet
            inStream = new System.IO.StreamReader(args[0]);
            outStream = new System.IO.StreamWriter(args[1]);
            while (!inStream.EndOfStream)//végig az összes soron
            {
                string line = inStream.ReadLine();
                string[] leftRight = line.Split("=".ToCharArray());//jobb és baloldalra bontás
                if (leftRight.Length == 2)
                {
                    if (leftRight[0].Contains(':'))//ha tartomány
                    {
                        string[] corners = leftRight[0].Split(":".ToCharArray());
                        cellID begin = new cellID(corners[0]);
                        cellID end = new cellID(corners[1]);
                        int letterDiff = end.lettetPart - begin.lettetPart;//csak bal_felső:jobb_alsó formában érvényes
                        int numberDiff = end.numPart-begin.numPart;// (az Excel is csak így fogadja el)
                        for (int l=0;l<=letterDiff; l++)
                        {
                            for (int n = 0;n<=numberDiff; n++)
                            {
                                table.defineCell(cellID.strTransformCell(begin,l,n), transformExp(leftRight[1],l,n));
                                //a hozzárendelt érték transzformálása
                            }                            
                        }
                    }
                    else
                    {
                        leftRight[1]=leftRight[1].Replace("$","");//ha nem tartomány akkor nem számít hogy relatív vagy abszolút
                        table.defineCell(leftRight[0], leftRight[1]);
                    }
                }
            }
            inStream.Close();//bemenet lezárása
            table.startEvaluate();//kiértékelés
            outStream.Write(table.ToCSV());//konvertálás CSV-be majd kiírás
            outStream.Close();//kimenet lezárása
        }
        public static string transformExp(string cell,int cols,int rows)//cellahivatkozások eltolása a stringen belül
        {
            string[] values = cell.Split('+', '-', '*', '/');
            HashSet<string> refs = new HashSet<string>();
            foreach (string s in values)
            {
                try { float.Parse(s); }
                catch (Exception){refs.Add(s);}
            }
            foreach (string s in refs)
            {
                bool cAbs = s[0] == '$';
                bool rAbs = s.Substring(1).Contains('$');
                if (!(cAbs && rAbs))
                {
                    int cAdd; if (cAbs){cAdd=0;}else {cAdd=cols;}
                    int rAdd; if (rAbs){rAdd=0;}else {rAdd=rows;}
                    cell=cell.Replace(s,cellID.strTransformCell(new cellID(s.Replace("$","")),cAdd,rAdd));
                }
            }
            return cell.Replace("$","");
        }
    }


    class cellTable//cellákat tároló osztály
    {
        public void defineCell(string cell,string exp)//cella definiálása
        {
            if (data.ContainsKey(cell))
            {
                data[cell] = new compExp(exp);
            }
            else
            {
                data.Add(cell, new compExp(exp));
            }
        }
        public void startEvaluate()//kiértékelés megkezdése
        {
            toEvaluate = new LinkedList<string>(data.Keys);
            LinkedListNode<string> current;         
            while (toEvaluate.Count != 0)
            {
                current = toEvaluate.First;
                evaluateCell(current.Value);
            }
        }
        public void evaluateCell(string cell)//direkt kiértékelése az adott cellának
        {            
            if (data.ContainsKey(cell))
            {
                if (!underEvaluation.Contains(cell))
                {
                    underEvaluation.Push(cell);
                    data[cell] = data[cell].evaluate();
                    underEvaluation.Pop();
                    toEvaluate.Remove(cell);
                }
                else
                {
                    data[cell] = new errExp("Kor");
                }
            }
        }
        public expression getCell(string cell)//cella értékének visszaadása
        {
            if (data.ContainsKey(cell))
            {
                return data[cell];
            }
            else
            {
                return new numExp(0);
            }
        }
        public string ToCSV()//CSV-be konvertálás
        {
            string CSVFile="";
            char greatestCol=(char)('A'-1);
            int greatestRow=0;
            foreach (string s in data.Keys)
            {
                cellID ci = new cellID(s);
                if (ci.lettetPart > greatestCol) { greatestCol = ci.lettetPart; }
                if (ci.numPart > greatestRow) { greatestRow = ci.numPart; }
            }
            string cell;
            for (int j = 1; j <= greatestRow; j++)
            {
                for (char i = 'A'; i < greatestCol; i++)
                {
                    cell = getCell(i.ToString() + j.ToString()).ToString();
                    if (cell == "0") { cell = " "; }
                    CSVFile += cell;
                    CSVFile += ";";
                }
                cell = getCell(greatestCol.ToString() + j.ToString()).ToString();
                if (cell == "0") { cell = " "; }
                CSVFile += cell;
                CSVFile += "\n";
            }
            return CSVFile;
        }
        public Dictionary<string, expression> data = new Dictionary<string, expression>();//cellaértékek tárolása
        Stack<string> underEvaluation = new Stack<string>();//kiértékelés alatt lévő cellák
        LinkedList<string> toEvaluate;//kiértékelésre váró cellák
    }

    class cellID//cellaazonosítókat kezel
    {
        public cellID(string s)
        {
            lettetPart=s[0];
            numPart=int.Parse(s.Substring(1));
        }
        public static string strTransformCell(cellID ci, int cols, int rows)
        {
            return ((char)(ci.lettetPart + cols)).ToString() + (ci.numPart + rows).ToString();
        }
        public int numPart;
        public char lettetPart;
    }

    abstract class expression//alaposztály
    {
        abstract public expression evaluate();
    }

    class compExp : expression//összetett kifejezés
    {
        public compExp(string s)
        {
            try//ha egyszerű szám akkor (valami+0) alakban tárolja el
            {
                a = new numExp(float.Parse(s));
                b = new numExp(0);
                op = '+';
            }
            catch (FormatException)//az operátorok illetve hivatkozások lekezelése
            { 
                if (s.Contains('+'))
                {
                    int pos = s.IndexOf('+');
                    a = new compExp(s.Substring(0, pos));
                    b = new compExp(s.Substring(pos+1));
                    op = '+';
                }
                else if(s.Contains('-'))
                {
                    int pos = s.LastIndexOf('-');
                    a = new compExp(s.Substring(0, pos));
                    b = new compExp(s.Substring(pos + 1));
                    op = '-';
                }
                else if (s.Contains('*'))
                {
                    int pos = s.IndexOf('*');
                    a = new compExp(s.Substring(0, pos));
                    b = new compExp(s.Substring(pos + 1));
                    op = '*';
                }
                else if (s.Contains('/'))
                {
                    int pos = s.LastIndexOf('/');
                    a = new compExp(s.Substring(0, pos));
                    b = new compExp(s.Substring(pos + 1));
                    op = '/';
                }
                else
                {
                    a = new refExp(s);
                    b = new numExp(0);
                    op = '+';
                }
            }            
        }
        public override expression evaluate()
        {
            expression aEval = a.evaluate();
            expression bEval = b.evaluate();
            if ((aEval is numExp) && (bEval is numExp))
            {
                if (op == '+')
                {
                    return new numExp((aEval as numExp).ToFloat() + (bEval as numExp).ToFloat());
                }
                else if (op == '-')
                {
                    return new numExp((aEval as numExp).ToFloat() - (bEval as numExp).ToFloat());
                }
                else if (op == '*')
                {
                    return new numExp((aEval as numExp).ToFloat() * (bEval as numExp).ToFloat());
                }
                else if (op == '/')
                {
                    if ((bEval as numExp).ToFloat() == 0)
                    {
                        return new errExp("NulOszt");
                    }
                    else
                    {
                        return new numExp((aEval as numExp).ToFloat() / (bEval as numExp).ToFloat());
                    }
                }
                else{return new errExp("IsmOp");}//elérhetetlen sor
            }
            else
            {
                if (aEval is errExp)
                {
                    return aEval;
                }
                else return bEval;                
            }
        }
        expression a;
        expression b;
        char op;
    }

    class numExp : expression//számkifejezés
    {
        public numExp(float f)
        {
            val = f;
        }
        public override expression evaluate()
        {
            return this;
        }
        public override string ToString()
        {
            //return val.ToString();
            return Math.Round(val, 2).ToString();
        }
        public float ToFloat()
        {
            return val;
        }
        float val;
    }

    class refExp : expression//referenciakifejezés
    {
        public refExp(string s)
        {
            val = s;
        }
        public override expression evaluate()
        {
            assignedTable.evaluateCell(val);
            expression exp = assignedTable.getCell(val);
            return exp;

        }
        string val;
        public static cellTable assignedTable;
    }

    class errExp : expression// hibakifejezés
    {
        public errExp(string s)
        {
            err = s;
        }
        public override expression evaluate()
        {
            return this;
        }
        public override string ToString()
        {
            return "#"+err;
        }
        string err;
    }
}


