function HTMLActuator(gm, im) {
	this.gameManager = gm;
	this.inputManager = im;

	this.mentes = $("#board")[0];
	
	this.style_anim = document.createElement("style");
	this.style_anim.type = "text/css";
	this.style_anim.appendChild(document.createTextNode("div#container * {-webkit-animation: initial; animation: initial; -webkit-transition:initial; transition:initial;}"));
	document.head.appendChild(this.style_anim);
	this.style_anim.disabled = true;
	
	this.inputManager.on("animValtozas", this.animValtozas.bind(this));
	this.inputManager.on("fullKeres", this.fullKeres.bind(this));
	this.inputManager.on("fullValtozas", this.fullValtozas.bind(this));
	this.inputManager.on("pause", this.pause.bind(this));
	this.inputManager.on("continue", this.continue.bind(this));
	this.inputManager.on("popupClose", this.popupClose.bind(this));
	this.inputManager.on("start", this.popupClose.bind(this));
	
	this.setRadio("radio_fullscreen", "ki");
	this.setRadio("radio_anim", "be");
	this.setRadio("radio_kattint", "be");
	this.toggleNewGame();
	this.togglePause();
}

HTMLActuator.prototype.generate = function(n){
	var ki = "";
	for(i=0; i<n; i++){
		ki += "<tr>";
		for(j=0; j<n; j++){
			ki += "<td></td><td class=\"aktiv\" id=\"h" + j.toString() + "_" + i.toString() + "\"><div></div><div></div></td>";
		}
		ki += "<td></td></tr><tr>";
		for(j=0; j<n; j++){
			ki += "<td class=\"aktiv\" id=\"v" + j.toString() + "_" + i.toString() + "\"><div></div><div></div></td><td id=\"n" + j.toString() + i.toString() + "\"></td>";
		}
		ki += "<td class=\"aktiv\" id=\"v" + j.toString() + "_" + i.toString() + "\"><div></div><div></div></td></tr>";
	}
	ki += "<tr>";
	for(j=0; j<n; j++){
		ki += "<td></td><td class=\"aktiv\" id=\"h" + j.toString() + "_" + i.toString() + "\"><div></div><div></div></td>";
	}
	ki += "<td></td></tr><tr>";
	
	$("#board")[0].innerHTML = ki;
	$(window).resize();
}

HTMLActuator.prototype.ures = function(){
	$("#board .computer, #board .user").attr("class", "aktiv");
	$("#board .piros").attr("class", "");
}

HTMLActuator.prototype.visszaszamol = function(){
	this.ures();
	setTimeout(function(){this.szam(5);}.bind(this), 0);
	setTimeout(function(){this.szam(4);}.bind(this), 1000);
	setTimeout(function(){this.szam(3);}.bind(this), 2000);
	setTimeout(function(){this.szam(2);}.bind(this), 3000);
	setTimeout(function(){this.szam(1);}.bind(this), 4000);
	setTimeout(function(){this.szam(0);}.bind(this), 5000);
}


HTMLActuator.prototype.szam = function(n){
	var jegyek = [
		{"h": [1, 0, 1], //0
		"v": [1, 1, 1, 1]},
		{"h": [0, 0, 0], //1
		"v": [0, 1, 0, 1]},
		{"h": [1, 1, 1], //2
		"v": [0, 1, 1, 0]},
		{"h": [1, 1, 1], //3
		"v": [0, 1, 0, 1]},
		{"h": [0, 1, 0], //4
		"v": [1, 1, 0, 1]},
		{"h": [1, 1, 1], //5
		"v": [1, 0, 0, 1]}
	];
	
	var x0 = Math.floor((this.gameManager.size-1)/2);
	var y0 = Math.floor((this.gameManager.size-2)/2);
	
	var x, y;
	for(y=0; y<=2; y++){
		if(jegyek[n]["h"][y]){
			$("#h" + x0 + "_" + (y0+y))[0].className = "computer";
		}else{
			$("#h" + x0 + "_" + (y0+y))[0].className = "aktiv";
		}
	}
	var i = 0;
	for(y=0; y<=1; y++){
	for(x=0; x<=1; x++){
		if(jegyek[n]["v"][i]){
			$("#v" + (x0+x) + "_" + (y0+y))[0].className = "computer";
		}else{
			$("#v" + (x0+x) + "_" + (y0+y))[0].className = "aktiv";
		}
		i++;
	}
	}
}


HTMLActuator.prototype.elvesz = function(el, user){
	$("#" + (el.allas?"v":"h") + el.x + "_" + el.y).attr("class", user?"user":"computer");
}

HTMLActuator.prototype.szinez = function(mezok, crit){
	var i;
	for(i in mezok){
		if(mezok[i] == crit){
			$("#n" + i.nullak(2)).addClass("piros");
		}
	}
}

HTMLActuator.prototype.animValtozas = function(enged){
	this.style_anim.disabled = !enged;
}

Number.prototype.nullak = function(size) {
	var s = this.toString();
	while(s.length < size){
		s = "0" + s;
	}
	return s;
}

String.prototype.nullak = function(size) {
	var s = this;
	while(s.length < size){
		s = "0" + s;
	}
	return s;
}

HTMLActuator.prototype.fullKeres = function(enged){
	element = document.documentElement;
	if(enged){
		if(element.requestFullscreen) {
			element.requestFullscreen();
		} else if(element.mozRequestFullScreen) {
			element.mozRequestFullScreen();
		} else if(element.webkitRequestFullscreen) {
			element.webkitRequestFullscreen();
		} else if(element.msRequestFullscreen) {
			element.msRequestFullscreen();
		}
	}else{
		if(document.exitFullscreen) {
			document.exitFullscreen();
		} else if(document.mozCancelFullScreen) {
			document.mozCancelFullScreen();
		} else if(document.webkitExitFullscreen) {
			document.webkitExitFullscreen();
		}
	}
}

HTMLActuator.prototype.fullValtozas = function(be){
	this.setRadio("radio_fullscreen", be?"be":"ki");
}

HTMLActuator.prototype.setRadio = function(name, mire){
	lista = document.getElementsByName(name);
	for(e=0; e<lista.length; e++){
		if(lista[e].value == mire){
			lista[e].checked = true;
		}else{
			lista[e].checked = false;
		}
	}
}

HTMLActuator.prototype.tick = function(){
	$("#time").html((this.gameManager.osszticks/10).toFixed(1));
	$("#time-back").html((5-this.gameManager.ticks/10).toFixed(1));
}

HTMLActuator.prototype.resetProgress = function(delay){
	var elm = $("#time-progress")[0];
	var newone = elm.cloneNode(true);
	elm.parentNode.replaceChild(newone, elm);
	newone.style.animationDelay = delay;
	newone.style.animationPlayState = "running";
	newone.style.webkitAnimationDelay = delay;
	newone.style.webkitAnimationPlayState = "running";
}

HTMLActuator.prototype.toggleProgress = function(megy){
	$("#time-progress")[0].style.animationPlayState = megy?"running":"paused";
	$("#time-progress")[0].style.webkitAnimationPlayState = megy?"running":"paused";
}

HTMLActuator.prototype.toggleNewGame = function(){
	$("#new_game").html(this.gameManager.playing?"Vége":"Új játék");
	if(this.gameManager.playing){
		$("#palyameret_range").attr("disabled", "disabled");
		$("#falak_range").attr("disabled", "disabled");
	}else{
		$("#palyameret_range").removeAttr("disabled");
		$("#falak_range").removeAttr("disabled");
	}
}

HTMLActuator.prototype.togglePause = function(){
	$("#pause").html(this.gameManager.paused?"Folytatás":"Szünet");
	if(this.gameManager.playing){
		$("#pause").css("display", "");
	}else{
		$("#pause").css("display", "none");
	}
}

HTMLActuator.prototype.scoreUpdate = function(){
	$("#score").html(this.gameManager.score);
}

HTMLActuator.prototype.pause = function(){
	this.mentes = $("#board")[0].cloneNode(true);
	this.generate(this.gameManager.size);
}

HTMLActuator.prototype.continue = function(){
	$("#board")[0].parentNode.replaceChild(this.mentes, $("#board")[0]);
}

HTMLActuator.prototype.popup = function(miert){
	var ki = "";
	if(miert=="ido"){
		ki += "<h1>Elfogyott az időd!</h1><p>Csak 5 másodperc áll rendelkezésedre egy fal felhúzására... De ne csüggedj, próbáld újra!</p>";
	}else{
		ki += "<h1>Vége!</h1><p>Befalaztál egy helyiséget, de sebaj, ez a játék csak így érhet véget. Még egy menet?</p>";
	}
	
	ki += "<p>Elért pontszámod: <strong>" + this.gameManager.score + "</strong></p>";
	var ido = (this.gameManager.osszticks/10).perc();
	ki += "<p>Az építkezés összesen <strong>" + ((ido.m>0)?(ido.m + " perc "):"") + ido.s + " másodpercig</strong> tartott.</p>";
	ki += "<span class=\"button close\">Bezárás</span>";
	ki += "<span class=\"button new_game\">Új játék</span>";
	
	ki = "<div><div>" + ki + "</div></div>";
	
	$("#popup")[0].style.animationDelay = (miert=="rossz")? "1s" : "0s";
	$("#popup")[0].style.webkitAnimationDelay = (miert=="rossz")? "1s" : "0s";
	$("#popup").html(ki)[0].className = "show";
}

HTMLActuator.prototype.popupClose = function(){
	$("#popup").attr("class", "");
}


Number.prototype.perc = function() {
	var perc = Math.floor(this/60);
	var sec = (this-perc*60).toFixed(1);
	return {"m":perc, "s":sec};
}
