function InputManager(gm) {
	this.gameManager = gm;
	this.events = {};
	this.lep_event = "click";
	
	this.listen();
	$("#palyameret_range").val(this.gameManager.size);
	$("#falak_range").val(this.gameManager.kezd*2);
	$("#palyameret_range").change();
	$("#falak_range").change();
}

InputManager.prototype.on = function (event, callback) {
	if (!this.events[event]) {
		this.events[event] = [];
	}
	this.events[event].push(callback);
};

InputManager.prototype.emit = function (event, data) {
	var callbacks = this.events[event];
	if(callbacks) {
		callbacks.forEach(function (callback) {
			callback(data);
		});
	}
};

InputManager.prototype.listen = function () {
	self = this;
	$("#container").delegate("td[id^=v].aktiv, td[id^=h].aktiv", "click mousedown", function(e){
		if(self.lep_event == e.type && e.button == 0){
			if(self.gameManager.playing && !self.gameManager.paused){
				id = e.currentTarget.id;
				allas = id.substr(0, 1)=="h" ? 0 : 1;
				id = id.substr(1);
				x = parseInt(id.split("_")[0]);
				y = parseInt(id.split("_")[1]);
				self.emit("lep", {"allas":allas,"x":x,"y":y});
			}
		}
	});
	
	document.getElementById("radio_anim_be").addEventListener("change", this.animValtozas.bind(this));
	document.getElementById("radio_anim_ki").addEventListener("change", this.animValtozas.bind(this));
	
	document.getElementById("radio_fullscreen_be").addEventListener("change", this.fullKeres.bind(this));
	document.getElementById("radio_fullscreen_ki").addEventListener("change", this.fullKeres.bind(this));
	
	document.getElementById("radio_kattint_be").addEventListener("change", this.kattintValtozas.bind(this));
	document.getElementById("radio_kattint_ki").addEventListener("change", this.kattintValtozas.bind(this));
	
	$(document).on('webkitfullscreenchange mozfullscreenchange fullscreenchange',function(){
		if(self.gameManager.playing){self.emit("pause");}
		self.emit("fullValtozas", (document.fullScreen || document.mozFullScreen || document.webkitIsFullScreen));
	});
	
	$(document).delegate("#new_game, .new_game", "click",function(){
		if(self.gameManager.playing){
			self.emit("stop", "user");
		}else{
			self.emit("start");
		}
		
	});
	
	$("#pause").on("click",function(){
		if(self.gameManager.playing){
			if(self.gameManager.paused){
				self.emit("continue");
			}else{
				self.emit("pause");
			}
		}
	});
	
	$(document).keypress(function(e){
		if(self.gameManager.playing){
			if(self.gameManager.paused){
				if(e.key == "c" || e.key=="C" || e.key==" "){
					self.emit("continue");
				}
			}else{
				if(e.key == "p" || e.key=="P" || e.key==" "){
					self.emit("pause");
				}
			}
		}
	});
	
	$("#palyameret_range").on("change input", function(){
		var n = self.getPalya().n;
		$("#palyameret").html(n);
		$("#falak_range").attr("min", 2*n);
		$("#falak_range").attr("max", 4*n);
		$("#falak_range").change();
		//self.emit("palyaValtozas", self.getPalya());
	});
	
	$("#falak_range").on("change input", function(){
		var palya = self.getPalya();
		var k = palya.k;
		$("#falak").html(k);
		if(palya.n != self.gameManager.size || palya.k != self.gameManager.kezd*2){
			self.emit("palyaValtozas", palya);
		}
	});
	
	$("#popup").delegate(".button", "click", function(){
		self.emit("popupClose");
	});
	
	$("#popup").click(function(e){
		if($(e.target).is("#popup>div, #popup")){//háttérre kattintás
			self.emit("popupClose");
		}
	});
};

InputManager.prototype.getPalya = function(){
	var n = Math.floor(parseInt($("#palyameret_range")[0].value));
	n = Math.min(n, 10);
	n = Math.max(n, 7);
	var k = Math.floor(parseInt($("#falak_range")[0].value));
	k = Math.min(k, 4*n);
	k = Math.max(k, 2*n);
	return {"n": n, "k": k};
}

InputManager.prototype.getRadio = function(name){
	lista = document.getElementsByName(name);
	for(e=0; e<lista.length; e++){
		if(lista[e].checked){
			return lista[e].value;
		}
	}
}

InputManager.prototype.animValtozas = function(){
	this.emit("animValtozas", this.getRadio("radio_anim")=="ki");
}

InputManager.prototype.kattintValtozas = function(){
	if(this.getRadio("radio_kattint")=="ki"){
		this.lep_event = "mousedown";
	}else{
		this.lep_event = "click";
	}
}

InputManager.prototype.fullKeres = function(){
	this.emit("fullKeres", this.getRadio("radio_fullscreen")=="be");
}
