/*
+---------+---+---------+---+---------+---+
|   n26   |v36|   n36   |v46|   n46   |v56|
+---------+---+---------+---+---------+---+
|   h27   |   |   h37   |   |   h47   |   |
+---------+---+---------+---+---------+---+
|   n27   |v37|   n37   |v47|   n47   |v57|
+---------+---+---------+---+---------+---+
|   h28   |   |   h38   |   |   h48   |   |
+---------+---+---------+---+---------+---+
|   n28   |v38|   n38   |v48|   n48   |v58|
+---------+---+---------+---+---------+---+
*/

function GameManager(size, kezd){
	this.size			= size; //n
	this.kezd			= kezd; //k
	this.inputManager	= new InputManager(this);
	this.actuator		= new HTMLActuator(this, this.inputManager);
	this.tabla			= new Array;
	this.mezok			= new Array;
	this.elek			= [[], []];
	
	this.playing = false;
	this.paused = false;
	this.timer = 0;
	this.ticks = 0; //ha eléri az 50-et, vége a játéknak
	this.osszticks = 0;
	this.score = 0;
	
	this.onnextTick = function(){};
	
	this.inputManager.on("lep", this.lep.bind(this));
	this.inputManager.on("start", this.start.bind(this));
	this.inputManager.on("stop", this.stop.bind(this));
	this.inputManager.on("pause", this.pause.bind(this));
	this.inputManager.on("continue", this.continue.bind(this));
	this.inputManager.on("palyaValtozas", this.palyaValtozas.bind(this));
	
	this.palyaValtozas({"n":this.size,"k":this.kezd*2});
}

GameManager.prototype.start = function(){
	this.actuator.visszaszamol();
	
	
	setTimeout(function(){
		this.init();
		this.randomize();
		this.playing = true;
		this.paused = false;
	
		this.ticks = 0;
		this.osszticks = 0;
		this.score = 0;
	
		this.actuator.tick();
		this.actuator.resetProgress();
		this.actuator.scoreUpdate();
		this.actuator.toggleNewGame();
		this.actuator.togglePause();
	
		clearInterval(this.timer);
		this.timer = setInterval(this.tick.bind(this),100);
	}.bind(this), 6000);
}

GameManager.prototype.stop = function(miert){
	clearInterval(this.timer);
	this.playing = false;
	this.actuator.toggleProgress(false);
	this.actuator.toggleNewGame();
	this.actuator.togglePause();
	if(miert!="user"){
		this.actuator.popup(miert);
	}
}

GameManager.prototype.pause = function(){
	if(this.playing){
		this.onnextTick = function(){
			clearInterval(this.timer);
			this.paused = true;
			this.actuator.togglePause();
			this.actuator.toggleProgress(false);
		};
	}
}

GameManager.prototype.continue = function(){
	if(this.playing){
		this.timer = setInterval(this.tick.bind(this),100);
		this.paused = false;

		this.actuator.togglePause();
		this.actuator.toggleProgress(true);
	}
}

GameManager.prototype.tick = function(){
	if(this.playing && !this.paused){
		this.ticks++;
		this.osszticks++;
		this.actuator.tick();
		if(this.ticks >= 50){
			this.stop("ido");
		}
	}
	this.onnextTick();
	this.onnextTick = function(){};
}

GameManager.prototype.palyaValtozas = function(data){
	this.size = data.n;
	this.kezd = data.k/2;
	this.actuator.generate(this.size);
	
	var x, y;
	var i = 0;
	for(x=0; x<=1; x++){
	for(y=0; y<=this.size; y++){
		this.actuator.elvesz({"allas":0, "x":x, "y":y});
		i++;
		if(i>=this.kezd){
			x = 42;
			y = 42;
		}
	}
	}
	
	i = 0;
	for(y=0; y<=this.size; y++){
	for(x=3; x<=this.size; x++){
		this.actuator.elvesz({"allas":1, "x":x, "y":y});
		i++;
		if(i>=this.kezd){
			x = 42;
			y = 42;
		}
	}
	}
	
}

GameManager.prototype.init = function(){
	this.tabla			= new Array;
	this.mezok			= new Array;
	this.elek			= [[], []];
	
	this.playing = false;
	this.paused = false;

	var x, y, i;
	var n = this.size;
	var uj;

	for(x=0; x<n; x++){
	for(y=0; y<n; y++){
		i = 10*x+y;
		this.tabla[i] = [];

		//fel
		if(this.benne(x, y-1)){this.tabla[i].push(10*x+y-1);}
		//jobb
		if(this.benne(x+1, y)){this.tabla[i].push((x+1)*10+y);}
		//le
		if(this.benne(x, y+1)){this.tabla[i].push(10*x+y+1);}
		//bal
		if(this.benne(x-1, y)){this.tabla[i].push((x-1)*10+y);}

		
		this.mezok[i] = true;
		
	}
	}
	
	elek = this.elek;
	//h élek
	for(x=0; x<n; x++){
		elek[0][x] = [];
		for(y=0; y<=n; y++){
			elek[0][x][y] = true;
		}
	}
	
	//v élek
	for(x=0; x<=n; x++){
		elek[1][x] = [];
		for(y=0; y<n; y++){
			elek[1][x][y] = true;
		}
	}
	
	this.actuator.generate(this.size);
}



//érvényes-e az index (nagyra)
GameManager.prototype.benne = function(x, y){
	if(y == undefined){
		y = x%10;
		x = Math.floor(x/10);
	}
	return (x>=0 && x<this.size && y>=0 && y<this.size);
}

GameManager.prototype.belsoel = function(el){//nem szegély
	if(el.allas == 0){
		return (el.x>=0 && el.y>0 && el.x<this.size && el.y<this.size);
	}else{
		return (el.x>0 && el.y>=0 && el.x<this.size && el.y<this.size);
	}
}

GameManager.prototype.randomize = function(){
	var k = this.kezd;
	tabla = this.tabla;
	var i, j, x, y;
	var n = this.size;
	
	//vízszintesen
	var sor = []; //az egyes sorokból hányat vettünk el
	for(y=0; y<=n; y++){
		sor[y] = 0;
	}
	for(i=0; i<k; i++){
		y = Math.floor(Math.random() * (n+1));
		while(!( sor[y]<n-1  || ((y==0 || y==n) && sor[y]<n) )){
			y = (y+1)%(n+1);
		}
		
		j = Math.floor(Math.random() * (n-sor[y]));
		for(x=0; x<n; x++){
			if(this.elek[0][x][y]){
				if(j==0){break;}
				j--;
			}
		}
		
		this.elvesz({"allas": 0, "x": x, "y": y});
		
		sor[y]++;
	}
	
	//függőlegesen
	for(i=0; i<k; i++){
		j = Math.floor(Math.random() * n*(n+1));
		while(!(this.elveszProba({"allas": 1, "x": j%(n+1), "y": Math.floor(j/(n+1))}, 1))){
			j = (j+1)%(n*(n+1));
		}
	}
	
	
}

GameManager.prototype.elveszProba = function(el, vegleges, info){//vegleges: 0=soha, 1=ha jó, 2=mindig
	if(this.elek[el.allas][el.x][el.y] != true){return false;}
	
	if(vegleges == 2){
		tabla = this.tabla;
		elek = this.elek;
	}else{
		tabla = $.extend(true, [], this.tabla);
		elek = $.extend(true, [], this.elek);
	}
	
	this.elvesz(el, tabla, elek, (vegleges==2));
	
	if(this.belsoel(el)){
		var s = 10*el.x+el.y;
		if(el.allas == 0){
			cel = s-1;
		}else{
			cel = s-10;
		}
		joe = this.osszefuggo(s, tabla, cel, info);
	}else{
		//joe = this.osszefuggo(undefined, tabla, undefined, info);
		joe = true;
	}
	
	if(vegleges==1 && joe){
		this.elvesz(el);
	}
	
	return joe;
	
	
	
}

GameManager.prototype.elvesz = function(el, tabla, elek, html){
	if(typeof(tabla) !== "object"){tabla = this.tabla;}
	if(typeof(elek) !== "object"){elek = this.elek;}
	
	elek[el.allas][el.x][el.y] = false;
	
	if(this.belsoel(el)){
		a = 10*el.x+el.y;
		if(el.allas == 0){
			b = a-1;
		}else{
			b = a-10;
		}
		if(tabla[a] != undefined){
			i = tabla[a].indexOf(b);
			if(i>=0){tabla[a].splice(i, 1);}
		}
		if(tabla[b] != undefined){
			i = tabla[b].indexOf(a);
			if(i>=0){tabla[b].splice(i, 1);}
		}
	}
	
	if(!(tabla===false || elek===false || html ===false)){this.actuator.elvesz(el, this.playing);}
}

//van-e kapcsolat két mező közt
GameManager.prototype.kapcsolat = function(a, b, tabla){
	if(tabla == undefined){tabla = this.tabla;}
	
	if(!this.benne(a) || !this.benne(b)){return false;}
	
	return (  tabla[a].indexOf(b) >= 0 );
}

GameManager.prototype.osszefuggo = function(s, tabla, cel, info){
	if(s==undefined){s=0;}
	
	const fekete = 0;
	const szurke = 1;
	const feher = 2;
	
	if(tabla == undefined){tabla = this.tabla;}
	var mezok = this.mezok;
	var szin = [];
	var pi = [];
	var d = [];
	var Q = [];
	var darab = 0;

	
	for(u in mezok){
		szin[u] = feher;
		d[u] = Infinity;
		pi[u] = null;
	}
	
	
	szin[s] = szurke;
	d[s] = 0;
	pi[s] = null;
	Q.push(s);
	while(Q.length>0){
		u = Q.shift();
		for(vi in tabla[u]){
			v = tabla[u][vi];
			if(v==cel && cel!=undefined){return true; break;}
			if(szin[v] == feher){
				szin[v] = szurke;
				d[v] = d[u]+1;
				pi[v] = u;
				Q.push(v);
			}
		}
		szin[u] = fekete;
		darab++;
	}
	
	
	if(darab==this.size*this.size){
		return true;
	}else{
		if(typeof(info)=="object"){
			info["szin"] = szin;
			info["darab"] = darab;
		}
		return false;
	}
}

GameManager.prototype.lep = function(el){
	var vege = false;
	if(el!=undefined && this.elek[el.allas][el.x][el.y] == true){
		info = {};
		this.score++;
		if(!this.elveszProba(el, 2, info)){
			this.actuator.szinez(info.szin, (info.darab>Math.pow(this.size,2)/2)?2:0);
			vege = true;
		}
	}
	
	if(!vege){this.ticks = 0;}
	this.actuator.tick();
	
	this.actuator.scoreUpdate();
	
	if(vege){
		this.actuator.toggleProgress(false);
		this.stop("rossz");
	}else{
		this.onnextTick = function(){
			this.actuator.resetProgress("-0.1s");
		};
	}
}

