﻿Public Class i363
    'I. 363.
    'Kovács 246 Benedek
    '10. osztály
    'Budapesti Fazekas Mihály Gyakorló Általános Iskola és Gimnázium
    'benoke98@freemail.hu


    Public AktMod As String 'a program aktuális állapota, lehet menu, jatek, bekeres 
    Public LepesSzam As Integer 'a játékon belüli lépéssorszám
    Public RokaValasztas As Boolean 'ha ez True, akkor a róka játékos jön és a lépő róka még nincs kiválasztva
    Public RokaId As Byte 'a választott róka sorszáma

    Public RokaSor(4), RokaOszlop(4) As Integer 'a rókák koordinátái (sor, oszlop)
    Public NyulSor, NyulOszlop As Integer 'a nyúl koordinátái

    Public Mozgatas_Mit As Byte 'az éppen animálandó kép sorszáma (0=nyúl, 1,2,3,4=rókák)
    Public Mozgatas_SorMerre, Mozgatas_OszlopMerre As Integer 'az animáció irányát határozzák meg, értékük 1 vagy -1
    Public Mozgatas_MaradekPixel As Integer 'a mozgatásból hátralévő pixelek száma

    Public LepesDb As Integer 'a lejátszandó játék lépéseinek száma

    Private Sub i363_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'kezdeti beállítások (ablak betöltése)
        Me.SetBounds(Me.Location.X, Me.Location.Y, 721, Me.Height)
        AktMod = "menu"
        lblAllapot.Text = "Üdvözlöm a Rókák és a nyúl játékban!"
        btnBetoltes.Text = "Visszajátszás mód"
        Mozgatas_MaradekPixel = 0
    End Sub

    Private Sub btnUjJatek_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUjJatek.Click
        AktMod = "jatek"
        Mozgatas_MaradekPixel = 0
        btnBetoltes.Text = "Visszajátszás mód"
        LepesSzam = 1
        txtLepesek.Text = ""

        picNyul.SetBounds(725, 15, 57, 57) 'a nyulat a felrakásig az ablak nem látható részére tesszük

        'Rókák kezdeti elhelyezése
        For i = 1 To 4
            RokaSor(i) = 8
            RokaOszlop(i) = 2 * i
        Next
        picRoka1.SetBounds(tlpTabla.Location.X + 63 * 2 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
        picRoka2.SetBounds(tlpTabla.Location.X + 63 * 4 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
        picRoka3.SetBounds(tlpTabla.Location.X + 63 * 6 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
        picRoka4.SetBounds(tlpTabla.Location.X + 63 * 8 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)

        lblAllapot.Text = "Nyúl játékos, kérem válasszon a felső sorban kezdőhelyet!"
        'Várunk a nyúl kezdőhely-választására
    End Sub

    Public Sub MezoKattint(ByVal Sor As Integer, ByVal Oszlop As Integer)
        'ez az eljárás akkor fut le, ha egy mezőre kattintottak, a paraméterek a mező koordinátái (sor és oszlop)
        If AktMod = "jatek" Then
            If LepesSzam = 1 Then
                If Sor = 1 Then
                    'Nyúl elhelyezése
                    NyulSor = 1
                    NyulOszlop = Oszlop
                    picNyul.SetBounds(tlpTabla.Location.X + 63 * Oszlop - 60, tlpTabla.Location.Y + 63 * 1 - 60, 57, 57)
                    txtLepesek.Text = "1" & Oszlop
                    LepesSzam = 2
                    lblAllapot.Text = "A rókák következnek, válasszon egy rókát!"
                    RokaValasztas = True
                Else
                    lblAllapot.Text = "A nyulat a felső sorba kell tenni!"
                End If
            ElseIf (LepesSzam Mod 2) = 1 Then 'a nyúl jön
                If (Math.Abs(Sor - NyulSor) = 1) And (Math.Abs(Oszlop - NyulOszlop) = 1) Then 'lépés helyességének vizsgálata
                    txtLepesek.Text &= vbCrLf & Sor & Oszlop
                    Mozgat(0, Sor - NyulSor, Oszlop - NyulOszlop)
                    NyulSor = Sor
                    NyulOszlop = Oszlop
                    'Nyerés vizsgálata
                    Dim NyulNyert As Boolean = True
                    Dim I As Integer
                    For I = 1 To 4
                        If RokaSor(I) >= NyulSor Then
                            NyulNyert = False
                            Exit For
                        End If
                    Next
                    If NyulNyert Then
                        lblAllapot.Text = "A nyúl nyert!"
                        AktMod = "menu"
                    Else
                        LepesSzam += 1
                        lblAllapot.Text = "A rókák következnek, válasszon egy rókát!"
                        RokaValasztas = True
                    End If
                Else 'rossz lépés
                    lblAllapot.Text = "Hibás célmező! Kérem, válasszon másikat!"
                End If
            Else 'a rókák jönnek
                If RokaValasztas Then
                    lblAllapot.Text = "Először válasszon egy rókát!"
                Else
                    If (Sor = RokaSor(RokaId) - 1) And (Math.Abs(Oszlop - RokaOszlop(RokaId)) = 1) Then 'lépés helyességének vizsgálata
                        txtLepesek.Text &= vbCrLf & RokaSor(RokaId) & RokaOszlop(RokaId) & IIf(Oszlop > RokaOszlop(RokaId), "J", "B")
                        Mozgat(RokaId, -1, Oszlop - RokaOszlop(RokaId))
                        RokaSor(RokaId) = Sor
                        RokaOszlop(RokaId) = Oszlop

                        'Nyúl nyerésének vizsgálata
                        Dim NyulNyert As Boolean = True
                        Dim I As Integer
                        For I = 1 To 4
                            If RokaSor(I) >= NyulSor Then
                                NyulNyert = False
                                Exit For
                            End If
                        Next

                        'Rókák nyerésének vizsgálata
                        Dim BalFent, BalLent, JobbFent, JobbLent As Boolean 'ezek a változók tárolják, hogy melyik irányokban nem tud a nyúl lépni
                        BalFent = False
                        BalLent = False
                        JobbFent = False
                        JobbLent = False
                        If NyulSor = 1 Then
                            BalFent = True
                            JobbFent = True
                        ElseIf NyulSor = 8 Then
                            BalLent = True
                            JobbLent = True
                        End If
                        If NyulOszlop = 1 Then
                            BalFent = True
                            BalLent = True
                        ElseIf NyulOszlop = 8 Then
                            JobbFent = True
                            JobbLent = True
                        End If
                        For I = 1 To 4
                            If (RokaSor(I) = NyulSor + 1) And (RokaOszlop(I) = NyulOszlop + 1) Then
                                JobbLent = True
                            ElseIf (RokaSor(I) = NyulSor - 1) And (RokaOszlop(I) = NyulOszlop + 1) Then
                                JobbFent = True
                            ElseIf (RokaSor(I) = NyulSor + 1) And (RokaOszlop(I) = NyulOszlop - 1) Then
                                BalLent = True
                            ElseIf (RokaSor(I) = NyulSor - 1) And (RokaOszlop(I) = NyulOszlop - 1) Then
                                BalFent = True
                            End If
                        Next

                        'Ha van győzelem, akkor annak kiírása
                        If NyulNyert Then
                            lblAllapot.Text = "A nyúl nyert!"
                            AktMod = "menu"
                        ElseIf BalFent And BalLent And JobbFent And JobbLent Then
                            lblAllapot.Text = "A rókák nyertek!"
                            AktMod = "menu"
                        Else
                            LepesSzam += 1
                            lblAllapot.Text = "A nyúl következik! Kérem, válasszon célmezőt!"
                        End If
                    Else
                        lblAllapot.Text = "Hibás célmező! Kérem, válasszon másikat!"
                    End If
                End If
            End If
        End If
    End Sub

    Public Sub RokaKattint(ByVal Id As Byte)
        'ez az eljárás akkor fut le, ha egy rókára rákattintottak

        If AktMod = "jatek" Then
            If (LepesSzam Mod 2) = 1 Then
                lblAllapot.Text = "A nyúl van soron!"
            Else
                'Annak vizsgálata, hogy az adott rókával lehet-e lépni
                Dim BalFent, JobbFent As Boolean
                BalFent = False
                JobbFent = False
                If RokaSor(Id) = 1 Then
                    BalFent = True
                    JobbFent = True
                ElseIf RokaOszlop(Id) = 1 Then
                    BalFent = True
                ElseIf RokaOszlop(Id) = 8 Then
                    JobbFent = True
                End If
                If NyulSor = RokaSor(Id) - 1 Then 'ütközés vizsgálata a nyúllal
                    If NyulOszlop = RokaOszlop(Id) - 1 Then
                        BalFent = True
                    ElseIf NyulOszlop = RokaOszlop(Id) + 1 Then
                        JobbFent = True
                    End If
                End If
                For i = 1 To 4 'ütközés vizsgálata a rókákkal
                    If RokaId <> i Then
                        If RokaSor(i) = RokaSor(Id) - 1 Then
                            If RokaOszlop(i) = RokaOszlop(Id) - 1 Then
                                BalFent = True
                            ElseIf RokaOszlop(i) = RokaOszlop(Id) + 1 Then
                                JobbFent = True
                            End If
                        End If
                    End If
                Next
                If BalFent And JobbFent Then
                    lblAllapot.Text = "Ez a róka nem tud lépni. Kérem, válasszon másikat!"
                Else
                    RokaId = Id
                    RokaValasztas = False
                    lblAllapot.Text = "Válassza ki a róka célmezőjét!"
                End If
            End If
        End If
    End Sub

    Public Sub Mozgat(ByVal Mit As Byte, ByVal SorMerre As Integer, ByVal OszlopMerre As Integer)
        'egy adott bábu mozgatása adott irányban
        'Mit = melyik bábut mozgatjuk, 0=nyúl, 1,2,3,4=rókák.
        'SorMerre = 1, ha lefelé és -1, ha felfelé mozgatunk
        'OszlopMerre = 1, ha jobbra és -1, ha balra mozgatunk
        If Mozgatas_MaradekPixel > 0 Then
            'ha még az előző mozgatás nem fejeződött be, akkor annak a végére ugrunk, mielőtt az aktuálisat elkezdenénk
            Dim Kepmezo As PictureBox
            Select Case Mozgatas_Mit
                Case 0
                    Kepmezo = picNyul
                Case 1
                    Kepmezo = picRoka1
                Case 2
                    Kepmezo = picRoka2
                Case 3
                    Kepmezo = picRoka3
                Case 4
                    Kepmezo = picRoka4
            End Select
            Kepmezo.SetBounds(Kepmezo.Location.X + Mozgatas_OszlopMerre * Mozgatas_MaradekPixel, Kepmezo.Location.Y + Mozgatas_SorMerre * Mozgatas_MaradekPixel, Kepmezo.Width, Kepmezo.Height)
            Mozgatas_MaradekPixel = 0
        End If
        Mozgatas_Mit = Mit
        Mozgatas_SorMerre = SorMerre
        Mozgatas_OszlopMerre = OszlopMerre
        Mozgatas_MaradekPixel = 63
        tmrMozgatas.Interval = 15
        tmrMozgatas.Start()
    End Sub

    Private Sub tmrMozgatas_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrMozgatas.Tick
        If AktMod = "szunet" Then
            'visszajátszás módban a szünet vége
            tmrMozgatas.Stop()
            AktMod = "lejatszas"
            If (LepesSzam Mod 2) = 0 Then
                'rókalépés következik
                Dim HonnanSor, HonnanOszlop, RokaId, Irany As Integer
                HonnanSor = Val(txtLepesek.Text.Split(vbLf)(LepesSzam - 1)(0))
                HonnanOszlop = Val(txtLepesek.Text.Split(vbLf)(LepesSzam - 1)(1))
                For I = 1 To 4
                    If RokaSor(I) = HonnanSor And RokaOszlop(I) = HonnanOszlop Then
                        RokaId = I
                        Exit For
                    End If
                Next
                If RokaId = 0 Then
                    lblAllapot.Text = "Hibás bevitel!"
                    MessageBox.Show("A " & LepesSzam & ". sorban érvénytelen kezdőhely szerepel, nincs azon a mezőn róka. Kérem javítsa a bemenetet.", "Hibás bevitel", MessageBoxButtons.OK, MessageBoxIcon.Error)
                    AktMod = "bekeres"
                    btnBetoltes.Text = "Indít"
                    txtLepesek.ReadOnly = False
                    lblAllapot.Text = "Kérem, írja be a lejátszandó lépéseket!"
                    Exit Sub
                End If
                RokaSor(RokaId) -= 1
                Select Case txtLepesek.Text.Split(vbLf)(LepesSzam - 1)(2)
                    Case "B"
                        Irany = -1
                    Case "J"
                        Irany = 1
                    Case Else
                        lblAllapot.Text = "Hibás bevitel!"
                        MessageBox.Show("A " & LepesSzam & ". sorban érvénytelen karakter szerepel. A lejátszás megszakadt, kérem javítsa a bemenetet.", "Hibás bevitel", MessageBoxButtons.OK, MessageBoxIcon.Error)
                        AktMod = "bekeres"
                        btnBetoltes.Text = "Indít"
                        txtLepesek.ReadOnly = False
                        lblAllapot.Text = "Kérem, írja be a lejátszandó lépéseket!"
                        Exit Sub
                End Select
                RokaOszlop(RokaId) += Irany
                Mozgat(RokaId, -1, Irany)
            Else
                'nyúllépés következik
                Dim HovaSor, HovaOszlop As Integer
                HovaSor = Val(txtLepesek.Text.Split(vbLf)(LepesSzam - 1)(0))
                HovaOszlop = Val(txtLepesek.Text.Split(vbLf)(LepesSzam - 1)(1))
                Mozgat(0, HovaSor - NyulSor, HovaOszlop - NyulOszlop)
                NyulSor = HovaSor
                NyulOszlop = HovaOszlop
            End If
        Else
            'az animáció egy lépésének (mindkét irányban 3 pixel) végrehajtása
            Dim Kepmezo As PictureBox
            Select Case Mozgatas_Mit
                Case 0
                    Kepmezo = picNyul
                Case 1
                    Kepmezo = picRoka1
                Case 2
                    Kepmezo = picRoka2
                Case 3
                    Kepmezo = picRoka3
                Case 4
                    Kepmezo = picRoka4
            End Select
            Kepmezo.SetBounds(Kepmezo.Location.X + Mozgatas_OszlopMerre * 3, Kepmezo.Location.Y + Mozgatas_SorMerre * 3, Kepmezo.Width, Kepmezo.Height)
            Mozgatas_MaradekPixel -= 3
            If Mozgatas_MaradekPixel = 0 Then
                tmrMozgatas.Stop()
                If AktMod = "lejatszas" Then
                    If LepesSzam = LepesDb Then
                        lblAllapot.Text = "A lejátszás befejeződött!"
                        AktMod = "bekeres"
                        txtLepesek.ReadOnly = False
                    Else
                        'ha lejátszás módban vagyunk és még nincs vége, akkor tartunk egy 0,4 mp-es szünetet a következő lépés előtt
                        LepesSzam += 1
                        AktMod = "szunet"
                        tmrMozgatas.Interval = 400
                        tmrMozgatas.Start()
                    End If
                End If
            End If
        End If
    End Sub

    'Mezőkattintási események
    Private Sub PictureBox1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox1.Click
        MezoKattint(1, 1)
    End Sub
    Private Sub PictureBox3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox3.Click
        MezoKattint(1, 3)
    End Sub
    Private Sub PictureBox5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox5.Click
        MezoKattint(1, 5)
    End Sub
    Private Sub PictureBox7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox7.Click
        MezoKattint(1, 7)
    End Sub
    Private Sub PictureBox10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox10.Click
        MezoKattint(2, 2)
    End Sub
    Private Sub PictureBox12_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox12.Click
        MezoKattint(2, 4)
    End Sub
    Private Sub PictureBox14_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox14.Click
        MezoKattint(2, 6)
    End Sub
    Private Sub PictureBox16_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox16.Click
        MezoKattint(2, 8)
    End Sub
    Private Sub PictureBox17_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox17.Click
        MezoKattint(3, 1)
    End Sub
    Private Sub PictureBox19_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox19.Click
        MezoKattint(3, 3)
    End Sub
    Private Sub PictureBox21_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox21.Click
        MezoKattint(3, 5)
    End Sub
    Private Sub PictureBox23_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox23.Click
        MezoKattint(3, 7)
    End Sub
    Private Sub PictureBox26_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox26.Click
        MezoKattint(4, 2)
    End Sub
    Private Sub PictureBox28_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox28.Click
        MezoKattint(4, 4)
    End Sub
    Private Sub PictureBox30_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox30.Click
        MezoKattint(4, 6)
    End Sub
    Private Sub PictureBox32_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox32.Click
        MezoKattint(4, 8)
    End Sub
    Private Sub PictureBox33_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox33.Click
        MezoKattint(5, 1)
    End Sub
    Private Sub PictureBox35_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox35.Click
        MezoKattint(5, 3)
    End Sub
    Private Sub PictureBox37_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox37.Click
        MezoKattint(5, 5)
    End Sub
    Private Sub PictureBox39_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox39.Click
        MezoKattint(5, 7)
    End Sub
    Private Sub PictureBox42_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox42.Click
        MezoKattint(6, 2)
    End Sub
    Private Sub PictureBox44_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox44.Click
        MezoKattint(6, 4)
    End Sub
    Private Sub PictureBox46_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox46.Click
        MezoKattint(6, 6)
    End Sub
    Private Sub PictureBox48_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox48.Click
        MezoKattint(6, 8)
    End Sub
    Private Sub PictureBox49_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox49.Click
        MezoKattint(7, 1)
    End Sub
    Private Sub PictureBox51_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox51.Click
        MezoKattint(7, 3)
    End Sub
    Private Sub PictureBox53_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox53.Click
        MezoKattint(7, 5)
    End Sub
    Private Sub PictureBox55_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox55.Click
        MezoKattint(7, 7)
    End Sub
    Private Sub PictureBox58_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox58.Click
        MezoKattint(8, 2)
    End Sub
    Private Sub PictureBox60_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox60.Click
        MezoKattint(8, 4)
    End Sub
    Private Sub PictureBox62_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox62.Click
        MezoKattint(8, 6)
    End Sub
    Private Sub PictureBox64_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PictureBox64.Click
        MezoKattint(8, 8)
    End Sub

    'Rókakép-kattintási események
    Private Sub picRoka1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles picRoka1.Click
        RokaKattint(1)
    End Sub

    Private Sub picRoka2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles picRoka2.Click
        RokaKattint(2)
    End Sub

    Private Sub picRoka3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles picRoka3.Click
        RokaKattint(3)
    End Sub

    Private Sub picRoka4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles picRoka4.Click
        RokaKattint(4)
    End Sub

    Private Sub btnBetoltes_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBetoltes.Click
        Select Case AktMod
            Case "jatek"
                'éppen játék van és azt meg kell szakítani
                If MessageBox.Show("Egy játék éppen folyamatban van. Biztosan átlépjünk visszajátszás módba?", "Biztosan megszakítják a játékot?", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation) = DialogResult.Yes Then
                    AktMod = "bekeres"
                    btnBetoltes.Text = "Indít"
                    txtLepesek.Text = ""
                    txtLepesek.ReadOnly = False
                    Mozgatas_MaradekPixel = 0
                    picRoka1.SetBounds(tlpTabla.Location.X + 63 * 2 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                    picRoka2.SetBounds(tlpTabla.Location.X + 63 * 4 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                    picRoka3.SetBounds(tlpTabla.Location.X + 63 * 6 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                    picRoka4.SetBounds(tlpTabla.Location.X + 63 * 8 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                    picNyul.SetBounds(725, 15, 57, 57) 'a nyulat a lejátszás elkezdéséig az ablak nem látható részére tesszük
                    lblAllapot.Text = "Kérem, írja be a lejátszandó lépéseket!"
                End If
            Case "menu"
                'éppen a menüben vagyunk, ekkor átváltunk bekérő módra (bekérjük a lejátszandó játékot)
                AktMod = "bekeres"
                btnBetoltes.Text = "Indít"
                txtLepesek.Text = ""
                txtLepesek.ReadOnly = False
                Mozgatas_MaradekPixel = 0
                picRoka1.SetBounds(tlpTabla.Location.X + 63 * 2 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                picRoka2.SetBounds(tlpTabla.Location.X + 63 * 4 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                picRoka3.SetBounds(tlpTabla.Location.X + 63 * 6 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                picRoka4.SetBounds(tlpTabla.Location.X + 63 * 8 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                picNyul.SetBounds(725, 15, 57, 57) 'a nyulat a lejátszás elkezdéséig az ablak nem látható részére tesszük
                lblAllapot.Text = "Kérem, írja be a lejátszandó lépéseket!"
            Case "bekeres"
                'éppen a bekérő módban vagyunk, és átváltunk a lépések lejátszására
                If txtLepesek.Text = "" Then
                    MessageBox.Show("A beviteli mező üres!", "Hibás bevitel", MessageBoxButtons.OK, MessageBoxIcon.Error)
                    Exit Sub
                End If
                AktMod = "lejatszas"
                txtLepesek.ReadOnly = True
                'lépések megszámlálása
                LepesDb = txtLepesek.Text.Split(vbLf).Count
                If (txtLepesek.Text.Split(vbLf)(LepesDb - 1) = "") Then
                    LepesDb -= 1
                End If
                LepesSzam = 1
                lblAllapot.Text = "Lépések lejátszása..."

                'Rókák kezdeti elhelyezése
                For i = 1 To 4
                    RokaSor(i) = 8
                    RokaOszlop(i) = 2 * i
                Next
                picRoka1.SetBounds(tlpTabla.Location.X + 63 * 2 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                picRoka2.SetBounds(tlpTabla.Location.X + 63 * 4 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                picRoka3.SetBounds(tlpTabla.Location.X + 63 * 6 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)
                picRoka4.SetBounds(tlpTabla.Location.X + 63 * 8 - 60, tlpTabla.Location.Y + 63 * 8 - 60, 57, 57)

                'Nyúl elhelyezése az első sor alapján
                NyulOszlop = Val(txtLepesek.Text.Split(vbLf)(0)(1))
                NyulSor = 1
                If ((NyulOszlop Mod 2) = 0) Or (NyulOszlop < 1) Or (NyulOszlop > 7) Then
                    lblAllapot.Text = "Hibás bevitel!"
                    MessageBox.Show("Az 1. sorban hibás kezdőhely szerepel. Kérem javítsa a bemenetet.", "Hibás bevitel", MessageBoxButtons.OK, MessageBoxIcon.Error)
                    AktMod = "bekeres"
                    btnBetoltes.Text = "Indít"
                    txtLepesek.ReadOnly = False
                    lblAllapot.Text = "Kérem, írja be a lejátszandó lépéseket!"
                    Exit Sub
                End If
                picNyul.SetBounds(tlpTabla.Location.X + 63 * NyulOszlop - 60, tlpTabla.Location.Y + 63 * 1 - 60, 57, 57)

                If LepesDb >= 2 Then
                    'Második lépés (a rókák első lépésének) megtétele
                    LepesSzam = 2
                    Dim HonnanSor, HonnanOszlop, RokaId, Irany As Integer
                    HonnanSor = Val(txtLepesek.Text.Split(vbLf)(1)(0))
                    HonnanOszlop = Val(txtLepesek.Text.Split(vbLf)(1)(1))
                    For I = 1 To 4
                        If RokaSor(I) = HonnanSor And RokaOszlop(I) = HonnanOszlop Then
                            RokaId = I
                            Exit For
                        End If
                    Next
                    If RokaId = 0 Then
                        lblAllapot.Text = "Hibás bevitel!"
                        MessageBox.Show("A 2. sorban érvénytelen kezdőhely szerepel, nincs azon a mezőn róka. Kérem javítsa a bemenetet.", "Hibás bevitel", MessageBoxButtons.OK, MessageBoxIcon.Error)
                        AktMod = "bekeres"
                        btnBetoltes.Text = "Indít"
                        txtLepesek.ReadOnly = False
                        lblAllapot.Text = "Kérem, írja be a lejátszandó lépéseket!"
                        Exit Sub
                    End If
                    RokaSor(RokaId) -= 1
                    Select Case txtLepesek.Text.Split(vbLf)(1)(2)
                        Case "B"
                            Irany = -1
                        Case "J"
                            Irany = 1
                        Case Else
                            lblAllapot.Text = "Hibás bevitel!"
                            MessageBox.Show("A 2. sorban érvénytelen karakter szerepel. Kérem javítsa a bemenetet.", "Hibás bevitel", MessageBoxButtons.OK, MessageBoxIcon.Error)
                            AktMod = "bekeres"
                            btnBetoltes.Text = "Indít"
                            txtLepesek.ReadOnly = False
                            lblAllapot.Text = "Kérem, írja be a lejátszandó lépéseket!"
                            Exit Sub
                    End Select
                    RokaOszlop(RokaId) += Irany
                    Mozgat(RokaId, -1, Irany)
                Else
                    'csak egy sor volt megadva, ekkor a nyúl elhelyezése után azonnal vége a lejátszásnak
                    lblAllapot.Text = "A lejátszás befejeződött!"
                    AktMod = "bekeres"
                    txtLepesek.ReadOnly = False
                End If
        End Select

    End Sub
End Class
