//i579
//Hinek Milán
//Szolnoki SZC Pálfy-Vízügyi Technikum
//12.E

import { Model, Agent } from "https://vimtaai.github.io/agent/lib/index.js";

//Model properties
const WIDTH = 500;
const HEIGHT = 500;
const SCALE = 2;
//

//Creation of 3 models for the three different curves
const models = [
    new Model({width: WIDTH, height: HEIGHT, scale: SCALE, parentElement: document.getElementById('div1')}),
    new Model({width: WIDTH, height: HEIGHT, scale: SCALE, parentElement: document.getElementById('div2')}),
    new Model({width: WIDTH, height: HEIGHT, scale: SCALE, parentElement: document.getElementById('div3')})
]
//

//Creation of curve containers
const curves = [
    document.getElementById('div1'),
    document.getElementById('div2'),
    document.getElementById('div3'),
];
//

//Default rendering
const defaultSettings = [
    {'length': 500, 'level': 7},
    {'length': 150, 'level': 10},
    {'length': 400, 'level': 10}
]

RenderKoch(defaultSettings[0].length, defaultSettings[0].level);
RenderDragon(defaultSettings[1].length, defaultSettings[1].level);
RenderSierpinski(defaultSettings[2].length, defaultSettings[2].level);
//

//Initialization
curves[1].style.display = 'none';
curves[2].style.display = 'none';

const status_span = document.getElementById('status');
const dropdown = document.getElementById('curve-select');

const length_input = document.getElementById('length');
const level_input = document.getElementById('level');

dropdown.addEventListener('change', SelectionChanged);
document.getElementById('render').addEventListener('click', Render);
//

//Handling selection change
function SelectionChanged() {
    let idx = parseInt(dropdown.selectedIndex);

    for(let i = 0; i < 3; i++) {
        curves[i].style.display = i === idx ? 'block' : 'none';
    }

    length_input.value = defaultSettings[idx].length;
    level_input.value = defaultSettings[idx].level;
}
//

//Rerendering with given length and level
function Render() {
    status_span.style.color = 'red';
    status_span.innerHTML = 'Rendering...';

    setTimeout(() => {
        let length = parseInt(length_input.value);
        let level = parseInt(level_input.value);
    
        switch (dropdown.selectedIndex) {
            case 0: RenderKoch(length, level); break;
            case 1: RenderDragon(length, level); break;
            case 2: RenderSierpinski(length, level); break;
        }
        
        status_span.style.color = 'green';
        status_span.innerHTML = 'Rendering complete';
    }, 1)
}
//

//Curve functions

function RenderKoch(length, level) {
    models[0].clearAgents();
    models[0].clearDrawing();

    const agent = new Agent({x: 0, y: models[0].centerY});
    models[0].addAgent(agent);

    function Koch(length, level) {
        if(level > 0){
            Koch(length / 3, level - 1);
            agent.left(60);

            Koch(length / 3, level - 1);
            agent.right(120);

            Koch(length / 3, level - 1);
            agent.left(60);

            Koch(length / 3, level - 1);
        }
        else {
            agent.forward(length);
        }
    }

    agent.right(90);
    agent.putPenDown();
    Koch(length, level);
}

function RenderDragon(length, level) {
    models[1].clearAgents();
    models[1].clearDrawing();
    const agent = new Agent({x: models[1].centerX, y: models[1].centerY});
    
    models[1].addAgent(agent);
    
    function Dragon(length, level) {
        let body = 'r';
    
        for(let i = 0; i < level; i++) {
            let reverse = body.split('').reverse().join('');
            body += 'r';
            for(let j = 0; j < reverse.length; j++) {
                body += reverse[j] === 'r' ? 'l' : 'r';
            }
            length *= 1 / Math.sqrt(2);
        }
        
        for(let i = 0; i < body.length; i++) {
            if(body[i] === 'r') {
                agent.right(90);
            }
            else {
                agent.left(90);
            }
            
            agent.forward(length);
        }
    }
    
    agent.putPenDown();
    Dragon(length, level);
}

function RenderSierpinski(length, level) {
    models[2].clearAgents();
    models[2].clearDrawing();

    const agent = new Agent({x: WIDTH - 50, y: HEIGHT - 50});

    models[2].addAgent(agent);
    agent.left(90);
    if(level % 2 != 0) agent.heading += 60;

    function Sierpinski(level, length, angle)
    {
        if (level > 0) {
            Sierpinski(level - 1, length / 2, -angle);
            agent.left(angle);
            Sierpinski(level - 1, length / 2, angle);
            agent.left(angle);
            Sierpinski(level - 1, length / 2, -angle);
        } else {
            agent.forward(length);
        }
    }

    agent.putPenDown();
    Sierpinski(level, length, 60);
}
//