//S.82
//Fonyó Viktória
//Keszthely, Vajda J. Gimn., 12. o. t.
//fonyoviki@gmail.com
//Code::Blocks 12.11 (g++ 4.7.1)

#include <iostream>
#include <fstream>
#include <vector>
#include <queue>
#include <algorithm>

using namespace std;

struct BastyaX
{
    int min;
    int max;
    int sorszam;

    bool operator<(const BastyaX& c) const
    {
        return ( max > c.max );
    }
};

struct BastyaY
{
    int min;
    int max;
    int sorszam;

    bool operator<(const BastyaY& c) const //
    {
        return ( max > c.max  );
    }

};
bool xkisebb(const BastyaX& a, const BastyaX& b)
{
    return (a.min < b.min);
}

bool ykisebb(const BastyaY& a,const BastyaY& b)
{
    return (a.min < b.min);
}

int main(int argc, char* argv[])
{
    int N;
    vector<BastyaX> vx; // ebben tároljuk az x-koordinátákat
	vector<BastyaY> vy; // ebben tároljuk az y-koordinátákat
    
    if(argc >= 2) {
		ifstream input;
		input.open(argv[1]);
		input >> N; // beolvassa N-t
		vx.resize(N);
		vy.resize(N);
		for (int i=0; i<N; i++) // adatok beolvasása
		{
			input >> vx[i].min;
			input >> vy[i].min;
			input >> vx[i].max;
			input >> vy[i].max;
			vx[i].sorszam=i;
			vy[i].sorszam=i;
		}
		input.close ();
	}
	else
	{
		cin >> N; // beolvassa N-t
		vx.resize(N);
		vy.resize(N);
		for (int i=0; i<N; i++) // adatok beolvasása
		{
			cin >> vx[i].min;
			cin >> vy[i].min;
			cin >> vx[i].max;
			cin >> vy[i].max;
			vx[i].sorszam=i;
			vy[i].sorszam=i;
		}
	}

    bool lehet=true; //ezzel a logikai változóval azt,tartjuk számon, hogy a rendezés során került-e a megadott intervallumon kívül koordináta

    priority_queue<BastyaX> pqx; // prioritásos sor készítése az x-koordinátákhoz
    priority_queue<BastyaY> pqy; //prioritásos sor az y-koordinátákhoz

    sort(vx.begin(),vx.end(),xkisebb); //az x-koordináták minimuma szerinti rendezése
    sort(vy.begin(),vy.end(),ykisebb);// az y-koordináták minimuma szerinti rendezése

    int a=1; //ez késõbb arra fog kelleni, hogy a sorszámhoz x-koordinátát kössünk
    int b=1; //ez a sorszámhoz való y-koordináta kötéséhez kell

    vector<int> xkord(N); //ebben a tömbben az i. bástya x-koordinátáját fogjuk tárolni
    vector<int> ykord(N); //ebben a tömbnek az i. eleme megadja, hogy az i. bástyának mennyi az y-koordinátája

    int j=0; //a vx elemeit ezzel számoljuk
    int k=0;  //a vy elemeit ezzel számoljuk

    for (int i=1; (i<=N) and (lehet); i++)
    {
        while ( vx[j].min == i) //beletesz minden olyan elemet, aminek a minimuma i
        {
            pqx.push(vx[j]);
            j++;
        }
        if (!pqx.empty())
        {
            if ( pqx.top().max < i)
            {
                lehet=false;
            }
            xkord[ pqx.top().sorszam]=a; //elmenti az a. bástya x koordinátáját
            a++;
            pqx.pop(); //törli a felsõt
        }
        else
        {
            lehet=false;
        }
        while ( vy[k].min == i)
        {
            pqy.push(vy[k]);
            k++;
        }
        if (!pqy.empty())
        {
            if ( pqy.top().max < i)
            {
                lehet=false;
            }
            ykord[ pqy.top().sorszam]=b;
            b++;
            pqy.pop();
        }
        else
        {
            lehet=false;
        }

    }
    ofstream output;
    if ( argc == 3 )
    {
        output.open(argv[2]);
        if (!lehet)
        {
            output << endl << "NEM";
        }
        else
        {
            for (int i=0; i<N; i++)
            {
                output<< xkord[i] <<" " << ykord[i] << endl; //helyes megoldás beleírása a fileba
            }
        }
        output.close();
    }
    else
    {
        if (!lehet)
        {
            cout << "NEM";
        }
        else
        {
            for (int i=0; i<N; i++)
            {
                cout << xkord[i] <<" " << ykord[i] << endl; //helyes megoldás kiiratása
            }
        }
    }
    return 0;
}
