import { Model, Agent } from "https://vimtaai.github.io/agent/lib/index.js";

const model = new Model({ width: 200, height: 150, scale: 5 });
const agent = new Agent();
agent.size = 4;
model.addAgent(agent);
agent.putPenDown();
const koch_szogek = [60,-120,60,0];
var rekurzio_szam = document.getElementById("rekurzio_szam");

function rajzol(melyik)
{
  model.clearDrawing();
  if(rekurzio_szam.value>0) {
    if(melyik==1)
    {
      agent.x=30;
      agent.y=90;
      agent.heading=90;
      koch(rekurzio_szam.value,145);
    }
    if(melyik==2)
    {
      agent.x=60;
      agent.y=90;
      agent.heading=90;
      sarkany(rekurzio_szam.value,100,45);
    }
    if(melyik==3)
    {
      agent.x=35;
      agent.y=120;
      agent.heading=30;
      sierpinski(rekurzio_szam.value,130);
    }
  }
  else {
    alert("Kérlek add meg a rekurzió szintjeinek számát!");
  }
}

function koch(lepes, hossz){  
  if (lepes == 0)
      agent.forward(hossz);
  else {
      for (let i=0;i<4;i++) {
          koch(lepes - 1, hossz /3);
          agent.left(koch_szogek[i]);
      }
  }
}

function sarkany(lepes,hossz,szog)
{
  if(lepes==0)
  {
    agent.forward(hossz);
    return;
  }
  agent.left(szog);
  sarkany(lepes-1,hossz/1.41421,45);
  agent.right(szog*2);
  sarkany(lepes-1,hossz/1.41421,-45);
  agent.left(szog);
}

function sierpinski(lepes,hossz)
{
  if(lepes==0)
    return;
  for(let i=0;i<3;i++)
  {
    sierpinski(lepes-1,hossz/2);
    agent.forward(hossz);
    agent.right(120);
  }
}

document.getElementById("koch").addEventListener("click", () => rajzol(1));
document.getElementById("sarkany").addEventListener("click", () => rajzol(2));
document.getElementById("sierpinski").addEventListener("click", () => rajzol(3));