﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace i384
{
    class classEl
    {
        public classEl(classCsucs pKezdopont, classCsucs pVegpont, bool pIranyitotte)
        {
            myKezdopont = pKezdopont;
            myVegpont = pVegpont;
            myIranyitotte = pIranyitotte;
        }

        public classEl()
        {
            // TODO: Complete member initialization
        }

        private bool myIranyitotte;

        public bool Iranyitotte
        {
            get { return myIranyitotte; }
            set 
            { 
                myIranyitotte = value; 
            }
        }


        private classCsucs myKezdopont;

        public classCsucs Kezdopont
        {
            get { return myKezdopont; }
            set { myKezdopont = value; }
        }


        private classCsucs myVegpont;

        public classCsucs Vegpont
        {
            get { return myVegpont; }
            set { myVegpont = value; }
        }




        internal void Rajzolas(System.Drawing.Graphics g)
        {
            Pen Pen1 = new Pen(Color.Blue, 5);
            g.DrawLine(Pen1, myKezdopont.Hely, myVegpont.Hely);

            if (myIranyitotte)
            {
                Pen Pen = new Pen(Color.Blue, 7);
                Pen.EndCap = LineCap.ArrowAnchor;
                double b1 = myVegpont.Hely.X - myKezdopont.Hely.X;
                double c1 = myVegpont.Hely.Y - myKezdopont.Hely.Y;
                double a1 = Math.Sqrt(Math.Pow(b1, 2) + Math.Pow(c1, 2));
                double a2 = classCsucs.Sugar;
                double arany = a1 / a2;
                double c2 = (c1 / arany);
                double b2 = (b1 / arany);
                Point korSzel = new Point();
                korSzel.X = (int)(myVegpont.Hely.X - b2);
                korSzel.Y = (int)(myVegpont.Hely.Y - c2);

                g.DrawLine(Pen, myKezdopont.Hely, korSzel);

            }
        }

        internal bool Megfelel(classCsucs elsoCsucs, classCsucs masodikCsucs)
        {
            return (myKezdopont == elsoCsucs && myVegpont == masodikCsucs) || (myVegpont == elsoCsucs && myKezdopont == masodikCsucs);
        }

        internal string Leiras()
        {
            return myKezdopont.Sorszam.ToString() + " " + myVegpont.Sorszam.ToString() + " " + this.Iranyitotte.ToString();
        }
    }
}
