﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace i384
{
    public partial class formFoablak : Form
    {
        List<classCsucs> listCsucsok;
        List<classEl> listElek;
        classCsucs kivalasztottCsucs;
        Point egerLeNyomasHelye;

        public formFoablak()
        {
            InitializeComponent();
            listCsucsok = new List<classCsucs>();
            listElek = new List<classEl>();
            this.Width=(int)(Screen.PrimaryScreen.WorkingArea.Width*0.9);
            this.Height = (int)(Screen.PrimaryScreen.WorkingArea.Height * 0.9);
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;
            this.MinimizeBox = false;
            this.MaximizeBox = false;
            this.MouseDown += formFoablak_MouseDown;
            this.MouseUp += formFoablak_MouseUp;
            this.MouseMove += formFoablak_MouseMove;

        }

        void formFoablak_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button==MouseButtons.Left)
            {
                if (kivalasztottCsucs!=null)
                {
                    Point elmozdulas = new Point(e.Location.X - egerLeNyomasHelye.X, e.Location.Y - egerLeNyomasHelye.Y);
                    kivalasztottCsucs.Hely = new PointF(kivalasztottCsucs.Hely.X + elmozdulas.X, kivalasztottCsucs.Hely.Y + elmozdulas.Y);
                    egerLeNyomasHelye=e.Location;
                    KijelolesekTorlese(KijeloltCsucsokKeresese(new classCsucs()));
                    Rajzolas();
                }
            }
        }

        void formFoablak_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right && kivalasztottCsucs != null)
            {
                CsucsraKattintas(kivalasztottCsucs, true);
            }
            else
            {
                if (kivalasztottCsucs != null)
                {
                    CsucsraKattintas(kivalasztottCsucs,false);
                }
            }
            kivalasztottCsucs = null;
        }

        void formFoablak_MouseDown(object sender, MouseEventArgs e)
        {
            kivalasztottCsucs = Csucskereses(e.Location);
            if (kivalasztottCsucs == null)
            {
                CsucsLetrehozasa(e.Location);
            }
            else
            {
                if (e.Button==MouseButtons.Left)
                {
                     egerLeNyomasHelye = e.Location;
                }
                
            }

        }

        private void CsucsraKattintas(classCsucs kivalasztottCsucs, bool Iranyitotte)
        {
            if (kivalasztottCsucs.Kijelolve)
            {
                CsucsTorlese(kivalasztottCsucs);
            }
            kivalasztottCsucs.Kijelolve = true;
            List<classCsucs> kijeloltek = KijeloltCsucsokKeresese(kivalasztottCsucs);
            if (kijeloltek.Count==2)
            {
                List<classEl> torlendok = new List<classEl>();
                foreach (classEl e in listElek)
                {
                    if (e.Megfelel(kijeloltek[0],kijeloltek[1]))
                    {
                        torlendok.Add(e); 
                    }
                }
                foreach (classEl e in torlendok)
                {
                    listElek.Remove(e);
                }
                if (torlendok.Count == 0)
                {
                    ElLetrehozasa(kijeloltek, Iranyitotte);
                }
                    KijelolesekTorlese(kijeloltek);
               
            }
            Rajzolas();
        }

        private void CsucsTorlese(classCsucs kivalasztottCsucs)
        {
            ElekTorlese(kivalasztottCsucs);
            listCsucsok.Remove(kivalasztottCsucs);
            Atszamozas();
        }

        private void ElekTorlese(classCsucs kivalasztottCsucs)
        {
            List<classEl> torlendok = new List<classEl>();
            foreach (classEl e in listElek)
            {
                if (e.Kezdopont == kivalasztottCsucs || e.Vegpont == kivalasztottCsucs)
                {
                    torlendok.Add(e);
                }
            }
            foreach (classEl e in torlendok)
            {
                listElek.Remove(e);
            }
        }

        private void Atszamozas()
        {
            for (int i = 0; i < listCsucsok.Count; i++)
            {
                listCsucsok[i].Sorszam = i;
            }
        }

        private void KijelolesekTorlese(List<classCsucs> kijeloltek)
        {
            foreach (classCsucs cs in kijeloltek)
            {
                cs.Kijelolve = false;
            }
        }

        private List<classCsucs> KijeloltCsucsokKeresese(classCsucs kijelolt)
        {
            List<classCsucs> eredmeny = new List<classCsucs>();
            eredmeny.Add(kijelolt);
            foreach (classCsucs cs in listCsucsok)
            {
                if (cs!=kijelolt && cs.Kijelolve)
                {
                    eredmeny.Add(cs);
                }  
            }
            return eredmeny;
        }

        private void ElLetrehozasa(List<classCsucs> kijeloltCsucsok,bool Iranyitotte)
        {
            classEl ujEl = new classEl(kijeloltCsucsok[1],kijeloltCsucsok[0],Iranyitotte);
            listElek.Add(ujEl);
        }

        private void CsucsLetrehozasa(Point kattintasHelye)
        {
            if (listCsucsok.Count<20)
            {
                classCsucs ujCsucs = new classCsucs(kattintasHelye, listCsucsok.Count);
                listCsucsok.Add(ujCsucs);
                KijelolesekTorlese(KijeloltCsucsokKeresese(new classCsucs()));
                Rajzolas();
            }
        }

        private void Rajzolas()
        {
            Bitmap hatterKep = new Bitmap(this.ClientSize.Width, this.ClientSize.Height);
            Graphics g = Graphics.FromImage(hatterKep);
            foreach (classEl e in listElek)
            {
                e.Rajzolas(g);
            }
            foreach (classCsucs cs in listCsucsok)
            {
                cs.Rajzolas(g);
            }
            g.Save();
            this.BackgroundImage = hatterKep;
        }

        private classCsucs Csucskereses(Point kattintasHelye)
        {     
            foreach (classCsucs cs in listCsucsok)
            {
                if (cs.BenneVan(kattintasHelye))
                {
                    return cs;
                }
            }
            return null;
        }

        private void beolvasásToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void formFoablak_Load(object sender, EventArgs e)
        {

        }

        private void mentésToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            List<String> listFajl;
            listFajl= new List<string>();
            listFajl.Add(listCsucsok.Count.ToString()+" "+listElek.Count.ToString()+" "+this.ClientSize.Height.ToString()+" "+this.ClientSize.Width.ToString());
            foreach (classCsucs cs in listCsucsok)
            {
                listFajl.Add(cs.Leiras());
            }
            foreach (classEl el in listElek)
            {
                listFajl.Add(el.Leiras());
            }
            File.WriteAllLines(Application.StartupPath + "graf.txt", listFajl.ToArray());
            //Process.Start("notepad.exe", Application.StartupPath + "graf.txt");
        }

        private void beolvasásToolStripMenuItem1_Click(object sender, EventArgs e)
        {
           listCsucsok = new List<classCsucs>();
           listElek = new List<classEl>();
           String[] tombFile = File.ReadAllLines(Application.StartupPath + "graf.txt");
           string[] separators= {" "};
           String[] words = tombFile[0].Split(separators,StringSplitOptions.RemoveEmptyEntries);
           int N = Convert.ToInt16(words[0]);
           int E = Convert.ToInt16(words[1]);
           int magassag = Convert.ToInt16(words[2]);
           int szelesseg = Convert.ToInt16(words[3]);
           for (int i = 0; i < N; i++)
           {
               String[] wordsN = tombFile[i+1].Split(separators, StringSplitOptions.RemoveEmptyEntries);
               classCsucs ujElem = new classCsucs(new Point(Convert.ToInt16(wordsN[0]), Convert.ToInt16(wordsN[1])),i);
               listCsucsok.Add(ujElem); 
           }
           for (int i = 0; i < E; i++)
           {
               String[] wordsE = tombFile[i + 1 + N].Split(separators, StringSplitOptions.RemoveEmptyEntries);
               classEl ujEl = new classEl();
               ujEl.Kezdopont = listCsucsok[Convert.ToInt16(wordsE[0])];
               ujEl.Vegpont =listCsucsok[ Convert.ToInt16(wordsE[1])];
               ujEl.Iranyitotte = (wordsE[2].Trim().ToLower()=="true");
               //MessageBox.Show((wordsE[2].Trim().ToLower()=="true").ToString());
               listElek.Add(ujEl);

           }
           Rajzolas();




        }

        private void mentésÉsMegtekintésToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mentésToolStripMenuItem1_Click(sender, e);
            Process.Start("notepad.exe", Application.StartupPath + "graf.txt");
        }

        private void menuStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }
    }
}
