using System;
using System.IO;
using System.Text;
using System.Collections.Generic;
using System.Linq;

namespace i391
{
	public class Program
    {
        /// <summary>
        /// A fák magassága cm-ben. Az első index a sor, a második az oldal: 0 = bal, 1 = jobb.
        /// </summary>
        static int[,] faMagasság;

        /// <summary>
        /// A kimeneti fájlba kerülő szöveg.
        /// </summary>
        static StringBuilder végeredmény;
        
        public static void Main(string[] args)
        {
            végeredmény = new StringBuilder();

            using (StreamReader bemenet = new StreamReader("fak.txt"))
            {
                Beolvasás(bemenet);
            }

            Feladat1();
            Feladat2();
            Feladat3();
            Feladat4();
            Feladat5();
            Feladat6();
            Feladat7();
            
            using (StreamWriter kimenet = new StreamWriter("ubul.txt", false))
            {
                Kiírás(kimenet);
            }
        }

        /// <summary>
        /// A bemeneti adatok beolvasása a megadott bemeneti forrásból.
        /// </summary>
        /// <param name="bemenet">A bemeneti forrás.</param>
        public static void Beolvasás(TextReader bemenet)
        {
            // A fákat soronként olvassuk be, és kettesével tároljuk el először.
            List<Tuple<int, int>> fák = new List<Tuple<int, int>>();

            while (true)
            {
                string sor = bemenet.ReadLine();

                if (string.IsNullOrWhiteSpace(sor))
                {
                    break;
                }

                string[] szavak = sor.Split('\t');

                int balMagasság = int.Parse(szavak[0]);
                int jobbMagasság = int.Parse(szavak[1]);

                fák.Add(new Tuple<int, int>(balMagasság, jobbMagasság));
            }

            // A fák magasságainak áttöltése a kétdimenziós tömbbe.
            faMagasság = new int[fák.Count, 2];

            for (int i = 0; i < fák.Count; i++)
            {
                faMagasság[i, 0] = fák[i].Item1;
                faMagasság[i, 1] = fák[i].Item2;
            }
        }

        /// <summary>
        /// A végeredmény kiírása a megadott kimeneti adatfolyamba.
        /// </summary>
        /// <param name="kimenet">A kimeneti adatfolyam.</param>
        public static void Kiírás(TextWriter kimenet)
        {
            kimenet.Write(végeredmény.ToString());
        }

        /// <summary>
        /// A fasorok számát kiírja a program a standart outputra.
        /// </summary>
        public static void Feladat1()
        {
            Console.WriteLine("1. feladat");
            Console.WriteLine("Az út két oldalán {0}-{0} fa van.", faMagasság.GetLength(0));
        }

        /// <summary>
        /// A fák átlagmagasságát kiszámolja a program (összmagasság / fák száma), majd kiírja oldalanként az ennél magasabb fák számát.
        /// </summary>
        public static void Feladat2()
        {
            Console.WriteLine("2. feladat");

            int összMagasság = 0;

            foreach (int magasság in faMagasság)
            {
                összMagasság += magasság;
            }

            decimal átlagMagasság = összMagasság / (faMagasság.GetLength(0) * 2m);

            Console.WriteLine("Az uborkafák átlagos magassága {0:.##} cm.", átlagMagasság);

            int[] magasabbFákSzáma = new int[2];

            for (int i = 0; i < faMagasság.GetLength(0); i++)
            {
                for (int j = 0; j < 2; j++)
                {
                    if (faMagasság[i, j] > átlagMagasság)
                    {
                        magasabbFákSzáma[j]++;
                    }
                }
            }

            Console.WriteLine("A bal oldalon {0}, a jobb oldalon {1} átlagosnál magasabb fa van.", magasabbFákSzáma[0], magasabbFákSzáma[1]);
        }

        /// <summary>
        /// Először a program meghatározza a legmagasabb fa magasságát. Ezután listába gyűjti az ilyen magasságú fákat, majd ezeket kiírja a standard outputra.
        /// </summary>
        public static void Feladat3()
        {
            Console.WriteLine("3. feladat");

            int legmagasabbFa = int.MinValue;

            foreach (int magasság in faMagasság)
            {
                legmagasabbFa = Math.Max(magasság, legmagasabbFa);
            }

            List<Tuple<int,int>> legmagasabbFák = new List<Tuple<int, int>>();

            for (int i = 0; i < faMagasság.GetLength(0); i++)
            {
                for (int j = 0; j < 2; j++)
                {
                    if (faMagasság[i, j] == legmagasabbFa)
                    {
                        legmagasabbFák.Add(new Tuple<int, int>(i, j));
                    }
                }
            }

            Console.WriteLine("Az intézet büszkesége{0} {1} cm magas{2}. Koordinátá{3}: {4}",
                              legmagasabbFák.Count > 1 ? "i" : "",
                              legmagasabbFa,
                              legmagasabbFák.Count > 1 ? "ak" : "",
                              legmagasabbFák.Count > 1 ? "ik" : "ja",
                              string.Join(" ", legmagasabbFák.Select(t => Koordináták(t.Item1, t.Item2))));
        }

        /// <summary>
        /// A program először listába gyűjti a szégyenfákat, majd meghatározza a legmagasabb szégyenfát, ezután listába gyűjti az ilyen magas szégyenfákat, és kiírja őket a standard outputra.
        /// </summary>
        public static void Feladat4()
        {
            Console.WriteLine("4. feladat");

            List<Tuple<int,int>> szégyenek = new List<Tuple<int, int>>();

            for (int i = 1; i < faMagasság.GetLength(0) - 1; i++)
            {
                for (int j = 0; j < 2; j++)
                {
                    if (faMagasság[i, j] < faMagasság[i - 1, j] && faMagasság[i, j] < faMagasság[i + 1, j])
                    {
                        szégyenek.Add(new Tuple<int, int>(i, j));
                    }
                }
            }

            int legmagasabbSzégyen = szégyenek.Select(t => faMagasság[t.Item1, t.Item2]).Max();

            List<Tuple<int, int>> legmagasabbSzégyenek = szégyenek.Where(t => faMagasság[t.Item1, t.Item2] == legmagasabbSzégyen).ToList();

            Console.WriteLine("Az intézet szégyene{0} {1} cm magas{2}. Koordinátá{3}: {4}",
                              legmagasabbSzégyenek.Count > 1 ? "i" : "",
                              legmagasabbSzégyen,
                              legmagasabbSzégyenek.Count > 1 ? "ak" : "",
                              legmagasabbSzégyenek.Count > 1 ? "ik" : "ja",
                              string.Join(" ", legmagasabbSzégyenek.Select(t => Koordináták(t.Item1, t.Item2))));
        }

        /// <summary>
        /// A program először létrehoz egy listát a faindexekről, majd ezt magasság szerinti csökkenő sorrendbe rendezi.
        /// Ezután kiválasztja a 10 legmagasabb fát, és ezeket kiírja a standard outputra.
        /// </summary>
        public static void Feladat5()
        {
            Console.Write("5. feladat: Az első 10 fa adatai:");

            List<Tuple<int,int>> fák = new List<Tuple<int, int>>();

            for (int i = 0; i < faMagasság.GetLength(0); i++)
            {
                for (int j = 0; j < 2; j++)
                {
                    fák.Add(new Tuple<int, int>(i, j));
                }
            }

            fák = fák.OrderByDescending(t => faMagasság[t.Item1, t.Item2]).ToList();

            List<Tuple<int,int>> top10fa = fák.Take(10).ToList();

            int előzőMagasság = -1;

            for (int i = 0; i < 10; i++)
            {
                var fa = top10fa[i];

                if (faMagasság[fa.Item1, fa.Item2] != előzőMagasság)
                {
                    Console.Write("{0}{1}\t{2} cm,", előzőMagasság == -1 ? "" : ",", Environment.NewLine, faMagasság[fa.Item1,fa.Item2]);
                }

                Console.Write(" {0}", Koordináták(fa.Item1, fa.Item2));

                előzőMagasság = faMagasság[fa.Item1, fa.Item2];
            }

            Console.WriteLine(".");
        }

        /// <summary>
        /// A majom addig lépeget, amíg az utolsó sorba nem kerül. Ha volt már a másik oldalon, vagy a sorban következő fa magasabb a másik oldalon levőnél, akkor a sorban megy tovább.
        /// Ellenkező esetben átugrik a másik oldalra. Az utolsó sor elérése után még átugrik a másik fára, ezzel fejezi be szökdécselését.
        /// </summary>
        public static void Feladat6()
        {
            int sor = 0;
            int oldal = 0;
            bool voltMárAMásikOldalon = false;

            végeredmény.Append("1B");

            do
            {
                int másikOldal = oldal == 0 ? 1 : 0;

                if (voltMárAMásikOldalon || faMagasság[sor + 1, oldal] >= faMagasság[sor, másikOldal])
                {
                    sor++;
                    voltMárAMásikOldalon = false;
                }
                else
                {
                    oldal = másikOldal;
                    voltMárAMásikOldalon = true;
                }

                végeredmény.AppendFormat(" {0}", Koordináták(sor, oldal));
            }
            while (sor < faMagasság.GetLength(0) - 1);

            végeredmény.AppendFormat(" {0}", Koordináták(sor, oldal == 0 ? 1 : 0));

            végeredmény.AppendLine();
        }

        /// <summary>
        /// A majom addig lépeget, amíg az utolsó sorba nem kerül. Csak akkor ugrik át a másik oldalra, ha még nem volt ott, a másik oldal jó, és a sorban következő fa nem jó.
        /// Ellenkező esetben a sorban következő fára ugrik. Az utolsó sor elérése után még átugrik a másik fára, ezzel fejezi be szökdécselését.
        /// Egy fa akkor jó, hogyha megyegyezik az igazsága annak, hogy a majom felmegy, illetve a fa magasabb. A majom akkor vált irányt, ha egyik fa sem jó.
        /// A szintkülönbséget a program kiszámolja a következő és a jelenlegi fa magasságkülönbségeként. A szintkülönbséget a program előjeltől függően adja hozzá a megfelelő változóhoz.
        /// </summary>
        public static void Feladat7()
        {
            int sor = 0;
            int oldal = 0;
            bool voltMárAMásikOldalon = false;
            bool felmegy = true;

            végeredmény.Append("1B");

            int útFel = 0;
            int útLe = 0;

            do
            {
                int másikOldal = oldal == 0 ? 1 : 0;

                bool másikOldalJó = !(faMagasság[sor, másikOldal] > faMagasság[sor, oldal]) ^ felmegy;
                bool következőSorJó = !(faMagasság[sor + 1, oldal] > faMagasság[sor, oldal]) ^ felmegy;

                bool monotonitásMarad = másikOldalJó || következőSorJó;

                felmegy ^= !monotonitásMarad;

                int szintkülönbség;

                if (!voltMárAMásikOldalon && másikOldalJó && !következőSorJó)
                {
                    szintkülönbség = faMagasság[sor, másikOldal] - faMagasság[sor, oldal];

                    oldal = másikOldal;
                    voltMárAMásikOldalon = true;
                }
                else
                {
                    szintkülönbség = faMagasság[sor + 1, oldal] - faMagasság[sor, oldal];

                    sor++;
                    voltMárAMásikOldalon = false;
                }

                if (szintkülönbség > 0)
                {
                    útFel += szintkülönbség;
                }
                else
                {
                    útLe -= szintkülönbség;
                }

                végeredmény.AppendFormat(" {0}", Koordináták(sor, oldal));
            }
            while (sor < faMagasság.GetLength(0) - 1);

            int szintKülönbség = faMagasság[sor, oldal == 0 ? 1 : 0] - faMagasság[sor, oldal];

            if (szintKülönbség > 0)
            {
                útFel += szintKülönbség;
            }
            else
            {
                útLe -= szintKülönbség;
            }

            végeredmény.AppendFormat(" {0}", Koordináták(sor, oldal == 0 ? 1 : 0));

            végeredmény.AppendFormat("{0}{1} {2}", Environment.NewLine, útFel, útLe);
        }

        /// <summary>
        /// Visszaadja a megadott fa koordinátájáit.
        /// </summary>
        /// <param name="sor">A fa sora.</param>
        /// <param name="oldal">A fa oldala. (0 = bal, 1 = jobb)</param>
        public static string Koordináták(int sor,int oldal)
        {
            return string.Format("{0}{1}", sor + 1, oldal == 0 ? "B" : "J");
        }
    }
}