/* -*- mode: C++; encoding: utf-8 -*-
 *
 * S. 42.
 * Kővágó Zoltán
 * Budapest, Szent István Gimnázium
 * ***
 * gcc version 4.3.3 (Gentoo 4.3.3 p1.0, pie-10.1.5)
 */

#include <iostream>
#include <vector>
#include <map>
#include <cstdlib>

// hibakeresési kimenet engedélyezése
//#define DEBUG

typedef std::vector<unsigned int> Vector;
typedef std::map<char, void(*)(unsigned int*, unsigned int*)> Map;

// tábla szélessége
unsigned int w;
// a tábla maga
Vector v;


// minimum magasság megkeresése
unsigned int GetMinH()
{
	unsigned int min = v[0];
	for (int i = 1; i < w; ++i)
	{
		if (v[i] < min)
			min = v[i];
	}
	return min;
}

// egy általánosított függvény, mely eldönti, az éppen aktuális lehetőség
// jobb-e, mint az idáig legjobb.
static inline bool Ded(const unsigned int b, const unsigned int h,
					   unsigned int& fb, unsigned int& fh)
{
	// a testeléseim során a 10:7-os arány tűnt a legmegfelelőbbnek, 10:8 és
	// felett túlságosan sok lyuk maradt, 10:6 és alatt pedig erőteljesebbek
	// lett az a hatás, hogy néhány oszlop igen magas, a többi pedig alacsony.
	if ((fh == (unsigned int) -1) || ((b * 10 + h * 7) < (fb * 10 + fh * 7)))
	{
		fb = b; fh = h; return true;
	}
	return false;
}

// 'o' elem kezelése
void DoO(unsigned int * pos, unsigned int * rot)
{
	// p: legjobb pozíció
	// h: magasság
	// b: mennyi négyzet marad használaton kívül
	unsigned int p, b = -1, h = -1;
	unsigned int minh = GetMinH();
	for (int i = 0; i < w - 1; ++i)
	{
		int bthis = v[i]-v[i+1];
		if (bthis < 0) bthis *= -1;
		unsigned int hthis = std::max(v[i], v[i+1]);

		// ha így is nagyon rossz a helyzet, akkor nem foglalkozunk a minimális
		// magassággal.
		if (Ded(bthis, hthis, b, h))
			p = i;
	}
	v[p] = h+2; v[p+1] = h + 2;

	*pos = p;
	*rot = 0;
}

// 'i' elem kezelése
void DoI(unsigned int * pos, unsigned int * rot)
{
	int fp = -1, fh = -1;
	// fektetett állapot megnézése - de csak ha van hely
	if (w >= 4)
		for (int i = 0; i < w - 3; ++i)
			if (v[i] == v[i+1] && v[i+1] == v[i+2] && v[i+2] == v[i+3])
			{
				/*v[i] += 1; v[i+1] += 1; v[i+2] += 1; v[i+3] += 1;
				*pos = i;
				*rot = 0;
				return;*/
				if (v[i] < (unsigned int)fh)
				{
					fp = i; fh = v[i];
				}
			}

	// megnézzük az álló esetet is
	unsigned int h = -1, b = -1, p;
	for (int i = 0; i < w; ++i)
	{
		unsigned int bthis = (i > 0 ? v[i-1] : 0) + (i < w ? v[i+1] : 0);
		if (v[i] < h || (v[i] == h && bthis < b))
		{
			h = v[i]; b = bthis; p = i;
		}
	}

	// most eldöntjük hogy álló legyen vagy fekvő.
	// ha nincs jó fekvő állapot, akkor álló lesz
	// ha a fekvő jóval magasabbra kerülne, mint az álló, szintén álló lesz
	if ((fp == -1) || (fh - h) > 5)
	{
		v[p] += 4;
		*pos = p;
		*rot = 90;
	}
	else
	{
		v[fp] += 1; v[fp+1] += 1; v[fp+2] += 1; v[fp+3] += 1;
		*pos = fp;
		*rot = 0;
	}
}

// 's' és 'z' elem esete
void DoSZ(bool z, unsigned int * pos, unsigned int * rot)
{
	unsigned int fp = -1, fh = -1, fb = -1;
	unsigned int minh = GetMinH();
	// "forgatlan" eset megnézése
	for (int i = 0; i < w-2; ++i)
	{
		// magasság, és használhatatlanná tett mezők számítása
		unsigned int th = std::max(v[i] - (z ? 1 : 0),
								   std::max(v[i+1], v[i+2] - (z ? 0 : 1)));
		unsigned int tb = (th + (z ? 1 : 0) - v[i]) + (th - v[i+1]) +
			(th + (z ? 0 : 1) - v[i+2]);

		if (Ded(tb, th, fb, fh))
			fp = i;
	}

	unsigned int ep = -1, eh = -1, eb = -1;
	// elforgatott eset szemrevételezése
	for (int i = 0; i < w-1; ++i)
	{
		unsigned int th = std::max(v[i] - (z ? 0 : 1), v[i+1] - (z ? 1 : 0));
		unsigned int tb = (th + (z ? 0 : 1) - v[i]) + (th + (z ? 1 : 0) - v[i+1]);
		if (Ded(tb, th, eb, eh))
			ep = i;
	}

	// megnézzük, forgassunk-e, vagy sem
	if (fb < eb || (fb == eb && fh < eh))
	{
		*pos = fp; *rot = 0;
		v[fp] = fh + (z ? 2 : 1);
		v[fp+1] = fh + 2;
		v[fp+2] = fh + (z ? 1 : 2);
	}
	else
	{
		*pos = ep; *rot = 90;
		v[ep] = eh + (z ? 2 : 3);
		v[ep+1] = eh + (z ? 3 : 2);
	}
}

void DoS(unsigned int * pos, unsigned int * rot)
{
	DoSZ(false, pos, rot);
}
void DoZ(unsigned int * pos, unsigned int * rot)
{
	DoSZ(true, pos, rot);
}

// később, sok ismétlés elkerülése végett
#define CHK(elo, rot)							\
	if (Ded(elo##b, elo##h, fb, fh))			\
	{											\
		fp = i; fr = rot;						\
	}


// 'j' és 'l' elem megnézése
void DoJL(bool l, unsigned int * pos, unsigned int * rot)
{
	// itt már 4-féle forgatás lehetséges
	// először 0 és 180°-os forgatás
	unsigned int fp = -1, fh = -1, fb = -1, fr = -1;
	unsigned int minh = GetMinH();
	for (int i = 0; i < w-2; ++i)
	{
		unsigned int t0h, t1h, t0b, t1b;

		t0h = std::max(v[i], std::max(v[i+1], v[i+2]));
		t0b = (t0h - v[i]) + (t0h - v[i+1]) + (t0h - v[i+2]);

		t1h = std::max(v[i] - (l ? 0 : 1),
					   std::max(v[i+1] - 1, v[i+2] - (l ? 1 : 0)));
		t1b = (t1h + (l ? 0 : 1) - v[i]) + (t1h + 1 - v[i+1]) +
			(t1h + (l ? 1 : 0) - v[i+2]);

		CHK(t0, 0);
		CHK(t1, 180);
	}

	// végül megnézzük a 90° és 270° forgatást is.
	for (int i = 0; i < w-1; ++i)
	{
		unsigned int t9h, t9b, t2h, t2b;

		t9h = std::max(v[i] - (l ? 2 : 0), v[i+1]);
		t9b = (t9h + (l ? 2 : 0) - v[i]) + (t9h - v[i+1]);

		t2h = std::max(v[i], v[i+1] - (l ? 0 : 2));
		t2b = (t2h - v[i]) + (t2h + (l ? 0 : 2) - v[i+1]);

		CHK(t9, 90);
		CHK(t2, 270);
	}

	// letárolni az alakzatot mint valami bitkép, és azt elforgatni, majd abból
	// számolni ezeket az értékeket szebb lenne; de akkor feljebb is azt kéne
	// használni, másrész ez így valószínüleg sokkal gyorsabb.
	switch (fr)
	{
	case 0:
		v[fp] = fh + (l ? 1 : 2);
		v[fp+1] = fh + 1;
		v[fp+2] = fh + (l ? 2 : 1);
		break;
	case 90:
		v[fp] = fh + (l ? 3 : 1);
		v[fp+1] = fh + 3;
		break;
	case 180:
		v[fp] = fh + 2;
		v[fp+1] = fh + 2;
		v[fp+2] = fh + 2;
		break;
	case 270:
		v[fp] = fh + 3;
		v[fp+1] = fh + (l ? 1 : 3);
	}

	*pos = fp;
	*rot = fr;
}
#undef CHK


void DoJ(unsigned int * pos, unsigned int * rot)
{
	DoJL(false, pos, rot);
}
void DoL(unsigned int * pos, unsigned int * rot)
{
	DoJL(true, pos, rot);
}


///////////////////////////////////////////////////////////////////////////////

int main()
{
	std::string ins;
	std::cin >> ins;
	if (ins != "start")
	{
		std::cerr << "Eervenytelen bemenet `" << ins << "`.\n";
		return 1;
	}
	// szélesség bekérése
	std::cin >> w;

	// w nagyságú vector inicializálása
	v.reserve(w);
	for (int i = 0; i < w; ++i)
	{
		v.push_back(0);
	}

	// az elérhető elemeket tartalmazza, betű->hozzá tartozó funkció
	Map m;
	m['o'] = DoO;
	m['j'] = DoJ;
	m['l'] = DoL;
	m['s'] = DoS;
	m['z'] = DoZ;
	m['i'] = DoI;

	for (int i = 0; ; ++i)
	{
		// bemenet + ellenőrzés
		std::cin >> ins;
		if (ins != "item")
		{
			std::cerr << "Ervenytelen bemenet `" << ins << "`.\n";
			return 1;
		}
		char c;
		std::cin >> c;

		if (!m.count(c))
		{
			std::cerr << "Ervenytelen item " << c << ".\n";
			return 1;
		}
		unsigned int p, r;
		m[c](&p, &r);
		std::cout << "pos " << p+1 << " " << r << std::endl;

#ifdef DEBUG
		std::cerr << "v dump: ";
		for (int j = 0; j < w; ++j)
			std::cerr << v[j] << " ";
		std::cerr << std::endl;
#endif

		// egy idő után "normalizáljuk" a magasságokat
		if (i >= 100)
		{
			unsigned int min = v[0];
			for (int j = 1; j < w; ++j)
				if (v[j] < min)
					min = v[j];

			for (int j = 0; j < w; ++j)
				v[j] -= min;
			i = 0;
		}
	}
}
