/*
	S. 64.
	Adrián Patrik, 12. évf.
	Baross Gábor Középiskola, Szakiskola és Kollégium, Debrecen
*/

#include <stdio.h>
// A fa ábrázolásához maximálisan szükséges tömb mérete (kerekítve)
#define MAXN 1050000

// A fa egy csúcsa
typedef struct NODE
{
	// A csúcsban tárolt tömbelem értéke
	unsigned value;
	// A bal oldali részfa magassága
	unsigned height;
	// A bal oldali részfában tárolt elemek száma
	unsigned left_count;
	// A teljes részfában tárolt elemek száma
	unsigned count;
	// A bal és jobb oldali részfák mutatói
	struct NODE *left, *right;
} NODE;

// Az eredeti tömb elemeinek száma
int N;

// A fa csúcsai (statikusan foglalunk, így gyorsabb) és gyökere
NODE nodes[MAXN + 1], *root = nodes + 1;

// A tömbből utoljára törölt érték; a törlési algoritmushoz kell
unsigned last_removed_value;

// Az összes megmaradt érték összege
unsigned long long sum;

// Visszaadja a két érték közül a nagyobbat
unsigned max(unsigned a, unsigned b)
{
	return a > b ? a : b;
}

// Megépíti a fát
NODE* build(unsigned start, unsigned end, unsigned pos)
{
	unsigned mid = (start + end) / 2;
	NODE *this = nodes + pos;
	
	// Bal oldali részfa
	if(start < mid)
	{
		this -> left = build(start, mid - 1, 2 * pos);
		this -> height = this -> left -> height;
		this -> left_count += this -> left -> count;
		this -> count = this -> left_count;
	}
	else
	{
		this -> left = NULL;
		this -> height = 0;
	}
	
	// Beolvassuk a tömbelem értékét
	scanf("%u", &(this -> value));
	sum += this -> value;
	
	// Jobb oldali részfa
	if(mid < end)
	{
		this -> right = build(mid + 1, end, 2 * pos + 1);
		this -> height = max(this -> height, this -> right -> height);
		this -> count += this -> right -> count;
	}
	else
		this -> right = NULL;

	this -> height ++;
	this -> count ++;

	return this;
}

// Törli a fa pos-adik elemét
NODE* delete(NODE *node, unsigned pos)
{
	unsigned lc = node -> left_count;
	// Ha a bal részfában van
	if(lc >= pos)
	{
		node -> left = delete(node -> left, pos);
		node -> left_count --;
		node -> count --;
		return node;
	}
	// Ha a jobb oldaliban
	else if(lc + 1 < pos)
	{
		node -> right = delete(node -> right, pos - lc - 1);
		node -> count --;
		return node;
	}

	sum -= node -> value;

	// Nincs bal részfa
	if(node -> left == NULL)
	{
		last_removed_value = node -> value;
		return node -> right;
	}
	// Nincs jobb részfa
	else if(node -> right == NULL)
	{
		return node -> left;
	}
	// Mindkét részfa van
	else
	{
		// A jobb oldali első elemét töröljük
		node -> right = delete(node -> right, 1);
		// Átültetjük a gyökérbe az utoljára törölt elemet
		node -> value = last_removed_value;
		// Visszaírjuk  az összegbe
		sum += last_removed_value;
	}

	return node;
}

int main(int argc, char *argv[])
{
	// A törlések száma
	unsigned K;
	// Segédváltozók
	unsigned i, p;
	
	scanf("%u %u\n", &N, &K);
		
	// Létrehozzuk a fát
	build(1, N, 1);
	
	// Elvégezzük a törléseket
	for(i = 0; i < K; i ++)
	{
		scanf("%u", &p);
		root = delete(root, p);
	}

	// Kiírjuk az eredményt
	printf("%llu\n", sum);

	return 0;
}
