/* S. 70.
   Szabó 928 Attila 11.o.t.
   Pécs, Leőwey Klára Gimn.
   szabo.attila94@gmail.com
*/
#include <stdio.h>
#define Nmax 1000
#define Mmax 5000

int N,M,A,B,W; //W a különböző hosszúságú élek hossza
int graph[Mmax][3]; //éllista
int neighbor[2*Mmax][2], neigh_index[Nmax+1]; //szomszédsági mátrix kompakt formában
int lengths[Mmax], aux[Mmax]; //a különböző élhosszak nagyság szerinti sorban; általános segédtömb
char found[Nmax];//segédtömb a mélységi kereséshez

void readin(void); //prototípusok
int min_diff(void);
void heapsort(void);
void preprocess(void); 
char connected(int min_index, int max_index);

int main(int argc, char *argv[]){
	readin(); 
	preprocess(); 
	printf("%d",min_diff()); 
	return 0;
}

void readin(void){// beolvasás a bemenetről
	int i; 
	scanf("%d%d",&N,&M); 
	scanf("%d%d",&A,&B); 
	for(i=0;i<N;i++){ neigh_index[i+1]=0; aux[i]=0; } 
	for(i=0;i<M;i++){ 
		scanf("%d%d%d",&graph[i][1],&graph[i][2],&graph[i][0]); 
		neigh_index[graph[i][1]+1]++; neigh_index[graph[i][2]+1]++; 
	} 
}

void preprocess(void){//a beolvasott adatok feldolgozása
	int i,j; //segédváltozók
	neigh_index[0]=0;
	for(i=0;i<N;i++){ neigh_index[i+1]+=neigh_index[i]; } //neigh_index végleges kialakítása
	for(i=0;i<M;i++){ //neighbor kitöltése
		j=neigh_index[graph[i][1]]+aux[graph[i][1]];
		neighbor[j][1]=graph[i][2]; neighbor[j][0]=graph[i][0];
		j=neigh_index[graph[i][2]]+aux[graph[i][2]];
		neighbor[j][1]=graph[i][1]; neighbor[j][0]=graph[i][0];
		aux[graph[i][1]]++; aux[graph[i][2]]++; //aux az egyes csúcsok megtalált szomszédjait tárolja
	}
	for(i=0;i<M;i++){ aux[i]=graph[i][0]; }  //aux az élek hossza
	heapsort(); //az élhosszak rendezése
	W=1; lengths[0]=aux[0];
	for(i=1;i<M;i++){
		if(aux[i]!=aux[i-1]){
			lengths[W]=aux[i]; W++; //az ismétlődő hosszak eltávolítása
		}
	}
}

void heapsort(void){//kupacrendezés
	int swap,i,p,q; //segédváltozók
	//kupacrendezés - kupac felépítése
	for(i=1;i<M;i++){
		p=i; q=(i-1)/2; //kupacba
		while((p>0)&&aux[q]<aux[p]){ 
			swap=aux[p];
			aux[p]=aux[q];
			aux[q]=swap;
			p=q; q=(q-1)/2;
		}
	}
	//kupacrendezés - rendezett tömb felépítése
	for(i=M;i>1;i--){
		swap=aux[0]; //kupacból
		aux[0]=aux[i-1];
		aux[i-1]=swap;
		p=0;
		//le kell állítani a kupac leveleinél
		while(aux[p]<((2*p+1<i-1)?aux[2*p+1]:0)||aux[p]<((2*p+2<i-1)?aux[2*p+2]:0)){ 
			if(((2*p+1<i-1)?aux[2*p+1]:0)>((2*p+2<i-1)?aux[2*p+2]:0)){
				q=2*p+1;
			}else{
				q=2*p+2;
			}
			swap=aux[p];
			aux[p]=aux[q];
			aux[q]=swap; 
			p=q;
		}
	} 
}

int min_diff(void){ //a legkisebb különbséget határozza meg
	int i,j,mi,ma,mdiff=2000000000,high; //segédváltozók, a bináris keresés határai, a legkisebb talált különbség, a bináris keresés határa
	for(i=W-1;i>=0;i--){ //minden lehetőség ellenőrzése
		mi=i; ma=W; //1. bináris keresés
		while(ma-mi>1){
			j=(mi+ma)/2; 
			if(mdiff<=lengths[j]-lengths[i]){
				ma=j; }else{ mi=j; }
		}
		high=mi; //a legnagyobb "esélyes" maximum
		if(connected(i,high)){ //találhatunk jobbat
			mi=i-1; ma=high+1; //2. bináris keresés
			while(ma-mi>1){ 
				j=(mi+ma)/2;
				if(connected(i,j)){ ma=j; }else{ mi=j; }
			} 
			mdiff=lengths[ma]-lengths[i]; //a minimális különbség javított értéke
		}
	} 
	return ((mdiff==2000000000)?-1:mdiff); //visszatérés
}

char connected(int min_index, int max_index){//1-et ad vissza, ha két pont össze van kötve a redukált gráfban
	if(min_index>max_index){ return 0; }else if(max_index>=W){ return 1; }else{ //szélsőhelyzetek
		int i,j,d,min=lengths[min_index],max=lengths[max_index]; //segédváltozók, a redukált gráf határai
		for(i=0;i<N;i++){ found[i]=0; } 
		d=1; aux[0]=A; found[A]=1; //aux verem, d a mélysége
		while((d>0)&&!(found[B])){ //mélységi keresés
			d--; i=aux[d]; 
			for(j=neigh_index[i];j<neigh_index[i+1];j++){
				if((neighbor[j][0]>=min)&&(neighbor[j][0]<=max)&&(!found[neighbor[j][1]])){ //az élhosszra kikötéseket tettünk
					aux[d]=neighbor[j][1]; found[aux[d]]=1; d++;
				}
			}
		} 
		return found[B];
	}
}
