/*
feladat: S86
nv: Makk Lszl
osztly: 12
iskola: SZTE Sgvri Endre Gyakorl Gimnzium
vros: Szeged
*/

#include <iostream>
#include <list>

using namespace std;

int N, M;

struct event
{
    int monkeyid;
    short whand;
} events[400001];

struct monkey
{
    list<int> conn; //directly, at the moment
    int left;
    bool left_act;
    int right;
    bool right_act;
    int res;
    monkey()
    {
        left_act=1;
        right_act=1;
        res=0;
    };
} monkeys[200001];

int BFS_tosearch[200000];
bool BFS_found[200001]={0};

int main()
{
    std::ios_base::sync_with_stdio(false);

    //input+init
    cin >> N >> M;
    for (int i=1; i<=N; i++)
    {
        cin >> monkeys[i].left >> monkeys[i].right;
    }
    for (int i=1; i<=M; i++)
    {
        cin >> events[i].monkeyid >> events[i].whand;
        if (events[i].whand==1)
        {
            monkeys[events[i].monkeyid].left_act=0;
        } else
        {
            monkeys[events[i].monkeyid].right_act=0;
        }
    }
    for (int i=1; i<=N; i++)
    {
        if (monkeys[i].left!=-1 && monkeys[i].left_act)
        {
            monkeys[i].conn.push_back(monkeys[i].left);
            monkeys[monkeys[i].left].conn.push_back(i);
        }
        if (monkeys[i].right!=-1 && monkeys[i].right_act)
        {
            monkeys[i].conn.push_back(monkeys[i].right);
            monkeys[monkeys[i].right].conn.push_back(i);
        }
    }

    //at the end of the timeline, traverse graph
    BFS_tosearch[0]=1;
    BFS_found[1]=1;
    monkeys[1].res=-1;
    int tosearch_end=0; //last index
    int cur=0;
    while (cur<=tosearch_end)
    {
        for (list<int>::iterator it=monkeys[BFS_tosearch[cur]].conn.begin(); it!=monkeys[BFS_tosearch[cur]].conn.end(); ++it)
        {
            if (!BFS_found[*it])
            {
                BFS_found[*it]=1;
                monkeys[*it].res=-1;
                tosearch_end++;
                BFS_tosearch[tosearch_end]=*it;
            }
        }
        cur++;
    }

    //start time, going backwards
    {
        int monkey_a, monkey_b;
        for (int i=M; i>0; i--)
        {
            monkey_a=events[i].monkeyid;
            if (events[i].whand==1)
            {
                monkey_b=monkeys[monkey_a].left;
            } else
            {
                monkey_b=monkeys[monkey_a].right;
            }
            monkeys[monkey_a].conn.push_back(monkey_b);
            monkeys[monkey_b].conn.push_back(monkey_a);
            if (BFS_found[monkey_a]!=BFS_found[monkey_b]) //XOR
            {
                if (BFS_found[monkey_a])
                {
                    swap(monkey_a,monkey_b);
                }
                //now monkey_a is the new one
                BFS_found[monkey_a]=1;
                monkeys[monkey_a].res=i;
                tosearch_end++;
                BFS_tosearch[tosearch_end]=monkey_a;
                while (cur<=tosearch_end)
                {
                    for (list<int>::iterator it=monkeys[BFS_tosearch[cur]].conn.begin(); it!=monkeys[BFS_tosearch[cur]].conn.end(); ++it)
                    {
                        if (!BFS_found[*it])
                        {
                            BFS_found[*it]=1;
                            monkeys[*it].res=i;
                            tosearch_end++;
                            BFS_tosearch[tosearch_end]=*it;
                        }
                    }
                    cur++;
                }
            }
        }
    }

    //print results
    for (int i=1; i<=N; i++)
    {
        cout << monkeys[i].res << "\n";
    }

    return 0;
}
