/*
feladat: S88
nv: Makk Lszl
osztly: 12
iskola: SZTE Sgvri Endre Gyakorl Gimnzium
vros: Szeged
*/

#include <iostream>
#include <list>

using namespace std;

int N, M;

struct vertex
{
    list<int> edge;
    bool BFS_found;
    vertex()
    {
        BFS_found=0;
    }
} vertices[100001]; //used from id=1
int BFS[100000];
int BFS_end=-1; //last index

int main()
{
    std::ios_base::sync_with_stdio(false);
    long long res=1;

    //input
    {
        cin >> N >> M;
        int t1, t2;
        for (int i=0; i<M; i++)
        {
            cin >> t1 >> t2;
            vertices[t1].edge.push_back(t2);
            vertices[t2].edge.push_back(t1);
        }
    }

    //process data
    {
        int BFS_cur=0; //currently searching
        int compV, compE; //#vertices, #edges in component
        bool contains_loop;
        for (int comp=1; comp<=N; comp++)
        {
            if (vertices[comp].BFS_found)
            {
                continue;
            }
            //find largest connected subgraph containing comp
            compV=1;
            compE=0;
            BFS_end++;
            BFS[BFS_end]=comp;
            vertices[comp].BFS_found=1;
            contains_loop=0;
            while (BFS_cur<=BFS_end)
            {
                for (list<int>::iterator it=vertices[BFS[BFS_cur]].edge.begin(); it!=vertices[BFS[BFS_cur]].edge.end(); ++it)
                {
                    if (*it==BFS[BFS_cur])
                    {
                        contains_loop=1;
                    }
                    if (!vertices[*it].BFS_found)
                    {
                        vertices[*it].BFS_found=1;
                        compV++;
                        BFS_end++;
                        BFS[BFS_end]=*it;
                    }
                    compE++;
                }
                BFS_cur++;
            }
            //merge into final result
            compE/=2;
            if (compV==compE+1)
            {
                //subgraph is a tree
                res=(res*compV)%1000000007;
            } else if (compV==compE)
            {
                //subgraph is a pseudo-tree
                if (!contains_loop)
                {
                    //1 cycle which is not a loop
                    res=(res*2)%1000000007;
                }
            } else
            {
                //subgraph contains too many cycles
                //no solution is possible, output 0
                cout << "0\n";
                return 0;
            }

        }
    }

    //output
    cout << res << "\n";
    return 0;
}
