﻿/* Variables */
{
Array.matrix = function(numrows, numcols, initial) {
    var arr = [];
    for (var i = 0; i < numrows; ++i) {
        var columns = [];
        for (var j = 0; j < numcols; ++j) {
            columns[j] = initial;
        }
        arr[i] = columns;
    }
    return arr;
}
var Canvas = document.getElementById("Canvas");
var ctx = Canvas.getContext("2d")
var Reader = new FileReader()

var UIElements = {
	IncreaseSidesNButton : {posx:10, posy:10, lengthx:50, lengthy:20, text:"Increase N", font:"9px Arial", color:"rgb(0, 255, 0)", type:"button"},
	DecreaseSidesNButton : {posx:70, posy:10, lengthx:50, lengthy:20, text:"Decrease N", font:"9px Arial", color:"rgb(255, 0, 0)", type:"button"},
	IncreaseSidesMButton : {posx:10, posy:40, lengthx:50, lengthy:20, text:"Increase M", font:"9px Arial", color:"rgb(0, 255, 0)", type:"button"},
	DecreaseSidesMButton : {posx:70, posy:40, lengthx:50, lengthy:20, text:"Decrease M", font:"9px Arial", color:"rgb(255, 0, 0)", type:"button"},
	IncreaseSButton : {posx:10, posy:70, lengthx:50, lengthy:20, text:"Increase S", font:"9px Arial", color:"rgb(0, 255, 0)", type:"button"},
	DecreaseSButton : {posx:70, posy:70, lengthx:50, lengthy:20, text:"Decrease S", font:"9px Arial", color:"rgb(255, 0, 0)", type:"button"},
	IncreaseZButton : {posx:10, posy:100, lengthx:50, lengthy:20, text:"Increase Z", font:"9px Arial", color:"rgb(0, 255, 0)", type:"button"},
	DecreaseZButton : {posx:70, posy:100, lengthx:50, lengthy:20, text:"Decrease Z", font:"9px Arial", color:"rgb(255, 0, 0)", type:"button"},
	Runbutton : {posx:190, posy:10, lengthx:50, lengthy:20, text:"Run", font:"9px Arial", color:"rgb(0, 255, 0)", type:"button"},
	NLabel : {posx:130, posy:10, lengthx:50, lengthy:20, text:"N=50", font:"9px Arial", color:"rgb(255, 255, 102)", type:"label"},
	MLabel : {posx:130, posy:40, lengthx:50, lengthy:20, text:"M=50", font:"9px Arial", color:"rgb(255, 255, 102)", type:"label"},
	SLabel : {posx:130, posy:70, lengthx:50, lengthy:20, text:"S=50", font:"9px Arial", color:"rgb(255, 255, 102)", type:"label"},
	ZLabel : {posx:130, posy:100, lengthx:50, lengthy:20, text:"Z=1", font:"9px Arial", color:"rgb(255, 255, 102)", type:"label"},
	StatusLabel : {posx:190, posy:40, lengthx:50, lengthy:20, text:"Ready", color:"rgb(255, 255, 102)", type:"label"},
}
var M = 50;
var N = 50;
var S = 50;
var Z = 1;
var i = 0;
var c = 0;
var k = 0;
var s = 0;
var x = 0;
var y = 0;
var map = Array.matrix(N,M,0)
var min = 10000000000000000000000000000
var max = -1000000000000000000000000000
var inputstring = ""
}	
/* Variables End */

/* Functions */
{
/*Ultility functions*/{
	function rgb(r, g, b){
  return "rgb("+r+","+g+","+b+")";
}
}
/*Buttonfunctions*/{
function IncreaseSidesNButtonfunc(){
	N = N + 1;
	UIElements.NLabel.text = "N=" + N;
}
function DecreaseSidesNButtonfunc(){
	N = N - 1;
	UIElements.NLabel.text = "N=" + N;
}	
function IncreaseSidesMButtonfunc(){
	M = M + 1;
	UIElements.MLabel.text = "M=" + M;
}
function DecreaseSidesMButtonfunc(){
	M = M - 1;
	UIElements.MLabel.text = "M=" + M;
}
function IncreaseSButtonfunc(){
	S = S + 1;
	UIElements.SLabel.text = "S=" + S;
}
function DecreaseSButtonfunc(){
	S = S - 1;
	UIElements.SLabel.text = "S=" + S;
}
function IncreaseZButtonfunc(){
	Z = Z + 1;
	UIElements.ZLabel.text = "Z=" + Z;
}
function DecreaseZButtonfunc(){
	Z = Z - 1;
	UIElements.ZLabel.text = "Z=" + Z;
}
function Runbuttonfunc(){
	UIElements.StatusLabel.text="Simulating"
	Displayobj(ctx,UIElements)
	setTimeout(Simulate,1000)
}	
}
function Simulate(){
	console.log("Simulating. Data: N = " + N + ", M = " + M + ", S = " + S + ", Z = "+Z+".")
	map = Array.matrix(N,M,0)
	min = 10000000000000000000000000000
	max = -1000000000000000000000000000
	if ((inputstring != "")&&(inputstring != undefined)){
		console.log("inputstring is loaded")
		var inputarray = inputstring.split(",")
		for (i=0;i<Z;i++){
			if (inputarray[i*3+2]!=undefined){
				map[Number(inputarray[i*3])][Number(inputarray[i*3+1])] = Number(inputarray[i*3+2])
				console.log("successful point flagging")
			}else{
				map[Math.floor(Math.random()*N)][Math.floor(Math.random()*M)] = (Math.floor(Math.random()*2)== 1)? 5:-5
			}
		}
	}else{
		for (i=0;i<Z;i++){map[Math.floor(Math.random()*N)][Math.floor(Math.random()*M)] = (Math.floor(Math.random()*2)== 1)? 5:-5}
	}
	for (i=0;i<M;i++){
		for (c=0;c<N;c++){
			if ((map[c][i]!=5)&&(map[c][i]!=-5)){
				for (k=0;k<S;k++){
					s=0
					x=c
					y=i
					switch(Math.floor(Math.random() * 4)){
						case 0: if(x>0){x=x-1;}break;
						case 1: if(x<N-1){x=x+1;}break;
						case 2: if(y>0){y=y-1;}break;
						case 3: if(y<M-1){y=y+1;}break;
					}	
					while ((map[x][y]!=5)&&(map[x][y]!=-5)&&(s<100000)){
						switch(Math.floor(Math.random() * 4)){
							case 0: if(x>0){x=x-1;}break;
							case 1: if(x<N-1){x=x+1;}break;
							case 2: if(y>0){y=y-1;}break;
							case 3: if(y<M-1){y=y+1;}break;
						}
						s++
					}	
					map[c][i]=map[c][i]+map[x][y]
					if (map[c][i]<min){min = map[c][i]}
					if (map[c][i]>max){max = map[c][i]}	
				}
			}	
		}	
	}
	console.log("Simulation end. Results are being displayed. Data: min = "+min+", max = "+max+".")
	DisplayResults()
}
}
function DisplayResults(){
	ctx.fillStyle = rgb(255, 255, 255); ctx.fillRect(0,0,window.innerWidth-20,window.innerWidth-20);
	Displayobj(ctx,UIElements);
	for (i = 0;i<M;i++){
		for (c = 0;c<N;c++){
			if ((c<N)&&(i<M)){
				if ((map[c][i]!=5)&&(map[c][i]!=-5)){
					ctx.fillStyle =rgb(Math.floor((map[c][i]-min)/(max-min)*255), Math.floor((map[c][i]-min)/(max-min)*255), Math.floor((map[c][i]-min)/(max-min)*255))
				} else {
					ctx.fillStyle = rgb(100+map[c][i]*-20,100+map[c][i]*20,0)
				}	
			ctx.fillRect(c*4+4,i*4+134,4,4)
			}
		}	
	}
	UIElements.StatusLabel.text="Ready"
	Displayobj(ctx,UIElements)	
}	
/* Functions End */

/* Program */
{
Canvas.width = window.innerWidth-20;
Canvas.height = window.innerHeight-50;
Canvas.addEventListener('click', function(){CheckClick(UIElements, event.clientX, event.clientY);Displayobj(ctx, UIElements)}, false);
window.addEventListener("resize", function(){Canvas.width = window.innerWidth-20;  Canvas.height = window.innerHeight-50; Displayobj(ctx,UIElements); DisplayResults()});
document.getElementById("Zlist").addEventListener("change", function(){inputstring = document.getElementById("Zlist").value; console.log(inputstring)})
Displayobj(ctx,UIElements)
}
/* Program End */