﻿/*
	S. 56.
	Adrián Patrik, 11. évf.
	Fazekas Mihály Gimnázium, Debrecen
*/

#include <stdio.h>
#include <stdlib.h>

// Az éllánc egy eleme
typedef struct _node
{
	int to;
	struct _node *next;
} node;

// A gráf egy csúcs
typedef struct _vertex
{
	int degree;
	node *edges;
} vertex;

// C-ben nincs bool, ezért csinálunk
typedef enum {false, true} bool;

// A gráf csúcsai
vertex vertices[10001];
// Tárolja, hogy kiírtuk-e már a csúcsokat
bool visited[10001];
// A szélességi keresés által használt sor
int queue[10000], queueFirst, queueSize;
// Az út megszerkesztéséhez használt verem
int stack[10000], stackSize;
// Az utolsó szélességi keresés, amiben a csúcs részt vett / az a csúcs, ahonnan a keresésben léptünk
int lastBFS[10001], from[10001];

int main(int argc, char *argv[])
{
	// Csúcsok, élek száma, segédváltozók, a pillanatnyi csúcs, az előző csúcs, hátralevő csúcsok száma, a szélességi bejárás sorszáma
	int n, m, i, p, q, current, last, remain, currentBFS = 1;
	// Éllánc-mutató
	node *e;

	// Beolvassuk a csúcsok és élek számát
	scanf("%d %d", &n, &m);

	// Beolvassuk a csúcsokat
	while(m --)
	{
		scanf("%d %d", &p, &q);

		// Hozzáfűzzük az egyik végpont élláncához
		e = (node *) malloc(sizeof(node));
		e -> to = q;
		e -> next = vertices[p].edges;
		vertices[p].edges = e;

		// Majd a másikéhoz
		e = (node *) malloc(sizeof(node));
		e -> to = p;
		e -> next = vertices[q].edges;
		vertices[q].edges = e;
	}

	// Beállítjuk a megfelelő kezdőértékeket
	current = 1;
	last = 0;
	remain = n - 1;

	printf("1");
	visited[1] = true;

	// Addig megyünk, míg van bejáratlan csúcs
	while(remain)
	{	
		// Berakjuk a sorba a pillanatnyiból elérhető csúcsokat
		queueSize = 0;
		for(e = vertices[current].edges; e != NULL; e = e -> next)
			// Az utolsót kivéve
			if(e -> to != last)
			{
				lastBFS[e -> to] = currentBFS;
				queue[queueSize ++] = e -> to;
				from[e -> to] = current;
			}
		lastBFS[current]=currentBFS;
		// Folyatatjuk a keresést; biztosan van bejáratlan csúcs
		queueFirst = 0;
		while(visited[queue[queueFirst]])
		{
			for(e = vertices[queue[queueFirst]].edges; e != NULL; e = e -> next)
				if(lastBFS[e -> to] < currentBFS && e -> to != from[e -> to])
				{
					lastBFS[e -> to] = currentBFS;
					from[e -> to] = queue[queueFirst];
					queue[queueSize ++] = e -> to;
				}
				
			queueFirst ++;
		}
		
		// Növeljük a keresés számát
		currentBFS ++;
		
		// Rekonstruáljuk az útvonalat
		stackSize = 1;
		stack[0] = queue[queueFirst];
		while(from[stack[stackSize - 1]] != current)
			stack[stackSize ++] = from[stack[stackSize - 1]];
		
		// Kiírjuk az utat
		while(stackSize)
		{
			printf(" %d", stack[ --stackSize]);
			// Bejárttá tesszük a csúcsot, ha még nem az
			if(!visited[stack[stackSize]])
			{
				visited[stack[stackSize]] = true;
				remain --;
			}
		}
		
		// Frissítjük a szükséges változókat
		last = from[stack[0]];
		current = stack[0];
	}

	// Minden sort '\n'-nel zárunk
	printf("\n");

	//system("PAUSE");

	return 0;
}
