# I. 541
# Simon Tamás
# 11. osztály
# Kiskunfélegyháza, Kiskunfélegyházi Szent Benedek PG Két Tan. Nyelvű Techn. és Koll.
# Python 3.10.0

from dataclasses import dataclass

# Létrehozunk egy saját adatstruktúrát a díjazottak adatainak tárolására
@dataclass
class Dijazott:
    ev: int
    nev: str
    orszag: list
    munkahely: list
    leiras: str

dijazottak = []

# Feltöltjük a dijazottak változót a Dijazott osztály példányaival
def beolvas():
    with open('abeldij.csv', 'r') as f:
        # A fájlt beolvasva minden sorból egy példányt csinálunk
        while True:
            sor = f.readline()
            if not sor:
                break
            adatok = sor.strip().split(';')
            uj_ev = int(adatok[0].strip())
            uj_nev = adatok[1].strip()
            uj_orszagok = [o.strip() for o in adatok[2].split(',')]
            uj_munkak = [m.strip() for m in adatok[3].split(',')]
            uj_leiras = adatok[4].strip()
            dijazottak.append(Dijazott(uj_ev, uj_nev, uj_orszagok, uj_munkak, uj_leiras))

def main():
    beolvas()

    # 5. feladat
    print("5. feladat:")
    ev = int(input("Kérem adjon meg egy évszámot: "))
    # Kiválogatjuk azokat a díjazottakat, akiknek a díjazási éve megegyezik a megadottal
    ev_dijazottak = [d for d in dijazottak if d.ev == ev]
    for d in ev_dijazottak:
        print(f"Név: {d.nev} született: {d.orszag[0]}")
    
    # 6. feladat
    print("6. feladat:")
    orszag = input("Kérem adja meg egy ország nevét: ")
    # Kiválogatjuk azokat a díjazottakat, akiknek a születési vagy tartózkodási helye megegyezik a megadottal
    orszag_dijazottak = [d for d in dijazottak if orszag in d.orszag]
    for d in orszag_dijazottak:
        print(f"Díjazott: {d.nev}\nMunkahely: {', '.join(d.munkahely)}")

    # 7. feladat
    print("7. feladat:")
    print("A következő matematikusok indoklásában szerepel az algebra szó:")
    # Kiválogatjuk azokat a díjazottakat, akiknek a leírásában szerepel az "algebra" szó
    algebra_dijazottak = [d.nev for d in dijazottak if "algebra" in d.leiras]
    print(', '.join(algebra_dijazottak))

main()