﻿Public Class frmTiliToli
    'I. 414.
    'Kovács 246 Benedek
    '12. osztály
    'Budapesti Fazekas Mihály Gyakorló Általános Iskola és Gimnázium
    'benoke98@freemail.hu

    Public Kep As Image 'Teljes kép
    Public KepDarab(25) As Bitmap 'A kép darabjai
    Public SorDb, OszlopDb As Integer 'Beállítások: sorok és oszlopok száma
    Public MeretX, MeretY As Integer 'A teljes kép méretei
    Public DarabMeretX, DarabMeretY As Integer 'Egy darab méretei
    Public Doboz(5, 5) As PictureBox 'Képmezők, amik a kijelzést végzik
    Public Cimke(5, 5) As Label 'A képmezőkön lévő címkék (ezek jelzik ki a számozást)

    Public LyukX, LyukY As Byte 'A lyuk aktuális koordinátái
    Public Melyik(5, 5) As Byte 'A tábla állapota: azt tárolja, hogy az (X,Y) mezőn melyik képdarab van éppen
    Public Jatekban As Boolean 'Ha ez hamis, akkor a darabok nem mozgathatók

    Private Sub frmTiliToli_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'A Tilitolis ablak bezárulásakor jelenjen meg a menü.
        frmMenu.Show()
    End Sub

    Private Function CropBitmap(ByRef bmp As Bitmap, ByVal cropX As Integer, ByVal cropY As Integer, ByVal cropWidth As Integer, ByVal cropHeight As Integer) As Bitmap
        'Egy képből egy adott helyű, méretű részlet kivágását végző függvény
        Dim rect As New Rectangle(cropX, cropY, cropWidth, cropHeight)
        Dim cropped As Bitmap = bmp.Clone(rect, bmp.PixelFormat)
        Return cropped
    End Function

    Private Sub Felvag()
        'A Kép felvágása a kívánt darabokra.
        DarabMeretX = MeretX \ OszlopDb
        DarabMeretY = MeretY \ SorDb
        For i = 0 To OszlopDb - 1
            For j = 0 To SorDb - 1
                KepDarab(i + j * OszlopDb) = CropBitmap(Kep, i * DarabMeretX + Math.Min(i, MeretX Mod DarabMeretX),
                                            j * DarabMeretY + Math.Min(j, MeretY Mod DarabMeretY), DarabMeretX, DarabMeretY)
            Next
        Next

    End Sub

    Public Sub Kijelzes()
        'A tábla állapotának kijelzése
        For i = 0 To OszlopDb - 1
            For j = 0 To SorDb - 1
                If Melyik(i, j) = 100 Then 'Lyuk van az adott helyen
                    Doboz(i, j).Image = Nothing
                    Cimke(i, j).Text = ""
                Else 'Képdarab van az adott helyen
                    Doboz(i, j).Image = KepDarab(Melyik(i, j))

                    'Ha ez be van állítva, akkor a számozás kiírása.
                    If frmMenu.Szamozas Then
                        Cimke(i, j).Text = Melyik(i, j) + 1
                    Else
                        Cimke(i, j).Text = ""
                    End If
                End If
            Next
        Next

        'Ha a tábla ki van rakva, tájékoztató szöveg kiírása
        If Jatekban Then
            lblAllapot.Text = ""
        Else
            lblAllapot.Text = "Sikerült! Újrakeverés: Space"
        End If
    End Sub

    Public Sub Keveres()
        'Az állás véletlenszerű keverése
        Dim Rand As New System.Random
        For i = 1 To 1000
            'mindig egy random lépést választunk a 4 irány közül
            '1000 ilyen lépés jól összekeveri a táblát

            Select Case Rand.Next(1, 5)
                Case 1
                    Mozgat("J")
                Case 2
                    Mozgat("B")
                Case 3
                    Mozgat("F")
                Case 4
                    Mozgat("L")
            End Select
        Next
        Jatekban = True
    End Sub

    Public Sub KeszE()
        'Annak tesztelése, hogy nincs-e kirakva a játék.
        If (LyukX <> OszlopDb - 1) Or (LyukY <> SorDb - 1) Then
            'Ha a lyuk rossz helyen van, akkor biztosan nincs
            Exit Sub
        End If

        For i = 0 To OszlopDb - 1
            For j = 0 To SorDb - 1
                'Teszteljük, hogy az adott helyen jó elem van-e (ha nem, akkor kilépünk)
                If (Melyik(i, j) <> j * OszlopDb + i) And (Melyik(i, j) <> 100) Then
                    Exit Sub
                End If
            Next
        Next

        'A játék ki van rakva: ekkor az utolsó elemet is odatesszük, és megakadályozzuk a további mozgatást
        Melyik(OszlopDb - 1, SorDb - 1) = SorDb * OszlopDb - 1
        Jatekban = False
        Kijelzes()
    End Sub

    Public Sub Mozgat(Irany As Char)
        'Egy elem tolásának elvégzése
        Select Case Irany
            Case "J"
                If LyukX > 0 Then
                    Melyik(LyukX, LyukY) = Melyik(LyukX - 1, LyukY)
                    Melyik(LyukX - 1, LyukY) = 100
                    LyukX -= 1
                End If
            Case "B"
                If LyukX < OszlopDb - 1 Then
                    Melyik(LyukX, LyukY) = Melyik(LyukX + 1, LyukY)
                    Melyik(LyukX + 1, LyukY) = 100
                    LyukX += 1
                End If
            Case "L"
                If LyukY > 0 Then
                    Melyik(LyukX, LyukY) = Melyik(LyukX, LyukY - 1)
                    Melyik(LyukX, LyukY - 1) = 100
                    LyukY -= 1
                End If
            Case "F"
                If LyukY < SorDb - 1 Then
                    Melyik(LyukX, LyukY) = Melyik(LyukX, LyukY + 1)
                    Melyik(LyukX, LyukY + 1) = 100
                    LyukY += 1
                End If
        End Select
        KeszE() 'Teszteljük, hogy kiraktuk-e a játékot
    End Sub

    Private Sub frmTiliToli_KeyDown(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles Me.KeyDown
        'Billentyűzettel való irányítás (nyilak, WASD, Space)
        Select Case e.KeyCode
            Case Keys.Right, Keys.D
                If Jatekban Then
                    Mozgat("J")
                End If
            Case Keys.Left, Keys.A
                If Jatekban Then
                    Mozgat("B")
                End If
            Case Keys.Up, Keys.W
                If Jatekban Then
                    Mozgat("F")
                End If
            Case Keys.Down, Keys.S
                If Jatekban Then
                    Mozgat("L")
                End If
            Case Keys.Space
                Keveres()
        End Select
        Kijelzes()
    End Sub


    Private Sub frmTiliToli_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        'az ablak betöltésekor ez fut le

        Randomize()
        Kep = frmMenu.Kep
        SorDb = frmMenu.SorDb
        OszlopDb = frmMenu.OszlopDb
        MeretX = Kep.Width
        MeretY = Kep.Height
        Felvag()

        'ablakméret beállítása a darabok mérete és száma alapján
        Me.Size = New Size(20 + DarabMeretX * OszlopDb + 3 * (OszlopDb - 1) + 16, 20 + DarabMeretY * SorDb + 3 * (SorDb - 1) + 60)

        'Az alapállapot felállítása
        For i = 0 To OszlopDb - 1
            For j = 0 To SorDb - 1
                'Az egyes dobozok és címkék előkészítése, elhelyezése, kattintási események hozzáadása
                Melyik(i, j) = i + j * OszlopDb
                Doboz(i, j) = New PictureBox()
                Doboz(i, j).Location = New Point(10 + (DarabMeretX + 3) * i, 10 + (DarabMeretY + 3) * j)
                Doboz(i, j).Size = New Size(DarabMeretX, DarabMeretY)
                Doboz(i, j).Tag = 100 * i + j
                Cimke(i, j) = New Label()
                AddHandler Doboz(i, j).MouseDown, AddressOf DobozKatt
                Controls.Add(Doboz(i, j))
                Doboz(i, j).Controls.Add(Cimke(i, j))
                Cimke(i, j).Location = New Point(DarabMeretX \ 2 - 12, DarabMeretY \ 2 - 12)
                Cimke(i, j).TextAlign = ContentAlignment.MiddleCenter
                Cimke(i, j).Font = New Font("Arial", 14)
                Cimke(i, j).AutoSize = True
                Cimke(i, j).Tag = 100 * i + j
                Cimke(i, j).BackColor = Color.Transparent
                Cimke(i, j).ForeColor = Color.Black
                Cimke(i, j).BringToFront()
                AddHandler Cimke(i, j).MouseDown, AddressOf DobozKatt
            Next
        Next

        'A lyuk az alapállapotban a jobb alsó mezőben van
        LyukX = OszlopDb - 1
        LyukY = SorDb - 1
        Melyik(LyukX, LyukY) = 100

        'Megkeverjük az állást, majd kijelezzük azt
        Keveres()
        Kijelzes()
    End Sub

    Private Sub DobozKatt(ByVal sender As Object, ByVal e As EventArgs)
        'Egy dobozra (vagy címkére) való kattintás
        If Not Jatekban Then 'Ha nem vagyunk játékban, nem csinálunk semmit
            Exit Sub
        End If

        'A doboz beazonosítása, koordinátáinak kiolvasása
        Dim KattCimke = sender.tag
        Dim KattX, KattY As Integer
        KattX = KattCimke \ 100
        KattY = KattCimke - KattX * 100

        'Megállapítjuk, hogy a doboz a lyukhoz képest hol van, ennek megfelelően hajtunk végre tolás(oka)t.
        Dim Hanyszor As Byte
        If (LyukX = KattX) Then
            If LyukY < KattY Then
                Hanyszor = KattY - LyukY
                For i = 1 To Hanyszor
                    Mozgat("F")
                Next
            ElseIf LyukY > KattY Then
                Hanyszor = LyukY - KattY
                For i = 1 To Hanyszor
                    Mozgat("L")
                Next
            End If
        ElseIf (LyukY = KattY) Then
            If LyukX < KattX Then
                Hanyszor = KattX - LyukX
                For i = 1 To Hanyszor
                    Mozgat("B")
                Next
            ElseIf LyukX > KattX Then
                Hanyszor = LyukX - KattX
                For i = 1 To Hanyszor
                    Mozgat("J")
                Next
            End If
        End If
        Kijelzes()
    End Sub
End Class