package i453;

import javax.swing.*;
import java.awt.*;
import java.util.Random;
import java.util.Scanner;

public class I453 {
	static int N, M, S, Z;
	static int[][] halo;
	static boolean[][] jeloltek;
	static int MERET = 10;

	static void w(String txt) {
		System.out.println(txt);
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		w("N, a sorok szama: ");
		N = sc.nextInt();
		w("M, az oszlopok szama: ");
		M = sc.nextInt();
		w("S, a bolyongasok szama: ");
		S = sc.nextInt();
		w("Z, a jelolt cellak szama: ");
		Z = sc.nextInt();
		halo = new int[N][M];
		jeloltek = new boolean[N][M];
		w("A jelolt cellak x, y koordinatai es erteke szokozzel elvalasztva: ");
		for (int i = 0; i < Z; i++) {
			int x = sc.nextInt() - 1;
			int y = sc.nextInt() - 1;
			int e = sc.nextInt();
			halo[x][y] = e;
			jeloltek[x][y] = true;
		}
		w("Hany pixel szeles legyen egy negyzet a racsban? - Ajanlott : 10 ");
		MERET = sc.nextInt();
		w("Rajzolas...");
		for (int x = 0; x < N; x++) {
			for (int y = 0; y < M; y++) {
				if (!jeloltek[x][y]) {
					for (int k = 0; k < S; k++) {
						bolyongas(x, y);
					}
				}
			}
		}
		for (int x = 0; x < N; x++) {
			for (int y = 0; y < M; y++) {
				if (jeloltek[x][y]) {
					halo[x][y] *= S;
				}
			}
		}
		Canvas canvas = new Canvas();
		canvas.setSize(MERET * N, MERET * M);
		JFrame f = new JFrame();
		JPanel p = new JPanel() {
			@Override
			protected void paintComponent(Graphics g) {
				super.paintComponent(g);
				for (int x = 0; x < N; x++) {
					for (int y = 0; y < M; y++) {
						g.setColor(new Color(0, (int) (szinkod(x, y) * 255), 0));
						g.fillRect(x * MERET, y * MERET, MERET, MERET);
					}
				}
			}
		};
		f.add(p);
		f.setSize(MERET * (N + 5), MERET * (M + 5));
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setVisible(true);
	}

	static float szinkod(int x, int y) {
		Float r = ((float) halo[x][y] / (float) S / 5f + 1f) / 2f;
		if (r < 0) {
			r = 0f;
		}
		if (r > 1) {
			r = 1f;
		}
		return r;
	}

	static int rsz(int min, int max) {
		return min + new Random().nextInt(max - min + 1);
	}

	static int[][] irany = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}};

	static void bolyongas(int x, int y) {
		int kx = x;
		int ky = y;
		int[] v;
		while (!jeloltek[x][y]) {
			do {
				v = irany[rsz(0, 7)];
			} while (!(0 <= x + v[0] && x + v[0] < N && 0 <= y + v[1] && y + v[1] < M));
			x += v[0];
			y += v[1];
		}
		halo[kx][ky] += halo[x][y];
	}
}
