/*
Nv: Kis Lzr Bence
Iskola: Magyar Tantsi Nyelv Magngimnzium
Helysg: Dunaszerdahely
Osztly: 11.

Fejleszti krnyezet: Microsoft Visual Studio 2015
*/


#include "stdafx.h"
#include <iomanip>
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>

using namespace std;

//-----------------------//
//       KONSTANSOK      //
//-----------------------//

const string fLoc = "uzemanyag.txt";			// bemeneti fjl helye

//-----------------------//
//       OSZTLYOK       //
//-----------------------//

class PriceData {
public:
	int year;				// v
	int month;				// hnap
	int day;				// nap
	int petrolPrice;		// benzin ra az adott napon
	int dieselPrice;		// gzolaj ra az adott napon
};

class Interval {
public:
	int start;		// idszakhoz tartoz els adatsor indexe
	int end;		// idszakhoz tartoz utols adatsor indexe

	Interval(int a) {
		this->start = a;
		this->end = a;
	}

	Interval() {}
};

class Date {
public:
	int year;		// v
	int month;		// hnap
	int day;		// nap

	Date(int y, int m, int d) {
		this->year = y;
		this->month = m;
		this->day = d;
	}

	Date(PriceData data) {
		this->year = data.year;
		this->month = data.month;
		this->day = data.day;
	}
};


//-----------------------//
//       FUNKCIK        //
//-----------------------//

int findDayIndex(int, int, int);	// visszaadja az adott nap rhoz tartoz indexet
string getDate(Date);				// visszaadja az adott indexhez tartoz dtumot formzott karakterlncknt
int days_from_civil(Date);			// visszaadja az eltelt napok szmt a dtumbl
Date civil_from_days(int);			// visszaadja a dtumot az eltelt napok szmbl
int dayDifference(Date, Date);		// visszaadja kt idpont kzti napok szmt

//-----------------------//
//   GLOBLIS VLTOZK   //
//-----------------------//

ifstream f(fLoc);				// bemeneti fjl
vector<PriceData> priceData;	// zemanyagrak
int petrolIncrease = 0;			// benzinr emelkedseinek szma a teljes idszakban
int petrolDecrease = 0;			// benzinr cskkenseinek szma a teljes idszakban
int maxIndex = 0;				// legmagasabb benzinr adatsornak indexe
vector<Interval> interval;		// 400 s 420 forint kzti idszakok
vector<Interval> increase;		// nem cskken a benzinr

//-----------------------//
//       F PROGRAM      //
//-----------------------//

int main() {
	PriceData next;		// kvetkez adatsor
	PriceData prev;		// elz adatsor
	bool inInterval = false;		// ppen egy 400 s 420 forint kztti idszakban vagyunk
	bool isIncreasing = false;		// ppen nvekszik a benzin ra

	while (f >> next.year >> next.month >> next.day >> next.petrolPrice >> next.dieselPrice) {
		if (priceData.size() > 0) {		// nem az els adatsor
			if (prev.petrolPrice < next.petrolPrice)		// nvekedett a benzin ra az elz idponthoz kpest
				petrolIncrease++;
			else if (prev.petrolPrice > next.petrolPrice)	// cskkent a benzin ra az elz idponthoz kpest
				petrolDecrease++;

			if (prev.petrolPrice <= next.petrolPrice)		// nem cskkent a benzin ra
			if (isIncreasing)
				increase[increase.size() - 1].end = priceData.size();	// ha folyamatban van egy szria, akkor csak kiterjesztjk a fels hatrt
			else {
				isIncreasing = true;		// ha eddig nem volt szria folyamatban, akkor elkezdjk
				increase.push_back(Interval(0));
				increase[increase.size() - 1].start = priceData.size() - 1;
				increase[increase.size() - 1].end = priceData.size();
			}
			else if (isIncreasing) {		// vget rt a szria
				isIncreasing = false;
			}

			if (next.petrolPrice > priceData[maxIndex].petrolPrice)		// j maximum
				maxIndex = priceData.size();
		}

		if ((next.dieselPrice > 400) && (next.dieselPrice < 420) && (next.petrolPrice > 400) && (next.petrolPrice < 420))	// az rak 400 s 420 kztt
		if (inInterval)
			interval[interval.size() - 1].end = priceData.size();		// utols intervallum kibvtse
		else {
			interval.push_back(Interval(priceData.size()));		// j intervallum hozzadsa, melynek megegyezik a kezdete s a vge
			inInterval = true;
		}
		else
			inInterval = false;

		priceData.push_back(next);		// j elem hozzadsa a vektorhoz
		prev = next;
	}

	////    2. FELADAT    \\\\

	cout << "2. feladat: " << priceData.size() << endl;

	////    3. FELADAT    \\\\

	int year, month, day;
	cout << "3. feladat: ";
	cin >> year >> month >> day;

	int index = findDayIndex(year, month, day);
	cout << "\tBenzin: " << priceData[index].petrolPrice << endl;
	cout << "\tGazolaj: " << priceData[index].dieselPrice << endl;

	////    4. FELADAT    \\\\

	cout << "4. feladat: " << endl;
	cout << "\tNott: " << petrolIncrease << " alkalommal" << endl;
	cout << "\tCsokkent: " << petrolDecrease << " alkalommal" << endl;

	////    5. FELADAT    \\\\

	cout << "5. feladat: " << endl;
	cout << "\tMaximum: " << priceData[maxIndex].petrolPrice << " Ft" << endl;
	cout << "\tDatum: " << getDate(Date(priceData[maxIndex])) << endl;

	////    6. FELADAT    \\\\

	int prevPrice = priceData[maxIndex].petrolPrice;		// az elz adatsorban szerepl benzinr
	int decreaseNum = 0;									// a benzinr cskkentseinek szma
	index = maxIndex + 1;									// a maximum utn eggyel kvetkez adatsornl kezdjk a vizsglst

	while (prevPrice >= priceData[index].petrolPrice) {		// amg nem kezd nvekedni
		if (prevPrice > priceData[index].petrolPrice)		// cskkentettk az rat az elz idponthoz kpest
			decreaseNum++;
		prevPrice = priceData[index].petrolPrice;
		index++;
	}

	cout << "6. feladat: " << endl;
	cout << "\tNovekedes kezdete: " << getDate(Date(priceData[index])) << endl;
	cout << "\tCsokkentesek szama: " << decreaseNum << endl;

	////    7. FELADAT    \\\\

	cout << "7. feladat: " << endl;

	unsigned long long int sum = 0;			// az sszeg a szmtani kzp kiszmolshoz

	for (int i = 0; i < priceData.size() - 1; i++)
		sum += priceData[i].dieselPrice * dayDifference(Date(priceData[i + 1]), Date(priceData[i]));
	sum += priceData[priceData.size() - 1].dieselPrice;

	int days = dayDifference(Date(priceData[priceData.size() - 1]), Date(priceData[0])) + 1;

	double avg = (double)sum / (double)days;
	cout << "\tGazolaj atlagara: " << setiosflags(ios::fixed) << setprecision(2) << avg << " Ft " << endl;

	////    8. FELADAT    \\\\

	cout << "8. feladat: " << endl;
	for (int i = 0; i < interval.size(); i++)
		cout << "\t" << getDate(Date(priceData[interval[i].start])) << " - " << getDate(civil_from_days(days_from_civil(Date(priceData[interval[i].end + 1])) - 1)) << endl;

	////    9. FELADAT    \\\\

	cout << "9. feladat: " << endl;

	maxIndex = 0;		// az els idszakot vesszk a leghosszbbnak
	int maxLength = dayDifference(Date(priceData[increase[maxIndex].end + 1]), Date(priceData[increase[maxIndex].start]));
	for (int i = 1; i < increase.size(); i++) {
		if (increase[i].end < priceData.size() - 1) {		// fontos ellenrizni, tlfuthat a vektor mretn
			int length = dayDifference(Date(priceData[increase[i].end + 1]), Date(priceData[increase[i].start]));
			if (length > maxLength) {		// ha hosszabb idszakot tallunk, akkor kicserljk
				maxIndex = i;
				maxLength = length;
			}
		}
	}

	cout << "\tKezdet: " << getDate(Date(priceData[increase[maxIndex].start])) << endl;
	cout << "\tHossz: " << maxLength << " nap" << endl;

	cin >> maxIndex;

	return 0;
}

//-----------------------//
//        FUNKCIK       //
//-----------------------//

int findDayIndex(int year, int month, int day) {
	int index = priceData.size() - 1;		// az utols elemtl indulunk visszafel

	while (priceData[index].year > year)
		index--;
	while ((priceData[index].year == year) && (priceData[index].month > month))
		index--;
	while ((priceData[index].year == year) && (priceData[index].month == month) && (priceData[index].day > day))
		index--;

	return index;
}

string getDate(Date date) {
	stringstream ss;
	ss << date.year << ". " << date.month << ". " << date.day << ".";

	return ss.str();
}

int days_from_civil(Date date) {
	date.year -= date.month <= 2;
	const int era = (date.year >= 0 ? date.year : date.year - 399) / 400;
	const unsigned yoe = static_cast<unsigned>(date.year - era * 400);								// [0, 399]
	const unsigned doy = (153 * (date.month + (date.month > 2 ? -3 : 9)) + 2) / 5 + date.day - 1;	// [0, 365]
	const unsigned doe = yoe * 365 + yoe / 4 - yoe / 100 + doy;										// [0, 146096]
	return era * 146097 + static_cast<int>(doe)-719468;
}

Date civil_from_days(int z) {
	z += 719468;
	const int era = (z >= 0 ? z : z - 146096) / 146097;
	const unsigned doe = static_cast<unsigned>(z - era * 146097);					// [0, 146096]
	const unsigned yoe = (doe - doe / 1460 + doe / 36524 - doe / 146096) / 365;		// [0, 399]
	const int y = static_cast<int>(yoe)+era * 400;
	const unsigned doy = doe - (365 * yoe + yoe / 4 - yoe / 100);					// [0, 365]
	const unsigned mp = (5 * doy + 2) / 153;										// [0, 11]
	const unsigned d = doy - (153 * mp + 2) / 5 + 1;								// [1, 31]
	const unsigned m = mp + (mp < 10 ? 3 : -9);										// [1, 12]
	return Date(y + (m <= 2), m, d);
}

int dayDifference(Date first, Date second) {
	return days_from_civil(first) - days_from_civil(second);
}