﻿/*
	S. 65.
	Adrián Patrik, 12. évf.
	Baross Gábor Középiskola, Szakiskola és Kollégium, Debrecen
*/

using System;

namespace s65
{
	class s65
	{
		// Blokkhossz
		static int b;
		// Üzenet
		static string message;
		// A d(n, m) függvény értékei
		static ulong[,] d = new ulong[100, 100];
		// A katalán számok
		static ulong[] C = new ulong[37];

		// Előre kiszámítja az algoritmushoz szükséges táblázatokat
		static void precalc()
		{
			int n, m;

			// Az első elemet "manuálisan" állítjuk
			d[0, 0] = 1;
			// A többire alkalmazzuk a rekurziós szabályt
			for(n = 1; n < 73; n ++)
			{
				d[n, 0] = d[n - 1, 1];
				for(m = 1; m <= n; m ++)
					d[n, m] = d[n - 1, m - 1] + d[n - 1, m + 1];
			}

			// Átmásoljuk a katalán számokat, hogy könnyebben megtaláljuk őket
			for(n = 0; n < 37; n ++)
				C[n] = d[2 * n, 0];
		}

		// Megfordítja a paraméteréül kapott sztringet
		static string reverse(string str)
		{
			char[] chars = str.ToCharArray();
			Array.Reverse(chars);
			return new string(chars);
		}

		static void decode_word(string word)
		{
			int n = word.Length, m = 0, i;
			ulong k = 0;
			string block;

			// Végigmegyünk az összes karakteren
			for(i = 0; i < word.Length; i ++, n --)
			{
				if(word[i] == '<')
					m ++;
				// Ha < jelet találunk, akkor hozzáadjuk az átugrottak számát
				else
				{
					k += d[n - 1, m + 1];
					m --;
				}
			}

			// Ugyancsak hozzáadjuk a hosszuk miatt átugrott szavak számát
			for(n = word.Length / 2 - 1; n > 0; n --)
				k += C[n];

			// Előállítjuk a szöveges reprezentációt
			for(i = 0, block = ""; i < b; i ++)
			{
				block += (k % 27 == 26 ? ' ' : (char) ('a' + k % 27));
				k /= 27;
			}

			// Kiírjuk
			Console.Write(reverse(block));
		}

		// Dekódolja az üzenetet
		static void decode()
		{
			// Feldaraboljuk a szóközöknél
			char[] delim = {' '};
			string[] words = message.Split(delim);

			// Minden darabot egyesével dekódolunk
			for(int i = 0; i < words.Length; i ++)
				decode_word(words[i]);
		}

		static void encode_block(string block)
		{
			ulong k = 0;
			int n, m;
			string word = "";

			// Számmá konvertáljuk a 27-es számrendszerbeli betűsorozatot
			for(int i = 0; i < b; i ++)
				k = k * 27 + (ulong) (block[i] == ' ' ? 26 : block[i] - 'a');

			// Meghatározzuk a zárójelsorozat hosszát és az adott hosszúak között elfoglalt pozícióját
			for(n = 1; C[n] <= k; n ++)
				k -= C[n];

			// Beállítjuk a hosszt
			n = 2 * n;
			// És az eltérést
			m = 0;

			// Minden pozíción végiglépünk
			while(n > 0)
			{
				// Ha van elég < jellel kezdődő sorozat, akkor ilyet írunk ki
				if(d[n - 1, m + 1] > k)
				{
					word += '<';
					m ++;
				}
				// Egyébként > jelet
				else
				{
					word += '>';
					// Csökkentjük a pozíciót az átugrottak számával
					k -= d[n - 1, m + 1];
					m --;
				}

				n --;
			}

			// Kiírjuk az előállított szót
			Console.Write(word);
		}

		static void encode()
		{
			// Kiegészítjük az üzenetet
			if(message.Length % b > 0)
				message = message.PadRight(message.Length + b - message.Length % b, ' ');

			// Előkészítjük a feldarabolást
			int pc = message.Length / b;
			string[] blocks = new string[pc];

			// Előállítjuk a blokkokat
			for(int i = 0; i < pc; i ++)
				blocks[i] = message.Substring(i * b, b);

			// Kódoljuk az első blokkot
			encode_block(blocks[0]);
			// És a többit is
			for(int i = 1; i < blocks.Length; i ++)
			{
				// A másodiktól elválasztó szóköz is kell
				Console.Write(' ');
				encode_block(blocks[i]);
			}
		}

		static void Main(string[] args)
		{
			// Beolvassuk a bemenetet
			b = int.Parse(Console.ReadLine());
			message = Console.ReadLine();

			// Kiszámítjuk előre a majd szükséges tömböket
			precalc();

			// Ha kódolt az üzenet, akkor < jellel kezdődik
			if(message[0] == '<')
				decode();
			// Egyébként kódolni kell
			else
				encode();

			// A kiírás egyetlen sorát is sorvége-karakterrel zárjuk
			Console.WriteLine();
		}
	}
}
