//S. 47.
//Mokcsay 026 dm
//Bonyhdi Petfi Sndor Evanglikus Gimnzium s Kollgium
//12. (c) osztly
//CodeGear Delphi 2009  Version 12.0.3170.16989 Copyright  2008
program s47;

{$APPTYPE CONSOLE}

uses
  SysUtils, Classes, lengyel;
//---------------------konstansok-----------------------------------
const KezdoElem = ['$','A'..'Y'];  //mezhivatkozs kezd karaktere vagy $ vagy bet
      Muvelet = ['+','-','/','*'];
//------------------------tpusdefincik-------------------
type TIndex = record
      X : Char;
      Y : Byte;
     end;
     TFixed = record
       I, J : Boolean;
     end;
//--------vltozk-------------------------------------------
var Elemek, Muveletek, Elements, Input, Sheet, Defined: TStringList;
    Count : Integer;
    min, max: TIndex;

Procedure ExtractStringsM(Separators, WhiteSpace: TSysCharSet; Content: PChar;
  Strings, Muveletek: TStrings);
//mdostott ExtractStrings, a mveleti jelek kezelskez (halmozott mveleti jeleket is relmez)
Begin
  ExtractStrings(Separators,WhiteSpace,Content, Strings);
  ExtractStrings(['0'..'9',',','$','A'..'Z'],[' '],Content, Muveletek);
  Muveletek.Add(' ');
end;

//-------lengyelforma kirtkelshez -----------------------------
Function T_GetResult(s: String): String;
var sorozat : array of Real;
    SL_forma : TStringList;
    utolso, i : integer;
    ZeroDivide : Boolean;
Begin
  ZeroDivide:=False;  //mg biztos nincs 0 oszt :)

  SL_forma:=TStringList.Create;
  ExtractStrings([' '],[' '],PChar(s),SL_forma);    //feldarabols
  utolso:=0;
  SetLength(sorozat, SL_forma.Count);

  for I := 0 to  SL_forma.Count - 1 do
    Begin
      if (SL_forma[i]='+') then    //sszeads
      Begin
        sorozat[utolso-2]:=sorozat[utolso-2]+sorozat[utolso-1];
        utolso:=utolso-1;
      End
      else
      if (SL_forma[i]='-') then     //kivons
      Begin
        sorozat[utolso-2]:=sorozat[utolso-2]-sorozat[utolso-1];
        utolso:=utolso-1;
      End
      else
      if (SL_forma[i]='*') then     //szorzs
      Begin
        sorozat[utolso-2]:=sorozat[utolso-2]*sorozat[utolso-1];
        utolso:=utolso-1;
      End
      else
      if (SL_forma[i]='/') then      //oszts
      Begin
        if sorozat[utolso-1]=0 then //nullval oszts?
          Begin
            ZeroDivide:=True;
            Break;
          End;
        sorozat[utolso-2]:=sorozat[utolso-2]/sorozat[utolso-1];
        utolso:=utolso-1;
      End
      else   //ha nem mveleti jel (szm)
      Begin
        sorozat[utolso]:=strToFloat(SL_forma[i]);
        utolso:=utolso+1;
      End;
    End;
  //eredmny visszaadsa
  if ZeroDivide then Result:='#NulOszt'   //Zr oszt esetn
  else               Result:=FormatFloat('0.##',sorozat[0]);  //kt jegyre kerekts

  SL_forma.Free;
End;

function kiertekel (str : String) : String;
//egy kifejezs eredmnyt adja meg pl.: 5+3-4 result=4
Begin
  if str='#NulOszt' then Result:='#NulOszt'
  else If Length(str)>=1 Then
  Result:=T_GetResult(MakePoland(str))
  else Result:=str;
End;
//-------RPN_end--------------------------------------------------------

Function Simplify (Field : String) : String;
//kiveszi a mezhivatkozsbl a $ jeleket.
Begin
  Result:=StringReplace(Field,'$','',[rfReplaceAll]);
End;

function IsOnlyNum (Formula : String) : Boolean;
//megllaptja, hogy az adott kplet csak szmokat tartalmaz e
const Illegal = ['$','A'..'Y'];
var I : Integer;
Begin
  Result:=True; //felttelezzk, hogy nem tartalmaz cellahivatkozst
  for I := 1 to Length(Formula) do //vgigmegynk karakterenknt
    if CharInSet(Formula[I],Illegal) then  //ha illeglis karakteert tallunk
      Begin
        Result:=False; //akkor ez nem csak szmokat tartalmaz kplet
        Break;  //kilpnk
      End;
End;

function IsFixed (Field : String) : TFixed;
//Egy mezhivatkozsrl meglaptja, hogy melyik eleme fixlt
var Ki : TFixed;
Begin
  Ki.I:=False;
  Ki.J:=False;
//--------------------
  if Field[1]='$' then//ha az el karakter $
    Begin
      Ki.I:=True; //akkor az els rtk fixlt
      if Field[3]='$' then Ki.J:=True; //ha ez esetben a 3. karakter is $ akkor a msodik rtk is fixlt
    End
  else     //ha az els karakter nem $
    Begin
      if Field[2]='$' then Ki.J:=True; //akkor ha a 2. $, akkor a msodik rtk fixlt
    End;
  Result:=ki;   //vgeredmny
End;

function IncField (Field : String; C, N : Byte) : String;
//$ nlkli mezhivatkozsok els rtkt C-vel, msodik rtkt N-nel nveli
var S : String;
Begin
  S:=Chr(Ord(Field[1])+C);  //els rtk nvelse
  S:=S+IntToStr((StrToInt(Copy(Field,2,Length(Field)-1))+N));  //msodik rtk nvelse
  Result:=S;   //eredmny
End;

function IncFormula ( Formula : String; C, N : Byte) : String;
//egy kplet minden mezhivatkozst vltoztatja meg
//a mezhivatkozsok els rtkt C vel nveli, ha az els rtk nem fixlt
//msodikra ugyan gy
var   I, K: Integer;
      Fix : TFixed;
      C1, N1 : Byte;
Begin
  Elemek.Clear;       //listk rtse
  Muveletek.Clear;
  Result:=''; //kimenet egyenlre semmi

  ExtractStringsM(Muvelet,[' '],PChar(Formula),Elemek, Muveletek); //sztbontjuk a kpletet
  for I := 0 to Elemek.Count - 1 do   //vgigmegynk a kplet elemein
    if CharInSet(Elemek[I][1], KezdoElem) then  //ha cellahivatkozs
      Begin
        C1:=0;
        N1:=0;
        Fix:=IsFixed(Elemek[I]);  //megnzzk, hogy mely rtk(ek) fixlt(ak)
        if not Fix.I then C1:=C; //ha nem fixlt, nveljk
        if not Fix.J then N1:=N;
        Elemek[I]:=IncField(Simplify(Elemek[I]),C1,N1); //mezhivatkozs mdostsa
      End;
//megalkotjuk a a fggvny kimenett:
  for K := 0 to Elemek.Count - 1 do  //Vgigfutunk a kplet sszes elemn
  Begin
    Result:=Result+Simplify(Elemek[K])+Muveletek[K]; //kivesszk a felesleges $ jeleket, sorban visszarakjuk az operandusokat s opertorokat
  End;
  Result:=Trim(Result); //esetleges felesleges szkz(k) kivtle
End;

Procedure AddValues(range, value : String);
var Kettospont_helye, J : Byte;
    A, B : TIndex;
    I : Char;
    S : String;
Begin
  {- tartomny sztbontsa rtkekere -}
  //Pl.: A 1 B 2
  Kettospont_helye:=Pos(':',range);
  A.X:=range[1];
  A.Y:=StrToInt(Copy(range,2,Kettospont_helye-2));
  B.X:=range[Kettospont_helye+1];
  B.Y:=StrToInt(Copy(range,Kettospont_helye+2,Length(range)-Kettospont_Helye-1));
  //---------------------------------------------
  for I := A.X to B.X do
    for J := A.Y to B.Y do
      Begin
        //formulk cellnknti megadsa:
        S:=IncFormula(value,Ord(I)-Ord(A.X),J-A.Y);
        //ha valami a definedbe kerl, akkor az mr ki van rtkelve!
        if IsOnlyNum(S) then Defined.Add(I+IntToStr(J)+'='+Kiertekel(S)) //ha nem tartalmaz hivatkozst, akkor a defined listba kerl
        else  Sheet.Add(I+IntToStr(J)+'='+S);  //ellenkez esetben a sheet listba
      End;
End;

function GetDefined (Field : String) : String;
var S : String;
Begin
  Result:='0';  //ha nincs sehol
  S:=Defined.Values[Field];
  if S<>'' then //ha megvan az rtk a definedben
    Begin
      Result:=S; //akkor visszaadjuk
    End
  else //ha nincs a definedben
    Begin
      S:=Sheet.Values[Field];
      if S<>'' then //hanem a sheetben van
        Begin
          Result:='NO';//akkor rtke mg meghatrozatlan
        End;
    End;
End;

procedure WithoutRange;
var  I: Integer;
Begin
  for I := 0 to Input.Count - 1 do
   if Input[I]<>'' then //res sorokat nem rtelmezek...
    Begin
      If Pos(':',Input.Names[I])>0 Then
        Begin //ha rang van megadva
          AddValues(Input.Names[I],Input.ValueFromIndex[I]);
        End
      else
        Begin //solo mez
          //ha nem tartalmaz hivatkozst, akkor kirtkelten a defined listba kerl:
          if IsOnlyNum(Input.ValueFromIndex[I]) then
          Defined.Add(Input.Names[I]+'='+Kiertekel(Input.ValueFromIndex[I]))
          else Sheet.Add(Input[I]);   //ellenkez esetben a sheet listba
        End;
    End;
End;

function Formula2Num (Formula:string) : string;
var J : Integer;
    S, Ki : String;
Begin
  Ki:=Formula;
  Elements.Clear;
  ExtractStrings(Muvelet,[' '],PChar(Formula),Elements);   //sztbontjuk a formult
    for J:=0 to Elements.Count - 1 do  //vgig a formula elemein
      Begin
          if not IsOnlyNum(Elements[J]) then //ha hivatkozs
            Begin  //megprblunk behelyettesteni
              S:=GetDefined(Elements[J]); //megnzzk mire hivatkozik
              if S='#NulOszt' then  //ha a hivatkozott mez NullOszt
                Begin
                  Ki:='#NulOszt'; //akkor az egysz NullOszt!
                  Break;   //s vge
                End
              else if S<>'NO' then //ha nem nullOszt s rke meghatrozott
                Begin //akkor behelyettestnk!
                  Ki:=StringReplace(Ki,Elements[J],S,[rfReplaceAll, rfIgnoreCase]);
                End;
            End;
      End;
  Result:=Ki;
End;

Procedure Cellat_Kiertekel;
var I : Integer;
    S : String;
Begin
  for I := 0 to Sheet.Count - 1 do  //vgigmegynk a sheeten
    Begin
      S:=Formula2Num(Sheet.ValueFromIndex[I]);//megprblunk minden rtket behelyettesteni
      if (S='#NulOszt') or (IsOnlyNum(S)) then    //ha sikerlt
       Begin
        Defined.Add(Sheet.Names[I]+'='+Kiertekel(S)); //definedbe trakjuk
        Sheet.Delete(I);   //sheetbl trljk
        Break;
       End;
    End;
End;

Procedure Korhivatkozas;
//a krhivatkozsokat listzza ki
var
  K: Integer;
Begin
  for K := 0 to Sheet.Count - 1 do  //itt mr csak a krhivatkozsok maradnak
    Begin
      Defined.Add(Sheet.Names[K]+'=#Kr');
    End;
  Sheet.Clear;
End;

function Bont (S : String) : TIndex;
//felbontja az adott sort egy karakterre s egy szmra pl.: A12 -> A | 12
var Res : TIndex;
Begin
  Res.X:=S[1];
  Res.Y:=StrToInt(Copy(S,2,Pos('=',S)-2));
  Result:=Res;
End;

procedure GetMinMax; //az UsedRange megadsa
var
  I: Integer;
  com : TIndex;
Begin
  min:=Bont(Defined[0]);
  max:=Bont(Defined[0]);
  for I := 0 to Defined.Count - 1 do
    Begin
      com:=Bont(Defined[I]);
      if (com.X<min.x) then min.X:=com.X;
      if (com.Y<min.Y) then min.Y:=com.Y;
      if (com.X>max.x) then max.X:=com.X;
      if (com.Y>max.Y) then max.Y:=com.Y;
    End;
End;

Procedure Save;  //ments
var X : Char;
    Y : Byte;
    Sor : String;
    F : TextFile;
Begin
  GetMinMax;
  AssignFile(F, ParamStr(2));
  ReWrite(F);
    for Y:= min.Y to max.Y do   //sor
      Begin
        Sor:='';
        for X := min.X to max.X do  //oszlop
          Begin
            Sor:=Sor+Defined.Values[X+IntToStr(Y)]+';';
          End;
        if sor[Length(sor)]=';' then sor[Length(sor)]:=' ';  //ha csupa ;bl ll a sor, akkor legyen res
        if Length(sor)=(ord(max.X)-ord(min.X)+1) then sor:='';    //utols (sorvgi) ; levgsa
        Writeln(F,Trim(sor)); //kirs fileba
      End;
   CloseFile(F);  //end of file
End;

//--------------fprogram-----------------------------------
begin
  if Paramcount>=2 then
    try
      //listk ltrehozsa
      Elemek:=TStringList.Create;
      Muveletek:=TStringList.Create;
      Sheet:=TStringList.Create;
      Defined:=TStringList.Create;
      Elements:=TStringList.Create;
      //betlts az els paramterben megadott fjlbl
      Input:=TStringList.Create;
      Input.LoadFromFile(ParamStr(1)); //megnyits
      WithoutRange;

      repeat
        Count:=Sheet.Count;
        Cellat_Kiertekel; //addig szmol, amg van mit
        if Sheet.Count=Count then Break;  //amg sheet el nem fogy, vagy
      until (Sheet.Count=0);  //ha nem jut j eredmnyre
      Korhivatkozas;
      Save;
      // listk felszabadtsa
      Elemek.Free;
      Muveletek.Free;
      Sheet.Free;
      Defined.Free;
      Elements.Free;
    except
      on E:Exception do
        Writeln(E.Classname, ': ', E.Message);
    end
  else
    Begin
      Writeln('Az alkalmazs hasznlata:');
      Writeln('s47.exe bemenet.txt kimenet.csv');
    End;
end.
