(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 10.0' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1064,         20]
NotebookDataLength[     41518,       1011]
NotebookOptionsPosition[     41764,        996]
NotebookOutlinePosition[     42192,       1015]
CellTagsIndexPosition[     42149,       1012]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["I. 375. - Fermat pont, P\[OAcute]lya-modell", "Title"],

Cell[CellGroupData[{

Cell["Kov\[AAcute]cs Bal\[AAcute]zs Marcell", "Item"],

Cell["Budapest, ELTE Radn\[OAcute]ti Mikl\[OAcute]s Gyakorl\[OAcute] \
Iskola,12. \[EAcute]vf.", "Item"],

Cell["kbalazsm@gmail.com", "Item"]
}, Open  ]],

Cell[TextData[{
 "A megold\[AAcute]shoz haszn\[AAcute]lt programoz\[AAcute]si eszk\
\[ODoubleDot]z: Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 10.0.0.0\nA program ingyenes pr\[OAcute]baverzi\[OAcute]ja ",
 ButtonBox["let\[ODoubleDot]lthet\[ODoubleAcute]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.wolfram.com/mathematica/trial/"], None},
  ButtonNote->"https://www.wolfram.com/mathematica/trial/"],
 ", de a megold\[AAcute]s futtat\[AAcute]s\[AAcute]hoz elegend\[ODoubleAcute] \
a Wolfram CDF Player ",
 ButtonBox["let\[ODoubleDot]lt\[EAcute]se",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.wolfram.com/cdf-player/"], None},
  ButtonNote->"https://www.wolfram.com/cdf-player/"],
 ".\nLinkek: https://www.wolfram.com/mathematica/trial/  ",
 "https://www.wolfram.com/cdf-player/"
}], "Text"],

Cell[TextData[{
 "A lyukak \[EAcute]s a k\[ODoubleDot]z\[ODoubleDot]s pont egy 10x10-es n\
\[EAcute]gyzeten bel\[UDoubleDot]l helyezkednek el. Ezen bel\[UDoubleDot]l a \
lyukak poz\[IAcute]ci\[OAcute]ja tetsz\[ODoubleAcute]legesen \
v\[AAcute]ltoztathat\[OAcute] az eg\[EAcute]r haszn\[AAcute]lat\[AAcute]val, \
de pontos koordin\[AAcute]t\[AAcute]k is megadhat\[OAcute]k a baloldali \
oszlopban. A pontok (lyukak) sz\[AAcute]m\[AAcute]t egy cs\[UAcute]szk\
\[AAcute]n 3 \[EAcute]s 8 k\[ODoubleDot]z\[ODoubleDot]tt \
tetsz\[ODoubleAcute]legesen v\[AAcute]ltoztathatjuk. Az ",
 StyleBox["Ered\[ODoubleAcute] megjelen\[IAcute]t\[EAcute]se ",
  FontSlant->"Italic"],
 "opci\[OAcute] bekapcsol\[AAcute]sa eset\[EAcute]n az \[AAcute]br\[AAcute]n \
a k\[ODoubleDot]z\[ODoubleDot]s pontb\[OAcute]l kiindul\[OAcute] \
egys\[EAcute]gvektotok mellett a program piros sz\[IAcute]nnel ezek ered\
\[ODoubleAcute]j\[EAcute]t is \[AAcute]br\[AAcute]zolja. A ",
 StyleBox["Randomize",
  FontSlant->"Italic"],
 " gomb a lyukakat v\[EAcute]letlenszer\[UDoubleAcute]en sz\[EAcute]tsz\
\[OAcute]rja a 10x10-es n\[EAcute]gyzeten bel\[UDoubleDot]l. A \
\[RightPointer] gombra kattintva ind\[IAcute]that\[OAcute] el az \
anim\[AAcute]ci\[OAcute], melynek sor\[AAcute]n a \
k\[ODoubleDot]z\[ODoubleDot]s pont a keresett pontba \[AAcute]ll be.\n\nA \
megold\[AAcute]s sor\[AAcute]n haszn\[AAcute]lt legfontosabb nyelvi eszk\
\[ODoubleDot]z a Dynamic f\[UDoubleDot]ggv\[EAcute]ny, ez teszi lehet\
\[ODoubleAcute]v\[EAcute] az interakci\[OAcute]t, illetve az anim\[AAcute]l\
\[AAcute]st is. A l\[EAcute]ptet\[EAcute]s k\[EAcute]tf\[EAcute]le \
m\[OAcute]dja k\[ODoubleDot]z\[UDoubleDot]l lehet v\[AAcute]lasztani. Az \
egyik esetben a az ered\[ODoubleAcute] er\[ODoubleAcute]vel egyenesen ar\
\[AAcute]nyos a k\[ODoubleDot]z\[ODoubleDot]s pont elmozdul\[AAcute]sa, a m\
\[AAcute]sik esetben mindig ugyanakkora. Az els\[ODoubleAcute] esetben a k\
\[ODoubleDot]zeled\[EAcute]s mag\[AAcute]t finom\[IAcute]tja, m\[IAcute]g a m\
\[AAcute]sodikban a k\[ODoubleDot]z\[ODoubleDot]s pont mindig \
t\[UAcute]lhalad a k\[IAcute]v\[AAcute]nt ponton \[EAcute]s onnan \
visszafordul. A v\[EAcute]gtelen hossz\[UAcute] ugr\[AAcute]l\[AAcute]s elker\
\[UDoubleDot]l\[EAcute]se \[EAcute]rdek\[EAcute]ben minden egyes visszafordul\
\[AAcute]sn\[AAcute]l a fel\[EAcute]re cs\[ODoubleDot]kkentj\[UDoubleDot]k a \
l\[EAcute]p\[EAcute]senk\[EAcute]nt megtett t\[AAcute]vols\[AAcute]got. Ha k\
\[ODoubleDot]z\[ODoubleDot]s pont mozg\[AAcute]sa m\[AAcute]r elhanyagolhat\
\[OAcute], le\[AAcute]ll\[IAcute]tjuk az anim\[AAcute]ci\[OAcute]t.\n\nA \
megold\[AAcute]s sor\[AAcute]n nagym\[EAcute]rt\[EAcute]kben \
kihaszn\[AAcute]ljuk a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nyelv (Wolfram nyelv) adta lehet\[ODoubleAcute]s\[EAcute]geket, \
p\[EAcute]ld\[AAcute]ul vektorok \[ODoubleDot]sszegz\[EAcute]s\[EAcute]t vagy \
vektorok egys\[EAcute]gvektorr\[AAcute] val\[OAcute] alak\[IAcute]t\[AAcute]s\
\[AAcute]t lehet\[ODoubleAcute]v\[EAcute] tev\[ODoubleAcute] be\[EAcute]p\
\[IAcute]tett f\[UDoubleDot]ggv\[EAcute]nyeket. A rendszer automatikus \
optimaliz\[AAcute]ci\[OAcute]kat v\[EAcute]gez, \[IAcute]gy a be\[EAcute]p\
\[IAcute]tett f\[UDoubleDot]ggv\[EAcute]nyek haszn\[AAcute]lata gyorsabb, \
mint az azonos m\[UDoubleAcute]veletek \[OpenCurlyDoubleQuote]k\[EAcute]zzel\
\[CloseCurlyDoubleQuote] val\[OAcute] elv\[EAcute]gz\[EAcute]se.\n\nA forr\
\[AAcute]sk\[OAcute]d a dokumentum v\[EAcute]g\[EAcute]n megtal\[AAcute]lhat\
\[OAcute]."
}], "Text"],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 3, $CellContext`pc$$ = {
  7.985186144352949, 7.759455244494055}, $CellContext`pont$$ = {{
  4.918725451445457, 7.633235500934596}, {9.10022140232617, 
  0.9317051231348152}, {0.8493851033788609, 2.1367197061021965`}, {
  4.04030807608321, 7.834355422973694}, {7.25675987190678, 
  5.8255634085058325`}, {1.4161746617520183`, 6.412566953112464}, {
  0.6117486343748784, 5.404495060966699}, {1.4189052761096494`, 
  4.04344242363929}}, $CellContext`controls$$ = {{
    Text["\!\(\*SubscriptBox[\(P\), \(1\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 1]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(2\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 2]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(3\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 3]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(4\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 4]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(5\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 5]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(6\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 6]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(7\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 7]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(8\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 8]]]}}, $CellContext`locators$$ = {
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 1]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 2]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 3]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 4]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 5]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 6]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 7]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 8]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 
     10]]}, $CellContext`eredo$$, $CellContext`v$$, $CellContext`t$$ = 
  0.7208571434020996, $CellContext`vorosnyil$$ = 
  False, $CellContext`lockor$$ = Graphics[{
    Circle[{0, 0}, 1]}, ImageSize -> 10], $CellContext`animator$$ = Dynamic[
   Animator[
    Dynamic[$CellContext`t$$], AnimationRepetitions -> Infinity, 
    AppearanceElements -> {"PlayPauseButton"}, ImageSize -> Large, 
    AnimationRunning -> $CellContext`running$$, 
    Enabled -> $CellContext`runnable$$], 
   TrackedSymbols :> {$CellContext`running$$, $CellContext`runnable$$}], \
$CellContext`animatorProto$$, $CellContext`minx$$ = 
  7.985186144352949, $CellContext`miny$$ = 
  7.759455244494055, $CellContext`maxx$$ = 
  7.985186144352949, $CellContext`maxy$$ = 
  7.759455244494055, $CellContext`x$$ = 7.985186144352949, $CellContext`y$$ = 
  7.759455244494055, $CellContext`elozopc$$ = {7.985186144352949, 
  7.759455244494055}, $CellContext`d$$ = 
  0.5000000000000002, $CellContext`factor$$ = 1, $CellContext`running$$ = 
  True, $CellContext`runnable$$ = True, $CellContext`erofuggo$$ = 
  False, $CellContext`info$$ = False}, 
  RowBox[{
   DynamicBox[
    ToBoxes[$CellContext`minx$$ = ($CellContext`miny$$ = 
       Infinity); $CellContext`maxx$$ = ($CellContext`maxy$$ = -
        Infinity); $CellContext`factor$$ = 
      1; $CellContext`elozopc$$ = $CellContext`pc$$; $CellContext`runnable$$ = 
      True; $CellContext`pont$$; $CellContext`n$$; "", StandardForm],
    ImageSizeCache->{0., {0., 7.}},
    TrackedSymbols:>{$CellContext`pont$$, $CellContext`n$$}], " ", 
   DynamicBox[ToBoxes[
    AddTo[$CellContext`pc$$, 
       If[$CellContext`erofuggo$$, $CellContext`eredo$$[$CellContext`n$$]/10, 
          Normalize[
            $CellContext`eredo$$[$CellContext`n$$]] 
          0.5] $CellContext`factor$$ + 
       0 $CellContext`t$$]; {$CellContext`x$$, $CellContext`y$$} = \
$CellContext`pc$$; $CellContext`minx$$ = 
      Min[$CellContext`minx$$, $CellContext`x$$]; $CellContext`miny$$ = 
      Min[$CellContext`miny$$, $CellContext`y$$]; $CellContext`maxx$$ = 
      Max[$CellContext`maxx$$, $CellContext`x$$]; $CellContext`maxy$$ = 
      Max[$CellContext`maxy$$, $CellContext`y$$]; If[
       Or[$CellContext`minx$$ < $CellContext`x$$ < $CellContext`maxx$$, \
$CellContext`miny$$ < $CellContext`y$$ < $CellContext`maxy$$], 
       DivideBy[$CellContext`factor$$, 
         2]; $CellContext`minx$$ = ($CellContext`miny$$ = 
         Infinity); $CellContext`maxx$$ = ($CellContext`maxy$$ = -Infinity); 
       Null]; $CellContext`d$$ = 
      EuclideanDistance[$CellContext`pc$$, $CellContext`elozopc$$]; \
$CellContext`elozopc$$ = $CellContext`pc$$; 
     If[$CellContext`d$$ < 
       If[$CellContext`erofuggo$$, 10^(-4), 10^(-5)], $CellContext`running$$ = 
        False; $CellContext`runnable$$ = False; 
       Null, $CellContext`running$$ = True; $CellContext`runnable$$ = True; 
       Null]; "", StandardForm],
    ImageSizeCache->{0., {0., 7.}},
    TrackedSymbols:>{$CellContext`t$$}], " ", 
   PanelBox[
    TagBox[GridBox[{
       {
        TagBox[GridBox[{
           {
            InterpretationBox[Cell[BoxData[
              FormBox["\<\"Pontok sz\[AAcute]ma\"\>", TextForm]], 
              "InlineText"],
             Text["Pontok sz\[AAcute]ma"]]},
           {
            InterpretationBox[
             StyleBox[GridBox[{
                {
                 SliderBox[Dynamic[$CellContext`n$$], {3, 8, 1},
                  Appearance->Automatic,
                  DefaultBaseStyle->"LabeledSlider"], 
                 InputFieldBox[Dynamic[$CellContext`n$$],
                  Appearance->"Frameless",
                  ContinuousAction->True,
                  DefaultBaseStyle->"LabeledSlider",
                  FieldSize->{{5, 10}, {1, 2}},
                  ImageMargins->0]}
               },
               AutoDelete->False,
               BaselinePosition->{{1, 1}, Axis},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              Deployed->True,
              StripOnInput->False,
              FontFamily:>CurrentValue["ControlsFontFamily"]],
             LabeledSlider[
              Dynamic[$CellContext`n$$], {3, 8, 1}]]},
           {
            TagBox[GridBox[{
               {
                TagBox[
                 TooltipBox[
                  ButtonBox["\<\"Randomize\"\>",
                   Appearance->Automatic,
                   ButtonFunction:>($CellContext`pont$$ = Table[
                    RandomReal[10, 2], {8}]),
                   Evaluator->Automatic,
                   ImageSize->Large,
                   Method->"Preemptive"],
                  "\"V\[EAcute]letlenszer\[UDoubleAcute] pontok\"",
                  TooltipStyle->"TextStyling"],
                 
                 Annotation[#, "V\[EAcute]letlenszer\[UDoubleAcute] pontok", 
                  "Tooltip"]& ], 
                TagBox[
                 TooltipBox[
                  DynamicBox[ToBoxes[$CellContext`animator$$, StandardForm],
                   ImageSizeCache->{22., {9., 15.}}],
                  
                  "\"L\[EAcute]ptet\[EAcute]s / meg\[AAcute]ll\[IAcute]t\
\[AAcute]s\"",
                  TooltipStyle->"TextStyling"],
                 
                 Annotation[#, 
                  "L\[EAcute]ptet\[EAcute]s / meg\[AAcute]ll\[IAcute]t\
\[AAcute]s", "Tooltip"]& ], ""}
              },
              AutoDelete->False,
              
              GridBoxItemSize->{
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
             "Grid"]},
           {
            TagBox[GridBox[{
               {
                InterpretationBox[Cell[BoxData[
                  
                  FormBox["\<\"Ered\[ODoubleAcute] \
megjelen\[IAcute]t\[EAcute]se\"\>", TextForm]], "InlineText"],
                 Text["Ered\[ODoubleAcute] megjelen\[IAcute]t\[EAcute]se"]], 
                CheckboxBox[Dynamic[$CellContext`vorosnyil$$]]},
               {
                InterpretationBox[Cell[BoxData[
                  
                  FormBox["\<\"Inform\[AAcute]ci\[OAcute]k megjelen\[IAcute]t\
\[EAcute]se\"\>", TextForm]], "InlineText"],
                 Text[
                 "Inform\[AAcute]ci\[OAcute]k \
megjelen\[IAcute]t\[EAcute]se"]], 
                CheckboxBox[Dynamic[$CellContext`info$$]]},
               {
                InterpretationBox[Cell[BoxData[
                  
                  FormBox["\<\"L\[EAcute]ptet\[EAcute]s m\[OAcute]dja\"\>", 
                   TextForm]], "InlineText"],
                 Text["L\[EAcute]ptet\[EAcute]s m\[OAcute]dja"]], 
                
                PopupMenuBox[Dynamic[$CellContext`erofuggo$$], {
                 True->"\<\"Ered\[ODoubleAcute] er\[ODoubleAcute]vel ar\
\[AAcute]nyos\"\>", 
                 False->"\<\"Ered\[ODoubleAcute] er\[ODoubleAcute] nagys\
\[AAcute]g\[AAcute]t\[OAcute]l f\[UDoubleDot]ggetlen\"\>"}, "True", 
                 PopupMenuBox[Null, {}]]}
              },
              AutoDelete->False,
              GridBoxAlignment->{"Columns" -> {{Left}}},
              
              GridBoxItemSize->{
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
             "Grid"]},
           {
            DynamicBox[ToBoxes[
              Grid[
               Part[$CellContext`controls$$, 
                Span[1, $CellContext`n$$]]], StandardForm],
             ImageSizeCache->{210., {28., 34.}}]},
           {
            InterpretationBox[
             StyleBox[
              GraphicsBox[{},
               BaselinePosition->(Scaled[0.] -> Baseline),
               ImageSize->{0, 10}],
              CacheGraphics->False],
             Spacer[{0, 10}]]},
           {
            DynamicBox[ToBoxes[
              If[$CellContext`info$$, 
               Row[{
                 Text["factor="], 
                 Text[$CellContext`factor$$], 
                 Text["  d="], 
                 Text[$CellContext`d$$]}], ""], StandardForm],
             ImageSizeCache->{0., {0., 6.}}]}
          },
          DefaultBaseStyle->"Column",
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
         "Column"], 
        DynamicBox[ToBoxes[
          Graphics[{
            PointSize[Large], 
            Point[$CellContext`pc$$], 
            Table[{
              Line[{$CellContext`pc$$, 
                Part[$CellContext`pont$$, $CellContext`i]}], 
              Arrow[{$CellContext`pc$$, $CellContext`pc$$ + $CellContext`v$$[
                  
                  Part[$CellContext`pont$$, $CellContext`i]]}]}, \
{$CellContext`i, 1, $CellContext`n$$}], 
            Part[$CellContext`locators$$, 
             Span[1, $CellContext`n$$]], Red, 
            If[$CellContext`vorosnyil$$, 
             
             Arrow[{$CellContext`pc$$, $CellContext`pc$$ + \
$CellContext`eredo$$[$CellContext`n$$]}], Null]}, PlotRangeClipping -> False, 
           Frame -> True, PlotRange -> {{0, 10}, {0, 10}}, ImageSize -> 
           Medium], StandardForm],
         ImageSizeCache->{360., {178., 184.}}]}
      },
      AutoDelete->False,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Top}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      Selectable->False],
     "Grid"]]}],
  DynamicModuleValues:>{{DownValues[$CellContext`eredo$$] = {HoldPattern[
         $CellContext`eredo$$[
          Pattern[$CellContext`a$, 
           Blank[]]]] :> Sum[
         $CellContext`v$$[
          Part[$CellContext`pont$$, $CellContext`i]], {$CellContext`i, 
          1, $CellContext`a$}]}}, {DownValues[$CellContext`v$$] = {HoldPattern[
         $CellContext`v$$[
          Pattern[$CellContext`a$, 
           Blank[]]]] :> 
       Normalize[$CellContext`a$ - $CellContext`pc$$]}}}]], "Output"],

Cell[BoxData[
 RowBox[{"DynamicModule", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "3"}], ",", 
     RowBox[{"(*", 
      RowBox[{"Pontok", " ", "sz\[AAcute]ma"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"pc", "=", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], ",", 
     RowBox[{"(*", 
      RowBox[{"k\[ODoubleDot]z\[ODoubleDot]s", " ", "pont"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"pont", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{"10", ",", "2"}], "]"}], ",", 
        RowBox[{"{", "8", "}"}]}], "]"}]}], ",", 
     RowBox[{"(*", 
      RowBox[{"a", " ", "lyukak", " ", "helyei"}], "*)"}], 
     "\[IndentingNewLine]", "controls", ",", 
     RowBox[{"(*", 
      RowBox[{
      "sz\[ODoubleDot]veges", " ", "bevitel", " ", "a", " ", "pontos", " ", 
       "koordin\[AAcute]t\[AAcute]khoz"}], "*)"}], "\[IndentingNewLine]", 
     "locators", ",", 
     RowBox[{"(*", 
      RowBox[{
      "a", " ", "lyukak", " ", "elhelyez\[EAcute]se", " ", 
       "kattint\[AAcute]ssal"}], "*)"}], "\[IndentingNewLine]", "eredo", ",", 
     RowBox[{"(*", 
      RowBox[{
      "ered\[ODoubleAcute]", " ", "vektorst", " ", 
       "meghat\[AAcute]roz\[OAcute]", " ", "fv"}], "*)"}], 
     "\[IndentingNewLine]", " ", "v", ",", 
     RowBox[{"(*", 
      RowBox[{
      "A", " ", "k\[ODoubleDot]z\[ODoubleDot]s", " ", "pontb\[OAcute]l", " ", 
       "egy", " ", "adott", " ", "pont", " ", "fel\[EAcute]", " ", 
       "mutat\[OAcute]", " ", "norm\[AAcute]lvektor"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"t", "=", "0"}], ",", 
     RowBox[{"(*", 
      RowBox[{
      "az", " ", "anim\[AAcute]ci\[OAcute]", " ", 
       "p\[ODoubleDot]rget\[EAcute]se"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"vorosnyil", "=", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{"ered\[ODoubleAcute]", " ", 
       RowBox[{"megjelen\[IAcute]t\[EAcute]se", "?"}]}], "*)"}], 
     "\[IndentingNewLine]", "lockor", ",", 
     RowBox[{"(*", 
      RowBox[{
      "a", " ", "locator", " ", "ne", " ", "az", " ", 
       "alap\[EAcute]rtelmez\[EAcute]s", " ", "szerint", " ", "jelenjen", " ",
        "meg"}], "*)"}], "\[IndentingNewLine]", "animator", ",", 
     RowBox[{"(*", 
      RowBox[{"anim\[AAcute]ci\[OAcute]", " ", "vez\[EAcute]rl\[EAcute]se"}], 
      "*)"}], "\[IndentingNewLine]", "animatorProto", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"minx", "=", "\[Infinity]"}], ",", 
     RowBox[{"miny", "=", "\[Infinity]"}], ",", 
     RowBox[{"maxx", "=", 
      RowBox[{"-", "\[Infinity]"}]}], ",", 
     RowBox[{"maxy", " ", "=", 
      RowBox[{"-", "\[Infinity]"}]}], ",", 
     RowBox[{"(*", 
      RowBox[{
      "a", " ", "k\[ODoubleDot]z\[ODoubleDot]s", " ", "pont", " ", 
       "sz\[EAcute]ls\[ODoubleAcute]", " ", "helyzetei"}], "*)"}], 
     "\[IndentingNewLine]", "x", ",", "y", ",", "\[IndentingNewLine]", 
     RowBox[{"elozopc", "=", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], ",", 
     RowBox[{"(*", 
      RowBox[{"k\[ODoubleDot]vetj\[UDoubleDot]k", ",", " ", 
       RowBox[{
       "hogy", " ", "mennyit", " ", "mozdult", " ", "a", " ", 
        "k\[ODoubleDot]z\[ODoubleDot]s", " ", "pont"}]}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"d", "=", "0"}], ",", 
     RowBox[{"(*", "elmozdul\[AAcute]s", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"factor", "=", "1"}], ",", 
     RowBox[{"(*", 
      RowBox[{"anim\[AAcute]ci\[OAcute]", " ", "finom\[IAcute]t\[AAcute]sa"}],
       "*)"}], "\[IndentingNewLine]", 
     RowBox[{"running", "=", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{"megy", "-", 
       RowBox[{"e", " ", "az", " ", "anim\[AAcute]ci\[OAcute]"}]}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"runnable", "=", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{"animator", " ", "letilt\[AAcute]sa"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"erofuggo", "=", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"a", " ", "l\[EAcute]ptet\[EAcute]s", " ", "ar\[AAcute]nyos"}],
        "-", 
       RowBox[{"e", " ", "az", " ", "eredo", " ", "er\[ODoubleAcute]vel"}]}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"info", "=", "False"}]}], 
    RowBox[{"(*", 
     RowBox[{
     "inform\[AAcute]ci\[OAcute]k", " ", "megjelen\[IAcute]t\[EAcute]se"}], 
     "*)"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"controls", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(1\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(2\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(3\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(4\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(5\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(6\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(7\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(8\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"lockor", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"locators", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], ",", "lockor"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eredo", "[", "a_", "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"v", "@", 
        RowBox[{"pont", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "a"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"v", "[", "a_", "]"}], ":=", 
     RowBox[{"Normalize", "[", 
      RowBox[{"a", "-", "pc"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"animator", "=", 
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"Animator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "t", "]"}], ",", 
         RowBox[{"AnimationRepetitions", "\[Rule]", "Infinity"}], ",", 
         RowBox[{"AppearanceElements", "\[Rule]", 
          RowBox[{"{", "\"\<PlayPauseButton\>\"", "}"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
         RowBox[{"AnimationRunning", "\[Rule]", "running"}], ",", 
         RowBox[{"Enabled", "\[Rule]", "runnable"}]}], "]"}], ",", 
       RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"running", ",", "runnable"}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Dynamic", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"pc", "+=", 
         RowBox[{
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{"erofuggo", ",", 
             RowBox[{
              RowBox[{"eredo", "[", "n", "]"}], "/", "10"}], ",", 
             RowBox[{
              RowBox[{"Normalize", "[", 
               RowBox[{"eredo", "[", "n", "]"}], "]"}], "*", "0.5"}]}], "]"}],
            "*", "factor"}], "+", 
          RowBox[{"0", "*", "t"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "=", "pc"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"minx", "=", 
         RowBox[{"Min", "[", 
          RowBox[{"minx", ",", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"miny", "=", 
         RowBox[{"Min", "[", 
          RowBox[{"miny", ",", "y"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"maxx", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"maxx", ",", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"maxy", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"maxy", ",", "y"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"minx", "<", "x", "<", "maxx"}], ")"}], "||", 
           RowBox[{"(", 
            RowBox[{"miny", "<", "y", "<", "maxy"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"factor", "/=", "2"}], ";", "\[IndentingNewLine]", 
           RowBox[{"minx", "=", 
            RowBox[{"miny", "=", "\[Infinity]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"maxx", "=", 
            RowBox[{"maxy", "=", 
             RowBox[{"-", "\[Infinity]"}]}]}], ";"}]}], "\[IndentingNewLine]",
          "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"d", "=", 
         RowBox[{"EuclideanDistance", "[", 
          RowBox[{"pc", ",", "elozopc"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"elozopc", "=", "pc"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"d", "<", 
           RowBox[{"If", "[", 
            RowBox[{"erofuggo", ",", 
             SuperscriptBox["10", 
              RowBox[{"-", "4"}]], ",", 
             SuperscriptBox["10", 
              RowBox[{"-", "5"}]]}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"running", "=", "False"}], ";", "\[IndentingNewLine]", 
           RowBox[{"runnable", "=", "False"}], ";"}], "\[IndentingNewLine]", 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"running", "=", "True"}], ";", "\[IndentingNewLine]", 
           RowBox[{"runnable", "=", "True"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\"\<\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
        RowBox[{"{", "t", "}"}]}]}], "]"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "Ha", " ", "b\[AAcute]rmilyen", " ", 
        "be\[AAcute]ll\[IAcute]t\[AAcute]s", " ", "megv\[AAcute]ltozik"}], 
       ",", " ", 
       RowBox[{
        RowBox[{"resetelj\[UDoubleDot]k", " ", "a", " ", 
         RowBox[{"min", "/", "max"}]}], "-", 
        RowBox[{"ot", " ", "\[EAcute]s", " ", "a", " ", "factort"}]}]}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Dynamic", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"minx", "=", 
         RowBox[{"miny", "=", "\[Infinity]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"maxx", "=", 
         RowBox[{"maxy", "=", 
          RowBox[{"-", "\[Infinity]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"factor", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"elozopc", "=", "pc"}], ";", "\[IndentingNewLine]", 
        RowBox[{"runnable", "=", "True"}], ";", "\[IndentingNewLine]", "pont",
         ";", "\[IndentingNewLine]", "n", ";", "\[IndentingNewLine]", 
        "\"\<\>\""}], ",", "\[IndentingNewLine]", 
       RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"pont", ",", "n"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Panel", "@", 
      RowBox[{"Grid", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Column", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Text", "[", "\"\<Pontok sz\[AAcute]ma\>\"", "]"}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"Slider", "[", 
               RowBox[{
                RowBox[{"Dynamic", "@", "n"}], ",", 
                RowBox[{"{", 
                 RowBox[{"3", ",", "8", ",", "1"}], "}"}], ",", 
                RowBox[{"Appearance", "->", "\"\<Labeled\>\""}]}], " ", "]"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"Grid", "[", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Tooltip", "[", 
                   RowBox[{
                    RowBox[{"Button", "[", 
                    RowBox[{"\"\<Randomize\>\"", ",", 
                    RowBox[{"pont", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"10", ",", "2"}], "]"}], ",", 
                    RowBox[{"{", "8", "}"}]}], "]"}]}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}], ",", 
                    "\"\<V\[EAcute]letlenszer\[UDoubleAcute] pontok\>\""}], 
                   "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Tooltip", "[", 
                   RowBox[{
                    RowBox[{"Dynamic", "@", "animator"}], ",", 
                    "\"\<L\[EAcute]ptet\[EAcute]s / meg\[AAcute]ll\[IAcute]t\
\[AAcute]s\>\""}], "]"}], ","}], "\[IndentingNewLine]", "}"}], "}"}], "]"}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{"Grid", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "Text", "[", 
                    "\"\<Ered\[ODoubleAcute] \
megjelen\[IAcute]t\[EAcute]se\>\"", "]"}], ",", 
                    RowBox[{"Checkbox", "[", 
                    RowBox[{"Dynamic", "@", "vorosnyil"}], "]"}]}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "Text", "[", 
                    "\"\<Inform\[AAcute]ci\[OAcute]k megjelen\[IAcute]t\
\[EAcute]se\>\"", "]"}], ",", 
                    RowBox[{"Checkbox", "[", 
                    RowBox[{"Dynamic", "@", "info"}], "]"}]}], "}"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "Text", "[", 
                    "\"\<L\[EAcute]ptet\[EAcute]s m\[OAcute]dja\>\"", "]"}], 
                    ",", 
                    RowBox[{"PopupMenu", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "erofuggo", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "True", "\[Rule]", 
                    "\"\<Ered\[ODoubleAcute] er\[ODoubleAcute]vel \
ar\[AAcute]nyos\>\""}], ",", 
                    RowBox[{
                    "False", "\[Rule]", 
                    "\"\<Ered\[ODoubleAcute] er\[ODoubleAcute] \
nagys\[AAcute]g\[AAcute]t\[OAcute]l f\[UDoubleDot]ggetlen\>\""}]}], "}"}], 
                    ",", "True", ",", 
                    RowBox[{"PopupMenu", "[", 
                    RowBox[{"Null", ",", 
                    RowBox[{"{", "}"}]}], "]"}]}], "]"}]}], "}"}]}], 
                 "\[IndentingNewLine]", "}"}], ",", 
                RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Dynamic", "@", 
               RowBox[{"Grid", "[", 
                RowBox[{"controls", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", "n"}], "]"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "10"}], "}"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Dynamic", "@", 
               RowBox[{"If", "[", 
                RowBox[{"info", ",", 
                 RowBox[{"Row", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Text", "@", "\"\<factor=\>\""}], ",", 
                    RowBox[{"Text", "@", "factor"}], ",", 
                    RowBox[{"Text", "[", "\"\<  d=\>\"", "]"}], ",", 
                    RowBox[{"Text", "@", "d"}]}], "}"}], "]"}], ",", 
                 "\"\<\>\""}], "]"}]}]}], "\[IndentingNewLine]", "}"}], "]"}],
            ",", "\[IndentingNewLine]", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"Graphics", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"PointSize", "[", "Large", "]"}], ",", 
                RowBox[{"Point", "[", "pc", "]"}], ",", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{"pc", ",", 
                    RowBox[{"pont", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"pc", ",", 
                    RowBox[{"pc", "+", 
                    RowBox[{"v", "@", 
                    RowBox[{"pont", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}]}], "}"}], "]"}]}], 
                   "}"}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", " ", "1", ",", " ", "n"}], "}"}]}], 
                 "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"locators", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", "n"}], "]"}], "]"}], ",", 
                "\[IndentingNewLine]", "Red", ",", 
                RowBox[{"If", "[", 
                 RowBox[{"vorosnyil", ",", 
                  RowBox[{"Arrow", "[", 
                   RowBox[{"{", 
                    RowBox[{"pc", ",", 
                    RowBox[{"pc", "+", 
                    RowBox[{"eredo", "[", "n", "]"}]}]}], "}"}], "]"}], ",", 
                  "Null"}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotRangeClipping", "\[Rule]", "False"}], ",", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              RowBox[{"PlotRange", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "10"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
              RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]}]}], 
          "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"Selectable", "\[Rule]", "False"}], ",", 
        RowBox[{"Alignment", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Left", ",", "Top"}], "}"}]}]}], "]"}]}]}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1061, 1020},
Visible->True,
ScrollingOptions->{"VerticalScrollRange"->Fit},
ShowCellBracket->Automatic,
CellContext->Notebook,
TrackCellChangeTimes->False,
FrontEndVersion->"10.0 for Linux x86 (64-bit) (June 27, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[1486, 35, 60, 0, 96, "Title"],
Cell[CellGroupData[{
Cell[1571, 39, 53, 0, 31, "Item"],
Cell[1627, 41, 104, 1, 31, "Item"],
Cell[1734, 44, 34, 0, 31, "Item"]
}, Open  ]],
Cell[1783, 47, 850, 20, 77, "Text"],
Cell[2636, 69, 3518, 54, 385, "Text"],
Cell[6157, 125, 12747, 317, 399, "Output"],
Cell[18907, 444, 22841, 549, 2708, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature NuDwfhNRZzQiJAww0xNhWIrg *)
