(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     49573,       1120]
NotebookOptionsPosition[     49003,       1096]
NotebookOutlinePosition[     49340,       1111]
CellTagsIndexPosition[     49297,       1108]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["I. 375. - Fermat pont, P\[OAcute]lya-modell", "Title",
 CellChangeTimes->{{3.640368328675664*^9, 3.64036837889872*^9}}],

Cell[CellGroupData[{

Cell["Kov\[AAcute]cs Bal\[AAcute]zs Marcell", "Item",
 CellChangeTimes->{{3.640368408364985*^9, 3.640368416487915*^9}}],

Cell["Budapest, ELTE Radn\[OAcute]ti Mikl\[OAcute]s Gyakorl\[OAcute] \
Iskola,12. \[EAcute]vf.", "Item",
 CellChangeTimes->{{3.640368408364985*^9, 3.640368502985257*^9}}],

Cell["kbalazsm@gmail.com", "Item",
 CellChangeTimes->{{3.640368408364985*^9, 3.640368478872706*^9}}]
}, Open  ]],

Cell[TextData[{
 "A megold\[AAcute]shoz haszn\[AAcute]lt programoz\[AAcute]si eszk\
\[ODoubleDot]z: Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 10.0.0.0\nA program ingyenes pr\[OAcute]baverzi\[OAcute]ja ",
 ButtonBox["let\[ODoubleDot]lthet\[ODoubleAcute]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.wolfram.com/mathematica/trial/"], None},
  ButtonNote->"https://www.wolfram.com/mathematica/trial/"],
 ", de a megold\[AAcute]s futtat\[AAcute]s\[AAcute]hoz elegend\[ODoubleAcute] \
a Wolfram CDF Player ",
 ButtonBox["let\[ODoubleDot]lt\[EAcute]se",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://www.wolfram.com/cdf-player/"], None},
  ButtonNote->"https://www.wolfram.com/cdf-player/"],
 ".\nLinkek: https://www.wolfram.com/mathematica/trial/  ",
 "https://www.wolfram.com/cdf-player/"
}], "Text",
 CellChangeTimes->{{3.640368645349719*^9, 3.640368659723041*^9}, {
  3.640368701456517*^9, 3.64036874094459*^9}, {3.640368787391799*^9, 
  3.640368845470088*^9}, {3.640368879106194*^9, 3.640368982329836*^9}, {
  3.640370121477435*^9, 3.640370186610775*^9}}],

Cell[TextData[{
 "A lyukak \[EAcute]s a k\[ODoubleDot]z\[ODoubleDot]s pont egy 10x10-es n\
\[EAcute]gyzeten bel\[UDoubleDot]l helyezkednek el. Ezen bel\[UDoubleDot]l a \
lyukak poz\[IAcute]ci\[OAcute]ja tetsz\[ODoubleAcute]legesen \
v\[AAcute]ltoztathat\[OAcute] az eg\[EAcute]r haszn\[AAcute]lat\[AAcute]val, \
de pontos koordin\[AAcute]t\[AAcute]k is megadhat\[OAcute]k a baloldali \
oszlopban. A pontok (lyukak) sz\[AAcute]m\[AAcute]t egy cs\[UAcute]szk\
\[AAcute]n 3 \[EAcute]s 8 k\[ODoubleDot]z\[ODoubleDot]tt \
tetsz\[ODoubleAcute]legesen v\[AAcute]ltoztathatjuk. Az ",
 StyleBox["Ered\[ODoubleAcute] megjelen\[IAcute]t\[EAcute]se ",
  FontSlant->"Italic"],
 "opci\[OAcute] bekapcsol\[AAcute]sa eset\[EAcute]n az \[AAcute]br\[AAcute]n \
a k\[ODoubleDot]z\[ODoubleDot]s pontb\[OAcute]l kiindul\[OAcute] \
egys\[EAcute]gvektotok mellett a program piros sz\[IAcute]nnel ezek ered\
\[ODoubleAcute]j\[EAcute]t is \[AAcute]br\[AAcute]zolja. A ",
 StyleBox["Randomize",
  FontSlant->"Italic"],
 " gomb a lyukakat v\[EAcute]letlenszer\[UDoubleAcute]en sz\[EAcute]tsz\
\[OAcute]rja a 10x10-es n\[EAcute]gyzeten bel\[UDoubleDot]l. A \
\[RightPointer] gombra kattintva ind\[IAcute]that\[OAcute] el az \
anim\[AAcute]ci\[OAcute], melynek sor\[AAcute]n a \
k\[ODoubleDot]z\[ODoubleDot]s pont a keresett pontba \[AAcute]ll be.\n\nA \
megold\[AAcute]s sor\[AAcute]n haszn\[AAcute]lt legfontosabb nyelvi eszk\
\[ODoubleDot]z a Dynamic f\[UDoubleDot]ggv\[EAcute]ny, ez teszi lehet\
\[ODoubleAcute]v\[EAcute] az interakci\[OAcute]t, illetve az anim\[AAcute]l\
\[AAcute]st is. A l\[EAcute]ptet\[EAcute]s k\[EAcute]tf\[EAcute]le \
m\[OAcute]dja k\[ODoubleDot]z\[UDoubleDot]l lehet v\[AAcute]lasztani. Az \
egyik esetben a az ered\[ODoubleAcute] er\[ODoubleAcute]vel egyenesen ar\
\[AAcute]nyos a k\[ODoubleDot]z\[ODoubleDot]s pont elmozdul\[AAcute]sa, a m\
\[AAcute]sik esetben mindig ugyanakkora. Az els\[ODoubleAcute] esetben a k\
\[ODoubleDot]zeled\[EAcute]s mag\[AAcute]t finom\[IAcute]tja, m\[IAcute]g a m\
\[AAcute]sodikban a k\[ODoubleDot]z\[ODoubleDot]s pont mindig \
t\[UAcute]lhalad a k\[IAcute]v\[AAcute]nt ponton \[EAcute]s onnan \
visszafordul. A v\[EAcute]gtelen hossz\[UAcute] ugr\[AAcute]l\[AAcute]s elker\
\[UDoubleDot]l\[EAcute]se \[EAcute]rdek\[EAcute]ben minden egyes visszafordul\
\[AAcute]sn\[AAcute]l a fel\[EAcute]re cs\[ODoubleDot]kkentj\[UDoubleDot]k a \
l\[EAcute]p\[EAcute]senk\[EAcute]nt megtett t\[AAcute]vols\[AAcute]got. Ha k\
\[ODoubleDot]z\[ODoubleDot]s pont mozg\[AAcute]sa m\[AAcute]r elhanyagolhat\
\[OAcute], le\[AAcute]ll\[IAcute]tjuk az anim\[AAcute]ci\[OAcute]t.\n\nA \
megold\[AAcute]s sor\[AAcute]n nagym\[EAcute]rt\[EAcute]kben \
kihaszn\[AAcute]ljuk a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " nyelv (Wolfram nyelv) adta lehet\[ODoubleAcute]s\[EAcute]geket, \
p\[EAcute]ld\[AAcute]ul vektorok \[ODoubleDot]sszegz\[EAcute]s\[EAcute]t vagy \
vektorok egys\[EAcute]gvektorr\[AAcute] val\[OAcute] alak\[IAcute]t\[AAcute]s\
\[AAcute]t lehet\[ODoubleAcute]v\[EAcute] tev\[ODoubleAcute] be\[EAcute]p\
\[IAcute]tett f\[UDoubleDot]ggv\[EAcute]nyeket. A rendszer automatikus \
optimaliz\[AAcute]ci\[OAcute]kat v\[EAcute]gez, \[IAcute]gy a be\[EAcute]p\
\[IAcute]tett f\[UDoubleDot]ggv\[EAcute]nyek haszn\[AAcute]lata gyorsabb, \
mint az azonos m\[UDoubleAcute]veletek \[OpenCurlyDoubleQuote]k\[EAcute]zzel\
\[CloseCurlyDoubleQuote] val\[OAcute] elv\[EAcute]gz\[EAcute]se.\n\nA forr\
\[AAcute]sk\[OAcute]d a dokumentum v\[EAcute]g\[EAcute]n megtal\[AAcute]lhat\
\[OAcute]."
}], "Text",
 CellChangeTimes->{{3.640369030005188*^9, 3.6403697009919567`*^9}, {
  3.640369757318493*^9, 3.640369950667438*^9}}],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 3, $CellContext`pc$$ = {
  8.328541594207344, 8.122920559283907}, $CellContext`pont$$ = {{
  4.918725451445457, 7.633235500934596}, {9.10022140232617, 
  0.9317051231348152}, {0.8493851033788609, 2.1367197061021965`}, {
  4.04030807608321, 7.834355422973694}, {7.25675987190678, 
  5.8255634085058325`}, {1.4161746617520183`, 6.412566953112464}, {
  0.6117486343748784, 5.404495060966699}, {1.4189052761096494`, 
  4.04344242363929}}, $CellContext`controls$$ = {{
    Text["\!\(\*SubscriptBox[\(P\), \(1\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 1]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(2\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 2]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(3\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 3]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(4\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 4]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(5\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 5]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(6\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 6]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(7\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 7]]]}, {
    Text["\!\(\*SubscriptBox[\(P\), \(8\)]\)"], 
    InputField[
     Dynamic[
      Part[$CellContext`pont$$, 8]]]}}, $CellContext`locators$$ = {
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 1]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 2]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 3]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 4]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 5]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 6]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 7]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 10]], 
   Locator[
    Dynamic[
     Part[$CellContext`pont$$, 8]], 
    Graphics[{
      Circle[{0, 0}, 1]}, ImageSize -> 
     10]]}, $CellContext`eredo$$, $CellContext`v$$, $CellContext`t$$ = 
  0.7208571434020996, $CellContext`vorosnyil$$ = 
  False, $CellContext`lockor$$ = Graphics[{
    Circle[{0, 0}, 1]}, ImageSize -> 10], $CellContext`animator$$ = Dynamic[
   Animator[
    Dynamic[$CellContext`t$$], AnimationRepetitions -> Infinity, 
    AppearanceElements -> {"PlayPauseButton"}, ImageSize -> Large, 
    AnimationRunning -> $CellContext`running$$, 
    Enabled -> $CellContext`runnable$$], 
   TrackedSymbols :> {$CellContext`running$$, $CellContext`runnable$$}], \
$CellContext`animatorProto$$, $CellContext`minx$$ = DirectedInfinity[
  1], $CellContext`miny$$ = DirectedInfinity[1], $CellContext`maxx$$ = 
  DirectedInfinity[-1], $CellContext`maxy$$ = 
  DirectedInfinity[-1], $CellContext`x$$ = 
  8.328541594207344, $CellContext`y$$ = 
  8.122920559283907, $CellContext`elozopc$$ = {8.328541594207344, 
  8.122920559283907}, $CellContext`d$$ = 
  7.629394530992457*^-6, $CellContext`factor$$ = 1, $CellContext`running$$ = 
  False, $CellContext`runnable$$ = True, $CellContext`erofuggo$$ = 
  False, $CellContext`info$$ = False}, 
  RowBox[{
   DynamicBox[
    ToBoxes[$CellContext`minx$$ = ($CellContext`miny$$ = 
       Infinity); $CellContext`maxx$$ = ($CellContext`maxy$$ = -
        Infinity); $CellContext`factor$$ = 
      1; $CellContext`elozopc$$ = $CellContext`pc$$; $CellContext`runnable$$ = 
      True; $CellContext`pont$$; $CellContext`n$$; "", StandardForm],
    ImageSizeCache->{0., {0., 7.}},
    TrackedSymbols:>{$CellContext`pont$$, $CellContext`n$$}], " ", 
   DynamicBox[ToBoxes[
    AddTo[$CellContext`pc$$, 
       If[$CellContext`erofuggo$$, $CellContext`eredo$$[$CellContext`n$$]/10, 
          Normalize[
            $CellContext`eredo$$[$CellContext`n$$]] 
          0.5] $CellContext`factor$$ + 
       0 $CellContext`t$$]; {$CellContext`x$$, $CellContext`y$$} = \
$CellContext`pc$$; $CellContext`minx$$ = 
      Min[$CellContext`minx$$, $CellContext`x$$]; $CellContext`miny$$ = 
      Min[$CellContext`miny$$, $CellContext`y$$]; $CellContext`maxx$$ = 
      Max[$CellContext`maxx$$, $CellContext`x$$]; $CellContext`maxy$$ = 
      Max[$CellContext`maxy$$, $CellContext`y$$]; If[
       Or[$CellContext`minx$$ < $CellContext`x$$ < $CellContext`maxx$$, \
$CellContext`miny$$ < $CellContext`y$$ < $CellContext`maxy$$], 
       DivideBy[$CellContext`factor$$, 
         2]; $CellContext`minx$$ = ($CellContext`miny$$ = 
         Infinity); $CellContext`maxx$$ = ($CellContext`maxy$$ = -Infinity); 
       Null]; $CellContext`d$$ = 
      EuclideanDistance[$CellContext`pc$$, $CellContext`elozopc$$]; \
$CellContext`elozopc$$ = $CellContext`pc$$; 
     If[$CellContext`d$$ < 
       If[$CellContext`erofuggo$$, 10^(-4), 10^(-5)], $CellContext`running$$ = 
        False; $CellContext`runnable$$ = False; 
       Null, $CellContext`running$$ = True; $CellContext`runnable$$ = True; 
       Null]; "", StandardForm],
    ImageSizeCache->{0., {0., 7.}},
    TrackedSymbols:>{$CellContext`t$$}], " ", 
   PanelBox[
    TagBox[GridBox[{
       {
        TagBox[GridBox[{
           {
            InterpretationBox[Cell[BoxData[
              FormBox["\<\"Pontok sz\[AAcute]ma\"\>", TextForm]], 
              "InlineText"],
             Text["Pontok sz\[AAcute]ma"]]},
           {
            InterpretationBox[
             StyleBox[GridBox[{
                {
                 SliderBox[Dynamic[$CellContext`n$$], {3, 8, 1},
                  Appearance->Automatic,
                  DefaultBaseStyle->"LabeledSlider"], 
                 InputFieldBox[Dynamic[$CellContext`n$$],
                  Appearance->"Frameless",
                  ContinuousAction->True,
                  DefaultBaseStyle->"LabeledSlider",
                  FieldSize->{{5, 10}, {1, 2}},
                  ImageMargins->0]}
               },
               AutoDelete->False,
               BaselinePosition->{{1, 1}, Axis},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.7]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              Deployed->True,
              StripOnInput->False,
              FontFamily:>CurrentValue["ControlsFontFamily"]],
             LabeledSlider[
              Dynamic[$CellContext`n$$], {3, 8, 1}]]},
           {
            TagBox[GridBox[{
               {
                TagBox[
                 TooltipBox[
                  ButtonBox["\<\"Randomize\"\>",
                   Appearance->Automatic,
                   ButtonFunction:>($CellContext`pont$$ = Table[
                    RandomReal[10, 2], {8}]),
                   Evaluator->Automatic,
                   ImageSize->Large,
                   Method->"Preemptive"],
                  "\"V\[EAcute]letlenszer\[UDoubleAcute] pontok\"",
                  TooltipStyle->"TextStyling"],
                 
                 Annotation[#, "V\[EAcute]letlenszer\[UDoubleAcute] pontok", 
                  "Tooltip"]& ], 
                TagBox[
                 TooltipBox[
                  DynamicBox[ToBoxes[$CellContext`animator$$, StandardForm],
                   ImageSizeCache->{22., {9., 15.}}],
                  
                  "\"L\[EAcute]ptet\[EAcute]s / meg\[AAcute]ll\[IAcute]t\
\[AAcute]s\"",
                  TooltipStyle->"TextStyling"],
                 
                 Annotation[#, 
                  "L\[EAcute]ptet\[EAcute]s / meg\[AAcute]ll\[IAcute]t\
\[AAcute]s", "Tooltip"]& ], ""}
              },
              AutoDelete->False,
              
              GridBoxItemSize->{
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
             "Grid"]},
           {
            TagBox[GridBox[{
               {
                InterpretationBox[Cell[BoxData[
                  
                  FormBox["\<\"Ered\[ODoubleAcute] \
megjelen\[IAcute]t\[EAcute]se\"\>", TextForm]], "InlineText"],
                 Text["Ered\[ODoubleAcute] megjelen\[IAcute]t\[EAcute]se"]], 
                CheckboxBox[Dynamic[$CellContext`vorosnyil$$]]},
               {
                InterpretationBox[Cell[BoxData[
                  
                  FormBox["\<\"Inform\[AAcute]ci\[OAcute]k megjelen\[IAcute]t\
\[EAcute]se\"\>", TextForm]], "InlineText"],
                 Text[
                 "Inform\[AAcute]ci\[OAcute]k \
megjelen\[IAcute]t\[EAcute]se"]], 
                CheckboxBox[Dynamic[$CellContext`info$$]]},
               {
                InterpretationBox[Cell[BoxData[
                  
                  FormBox["\<\"L\[EAcute]ptet\[EAcute]s m\[OAcute]dja\"\>", 
                   TextForm]], "InlineText"],
                 Text["L\[EAcute]ptet\[EAcute]s m\[OAcute]dja"]], 
                
                PopupMenuBox[Dynamic[$CellContext`erofuggo$$], {
                 True->"\<\"Ered\[ODoubleAcute] er\[ODoubleAcute]vel ar\
\[AAcute]nyos\"\>", 
                 False->"\<\"Ered\[ODoubleAcute] er\[ODoubleAcute] nagys\
\[AAcute]g\[AAcute]t\[OAcute]l f\[UDoubleDot]ggetlen\"\>"}, "True", 
                 PopupMenuBox[Null, {}]]}
              },
              AutoDelete->False,
              GridBoxAlignment->{"Columns" -> {{Left}}},
              
              GridBoxItemSize->{
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
             "Grid"]},
           {
            DynamicBox[ToBoxes[
              Grid[
               Part[$CellContext`controls$$, 
                Span[1, $CellContext`n$$]]], StandardForm],
             ImageSizeCache->{210., {28., 34.}}]},
           {
            InterpretationBox[
             StyleBox[
              GraphicsBox[{},
               BaselinePosition->(Scaled[0.] -> Baseline),
               ImageSize->{0, 10}],
              CacheGraphics->False],
             Spacer[{0, 10}]]},
           {
            DynamicBox[ToBoxes[
              If[$CellContext`info$$, 
               Row[{
                 Text["factor="], 
                 Text[$CellContext`factor$$], 
                 Text["  d="], 
                 Text[$CellContext`d$$]}], ""], StandardForm],
             ImageSizeCache->{0., {0., 6.}}]}
          },
          DefaultBaseStyle->"Column",
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
         "Column"], 
        DynamicBox[ToBoxes[
          Graphics[{
            PointSize[Large], 
            Point[$CellContext`pc$$], 
            Table[{
              Line[{$CellContext`pc$$, 
                Part[$CellContext`pont$$, $CellContext`i]}], 
              Arrow[{$CellContext`pc$$, $CellContext`pc$$ + $CellContext`v$$[
                  
                  Part[$CellContext`pont$$, $CellContext`i]]}]}, \
{$CellContext`i, 1, $CellContext`n$$}], 
            Part[$CellContext`locators$$, 
             Span[1, $CellContext`n$$]], Red, 
            If[$CellContext`vorosnyil$$, 
             
             Arrow[{$CellContext`pc$$, $CellContext`pc$$ + \
$CellContext`eredo$$[$CellContext`n$$]}], Null]}, PlotRangeClipping -> False, 
           Frame -> True, PlotRange -> {{0, 10}, {0, 10}}, ImageSize -> 
           Medium], StandardForm],
         ImageSizeCache->{360., {178., 184.}}]}
      },
      AutoDelete->False,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Top}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      Selectable->False],
     "Grid"]]}],
  DynamicModuleValues:>{{DownValues[$CellContext`eredo$$] = {HoldPattern[
         $CellContext`eredo$$[
          Pattern[$CellContext`a$, 
           Blank[]]]] :> Sum[
         $CellContext`v$$[
          Part[$CellContext`pont$$, $CellContext`i]], {$CellContext`i, 
          1, $CellContext`a$}]}}, {DownValues[$CellContext`v$$] = {HoldPattern[
         $CellContext`v$$[
          Pattern[$CellContext`a$, 
           Blank[]]]] :> 
       Normalize[$CellContext`a$ - $CellContext`pc$$]}}}]], "Output",
 CellChangeTimes->{3.6403699627071657`*^9}],

Cell[BoxData[
 RowBox[{"DynamicModule", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "3"}], ",", 
     RowBox[{"(*", 
      RowBox[{"Pontok", " ", "sz\[AAcute]ma"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"pc", "=", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], ",", 
     RowBox[{"(*", 
      RowBox[{"k\[ODoubleDot]z\[ODoubleDot]s", " ", "pont"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"pont", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{"10", ",", "2"}], "]"}], ",", 
        RowBox[{"{", "8", "}"}]}], "]"}]}], ",", 
     RowBox[{"(*", 
      RowBox[{"a", " ", "lyukak", " ", "helyei"}], "*)"}], 
     "\[IndentingNewLine]", "controls", ",", 
     RowBox[{"(*", 
      RowBox[{
      "sz\[ODoubleDot]veges", " ", "bevitel", " ", "a", " ", "pontos", " ", 
       "koordin\[AAcute]t\[AAcute]khoz"}], "*)"}], "\[IndentingNewLine]", 
     "locators", ",", 
     RowBox[{"(*", 
      RowBox[{
      "a", " ", "lyukak", " ", "elhelyez\[EAcute]se", " ", 
       "kattint\[AAcute]ssal"}], "*)"}], "\[IndentingNewLine]", "eredo", ",", 
     
     RowBox[{"(*", 
      RowBox[{
      "ered\[ODoubleAcute]", " ", "vektorst", " ", 
       "meghat\[AAcute]roz\[OAcute]", " ", "fv"}], "*)"}], 
     "\[IndentingNewLine]", " ", "v", ",", 
     RowBox[{"(*", 
      RowBox[{
      "A", " ", "k\[ODoubleDot]z\[ODoubleDot]s", " ", "pontb\[OAcute]l", " ", 
       "egy", " ", "adott", " ", "pont", " ", "fel\[EAcute]", " ", 
       "mutat\[OAcute]", " ", "norm\[AAcute]lvektor"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"t", "=", "0"}], ",", 
     RowBox[{"(*", 
      RowBox[{
      "az", " ", "anim\[AAcute]ci\[OAcute]", " ", 
       "p\[ODoubleDot]rget\[EAcute]se"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"vorosnyil", "=", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{"ered\[ODoubleAcute]", " ", 
       RowBox[{"megjelen\[IAcute]t\[EAcute]se", "?"}]}], "*)"}], 
     "\[IndentingNewLine]", "lockor", ",", 
     RowBox[{"(*", 
      RowBox[{
      "a", " ", "locator", " ", "ne", " ", "az", " ", 
       "alap\[EAcute]rtelmez\[EAcute]s", " ", "szerint", " ", "jelenjen", " ",
        "meg"}], "*)"}], "\[IndentingNewLine]", "animator", ",", 
     RowBox[{"(*", 
      RowBox[{"anim\[AAcute]ci\[OAcute]", " ", "vez\[EAcute]rl\[EAcute]se"}], 
      "*)"}], "\[IndentingNewLine]", "animatorProto", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"minx", "=", "\[Infinity]"}], ",", 
     RowBox[{"miny", "=", "\[Infinity]"}], ",", 
     RowBox[{"maxx", "=", 
      RowBox[{"-", "\[Infinity]"}]}], ",", 
     RowBox[{"maxy", " ", "=", 
      RowBox[{"-", "\[Infinity]"}]}], ",", 
     RowBox[{"(*", 
      RowBox[{
      "a", " ", "k\[ODoubleDot]z\[ODoubleDot]s", " ", "pont", " ", 
       "sz\[EAcute]ls\[ODoubleAcute]", " ", "helyzetei"}], "*)"}], 
     "\[IndentingNewLine]", "x", ",", "y", ",", "\[IndentingNewLine]", 
     RowBox[{"elozopc", "=", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], ",", 
     RowBox[{"(*", 
      RowBox[{"k\[ODoubleDot]vetj\[UDoubleDot]k", ",", " ", 
       RowBox[{
       "hogy", " ", "mennyit", " ", "mozdult", " ", "a", " ", 
        "k\[ODoubleDot]z\[ODoubleDot]s", " ", "pont"}]}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"d", "=", "0"}], ",", 
     RowBox[{"(*", "elmozdul\[AAcute]s", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"factor", "=", "1"}], ",", 
     RowBox[{"(*", 
      RowBox[{"anim\[AAcute]ci\[OAcute]", " ", "finom\[IAcute]t\[AAcute]sa"}],
       "*)"}], "\[IndentingNewLine]", 
     RowBox[{"running", "=", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{"megy", "-", 
       RowBox[{"e", " ", "az", " ", "anim\[AAcute]ci\[OAcute]"}]}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"runnable", "=", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{"animator", " ", "letilt\[AAcute]sa"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"erofuggo", "=", "True"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"a", " ", "l\[EAcute]ptet\[EAcute]s", " ", "ar\[AAcute]nyos"}],
        "-", 
       RowBox[{"e", " ", "az", " ", "eredo", " ", "er\[ODoubleAcute]vel"}]}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"info", "=", "False"}]}], 
    RowBox[{"(*", 
     RowBox[{
     "inform\[AAcute]ci\[OAcute]k", " ", "megjelen\[IAcute]t\[EAcute]se"}], 
     "*)"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"controls", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(1\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(2\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(3\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(4\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(5\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(6\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(7\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "@", "\"\<\!\(\*SubscriptBox[\(P\), \(8\)]\)\>\""}], 
         ",", 
         RowBox[{"InputField", "[", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"pont", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"lockor", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"locators", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], ",", "lockor"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Locator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "@", 
          RowBox[{"pont", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], ",", "lockor"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eredo", "[", "a_", "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"v", "@", 
        RowBox[{"pont", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "a"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"v", "[", "a_", "]"}], ":=", 
     RowBox[{"Normalize", "[", 
      RowBox[{"a", "-", "pc"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"animator", "=", 
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"Animator", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "t", "]"}], ",", 
         RowBox[{"AnimationRepetitions", "\[Rule]", "Infinity"}], ",", 
         RowBox[{"AppearanceElements", "\[Rule]", 
          RowBox[{"{", "\"\<PlayPauseButton\>\"", "}"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
         RowBox[{"AnimationRunning", "\[Rule]", "running"}], ",", 
         RowBox[{"Enabled", "\[Rule]", "runnable"}]}], "]"}], ",", 
       RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"running", ",", "runnable"}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Dynamic", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"pc", "+=", 
         RowBox[{
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{"erofuggo", ",", 
             RowBox[{
              RowBox[{"eredo", "[", "n", "]"}], "/", "10"}], ",", 
             RowBox[{
              RowBox[{"Normalize", "[", 
               RowBox[{"eredo", "[", "n", "]"}], "]"}], "*", "0.5"}]}], "]"}],
            "*", "factor"}], "+", 
          RowBox[{"0", "*", "t"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "=", "pc"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"minx", "=", 
         RowBox[{"Min", "[", 
          RowBox[{"minx", ",", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"miny", "=", 
         RowBox[{"Min", "[", 
          RowBox[{"miny", ",", "y"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"maxx", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"maxx", ",", "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"maxy", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"maxy", ",", "y"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"minx", "<", "x", "<", "maxx"}], ")"}], "||", 
           RowBox[{"(", 
            RowBox[{"miny", "<", "y", "<", "maxy"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"factor", "/=", "2"}], ";", "\[IndentingNewLine]", 
           RowBox[{"minx", "=", 
            RowBox[{"miny", "=", "\[Infinity]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"maxx", "=", 
            RowBox[{"maxy", "=", 
             RowBox[{"-", "\[Infinity]"}]}]}], ";"}]}], "\[IndentingNewLine]",
          "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"d", "=", 
         RowBox[{"EuclideanDistance", "[", 
          RowBox[{"pc", ",", "elozopc"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"elozopc", "=", "pc"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"d", "<", 
           RowBox[{"If", "[", 
            RowBox[{"erofuggo", ",", 
             SuperscriptBox["10", 
              RowBox[{"-", "4"}]], ",", 
             SuperscriptBox["10", 
              RowBox[{"-", "5"}]]}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"running", "=", "False"}], ";", "\[IndentingNewLine]", 
           RowBox[{"runnable", "=", "False"}], ";"}], "\[IndentingNewLine]", 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"running", "=", "True"}], ";", "\[IndentingNewLine]", 
           RowBox[{"runnable", "=", "True"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\"\<\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
        RowBox[{"{", "t", "}"}]}]}], "]"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "Ha", " ", "b\[AAcute]rmilyen", " ", 
        "be\[AAcute]ll\[IAcute]t\[AAcute]s", " ", "megv\[AAcute]ltozik"}], 
       ",", " ", 
       RowBox[{
        RowBox[{"resetelj\[UDoubleDot]k", " ", "a", " ", 
         RowBox[{"min", "/", "max"}]}], "-", 
        RowBox[{"ot", " ", "\[EAcute]s", " ", "a", " ", "factort"}]}]}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Dynamic", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"minx", "=", 
         RowBox[{"miny", "=", "\[Infinity]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"maxx", "=", 
         RowBox[{"maxy", "=", 
          RowBox[{"-", "\[Infinity]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"factor", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"elozopc", "=", "pc"}], ";", "\[IndentingNewLine]", 
        RowBox[{"runnable", "=", "True"}], ";", "\[IndentingNewLine]", "pont",
         ";", "\[IndentingNewLine]", "n", ";", "\[IndentingNewLine]", 
        "\"\<\>\""}], ",", "\[IndentingNewLine]", 
       RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"pont", ",", "n"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Panel", "@", 
      RowBox[{"Grid", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Column", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Text", "[", "\"\<Pontok sz\[AAcute]ma\>\"", "]"}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"Slider", "[", 
               RowBox[{
                RowBox[{"Dynamic", "@", "n"}], ",", 
                RowBox[{"{", 
                 RowBox[{"3", ",", "8", ",", "1"}], "}"}], ",", 
                RowBox[{"Appearance", "->", "\"\<Labeled\>\""}]}], " ", "]"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"Grid", "[", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Tooltip", "[", 
                   RowBox[{
                    RowBox[{"Button", "[", 
                    RowBox[{"\"\<Randomize\>\"", ",", 
                    RowBox[{"pont", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"10", ",", "2"}], "]"}], ",", 
                    RowBox[{"{", "8", "}"}]}], "]"}]}], ",", 
                    RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}], ",", 
                    "\"\<V\[EAcute]letlenszer\[UDoubleAcute] pontok\>\""}], 
                   "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Tooltip", "[", 
                   RowBox[{
                    RowBox[{"Dynamic", "@", "animator"}], ",", 
                    "\"\<L\[EAcute]ptet\[EAcute]s / meg\[AAcute]ll\[IAcute]t\
\[AAcute]s\>\""}], "]"}], ","}], "\[IndentingNewLine]", "}"}], "}"}], "]"}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{"Grid", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "Text", "[", 
                    "\"\<Ered\[ODoubleAcute] \
megjelen\[IAcute]t\[EAcute]se\>\"", "]"}], ",", 
                    RowBox[{"Checkbox", "[", 
                    RowBox[{"Dynamic", "@", "vorosnyil"}], "]"}]}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "Text", "[", 
                    "\"\<Inform\[AAcute]ci\[OAcute]k megjelen\[IAcute]t\
\[EAcute]se\>\"", "]"}], ",", 
                    RowBox[{"Checkbox", "[", 
                    RowBox[{"Dynamic", "@", "info"}], "]"}]}], "}"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "Text", "[", 
                    "\"\<L\[EAcute]ptet\[EAcute]s m\[OAcute]dja\>\"", "]"}], 
                    ",", 
                    RowBox[{"PopupMenu", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "erofuggo", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "True", "\[Rule]", 
                    "\"\<Ered\[ODoubleAcute] er\[ODoubleAcute]vel \
ar\[AAcute]nyos\>\""}], ",", 
                    RowBox[{
                    "False", "\[Rule]", 
                    "\"\<Ered\[ODoubleAcute] er\[ODoubleAcute] \
nagys\[AAcute]g\[AAcute]t\[OAcute]l f\[UDoubleDot]ggetlen\>\""}]}], "}"}], 
                    ",", "True", ",", 
                    RowBox[{"PopupMenu", "[", 
                    RowBox[{"Null", ",", 
                    RowBox[{"{", "}"}]}], "]"}]}], "]"}]}], "}"}]}], 
                 "\[IndentingNewLine]", "}"}], ",", 
                RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Dynamic", "@", 
               RowBox[{"Grid", "[", 
                RowBox[{"controls", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", "n"}], "]"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "10"}], "}"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Dynamic", "@", 
               RowBox[{"If", "[", 
                RowBox[{"info", ",", 
                 RowBox[{"Row", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Text", "@", "\"\<factor=\>\""}], ",", 
                    RowBox[{"Text", "@", "factor"}], ",", 
                    RowBox[{"Text", "[", "\"\<  d=\>\"", "]"}], ",", 
                    RowBox[{"Text", "@", "d"}]}], "}"}], "]"}], ",", 
                 "\"\<\>\""}], "]"}]}]}], "\[IndentingNewLine]", "}"}], "]"}],
            ",", "\[IndentingNewLine]", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"Graphics", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"PointSize", "[", "Large", "]"}], ",", 
                RowBox[{"Point", "[", "pc", "]"}], ",", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{"pc", ",", 
                    RowBox[{"pont", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"pc", ",", 
                    RowBox[{"pc", "+", 
                    RowBox[{"v", "@", 
                    RowBox[{"pont", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}]}], "}"}], "]"}]}], 
                   "}"}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", " ", "1", ",", " ", "n"}], "}"}]}], 
                 "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"locators", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ";;", "n"}], "]"}], "]"}], ",", 
                "\[IndentingNewLine]", "Red", ",", 
                RowBox[{"If", "[", 
                 RowBox[{"vorosnyil", ",", 
                  RowBox[{"Arrow", "[", 
                   RowBox[{"{", 
                    RowBox[{"pc", ",", 
                    RowBox[{"pc", "+", 
                    RowBox[{"eredo", "[", "n", "]"}]}]}], "}"}], "]"}], ",", 
                  "Null"}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotRangeClipping", "\[Rule]", "False"}], ",", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              RowBox[{"PlotRange", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "10"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
              RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]}]}], 
          "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"Selectable", "\[Rule]", "False"}], ",", 
        RowBox[{"Alignment", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Left", ",", "Top"}], "}"}]}]}], "]"}]}]}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.640257151789777*^9, 3.640257262789969*^9}, {
   3.640257667896901*^9, 3.640257708267002*^9}, 3.6402667701458817`*^9, {
   3.640266831773067*^9, 3.640266833705598*^9}, {3.640266960888475*^9, 
   3.640267126319273*^9}, {3.640267169760559*^9, 3.6402671790894814`*^9}, {
   3.6402676210914593`*^9, 3.640267918718697*^9}, {3.640268058983284*^9, 
   3.640268089944868*^9}, {3.640268133383497*^9, 3.640268287229961*^9}, {
   3.640268319856267*^9, 3.640268352944685*^9}, {3.640268487064081*^9, 
   3.640268873350526*^9}, {3.640268930157297*^9, 3.64026893496231*^9}, {
   3.640268993688794*^9, 3.6402690833438053`*^9}, {3.640269113923121*^9, 
   3.640269198607445*^9}, {3.6402692321031227`*^9, 3.640269235991478*^9}, {
   3.6402693243747377`*^9, 3.640269354313903*^9}, {3.6402694069355717`*^9, 
   3.640269488203145*^9}, 3.640269551887869*^9, {3.640269584119012*^9, 
   3.640269673093954*^9}, {3.640271065216262*^9, 3.6402710829523487`*^9}, {
   3.640271134282825*^9, 3.6402711555727873`*^9}, {3.640271278576689*^9, 
   3.640271310942601*^9}, {3.640271361555955*^9, 3.6402713682636642`*^9}, {
   3.640271438790859*^9, 3.640271476679089*^9}, {3.640271522971936*^9, 
   3.640271690393537*^9}, {3.6402717628294992`*^9, 3.640271869704816*^9}, {
   3.640271935991234*^9, 3.640272006118449*^9}, {3.640272160965728*^9, 
   3.640272201223048*^9}, {3.640272305086635*^9, 3.6402723113601933`*^9}, {
   3.640272350421822*^9, 3.6402724837462997`*^9}, {3.6402725460848207`*^9, 
   3.6402725812133913`*^9}, {3.640272653978104*^9, 3.6402726605986853`*^9}, {
   3.640272697775874*^9, 3.640272728485942*^9}, {3.640273073273*^9, 
   3.640273077890571*^9}, {3.6402731418464317`*^9, 3.640273196713709*^9}, {
   3.640273256234852*^9, 3.640273355419286*^9}, {3.640273512971787*^9, 
   3.640273518783149*^9}, {3.640273688908923*^9, 3.640273727956108*^9}, {
   3.6402737695790987`*^9, 3.640273880526328*^9}, {3.640273935438833*^9, 
   3.6402740969588833`*^9}, {3.640274263792424*^9, 3.6402742657436666`*^9}, {
   3.640281054264928*^9, 3.6402811095622253`*^9}, {3.640281207555173*^9, 
   3.6402812568677387`*^9}, {3.640281294897901*^9, 3.640281309150226*^9}, {
   3.640281396706402*^9, 3.640281397501502*^9}, {3.640281577947671*^9, 
   3.640281613937829*^9}, {3.640281740023335*^9, 3.640281764868598*^9}, {
   3.640281859212433*^9, 3.64028186416934*^9}, {3.640282560027987*^9, 
   3.640282636329797*^9}, {3.640284745667864*^9, 3.6402847458974743`*^9}, {
   3.6403328617156363`*^9, 3.6403328995322647`*^9}, {3.640332931739574*^9, 
   3.640332934929847*^9}, {3.640332968563574*^9, 3.640333041296577*^9}, {
   3.640333087554165*^9, 3.640333106352182*^9}, {3.6403336932720947`*^9, 
   3.640333733961458*^9}, {3.64033380559908*^9, 3.640333837069304*^9}, {
   3.6403338719706583`*^9, 3.640334092728026*^9}, {3.640334170851166*^9, 
   3.640334184263414*^9}, {3.64033424098958*^9, 3.640334264009186*^9}, {
   3.640334306286549*^9, 3.640334354130989*^9}, 3.6403343870593243`*^9, {
   3.640334459223921*^9, 3.640334481182334*^9}, {3.640334576414402*^9, 
   3.640334577579379*^9}, {3.640334723998124*^9, 3.6403347633456697`*^9}, {
   3.640334807654183*^9, 3.640334827432106*^9}, {3.6403514019862957`*^9, 
   3.640351430964254*^9}, {3.640355198209132*^9, 3.640355279837474*^9}, {
   3.640355385451181*^9, 3.6403554050109653`*^9}, {3.640355574345687*^9, 
   3.64035565449971*^9}, {3.640355692674571*^9, 3.6403557642879257`*^9}, {
   3.640355864429599*^9, 3.640355900347361*^9}, {3.640355964785757*^9, 
   3.640355972318668*^9}, {3.640356012488456*^9, 3.6403560297115583`*^9}, {
   3.640356212948457*^9, 3.640356216274938*^9}, {3.640356266978653*^9, 
   3.6403562681337767`*^9}, {3.64035641886642*^9, 3.640356454403371*^9}, {
   3.640356592942415*^9, 3.640356602504677*^9}, {3.640357126365261*^9, 
   3.640357128321553*^9}, {3.6403573667684383`*^9, 3.640357371330888*^9}, {
   3.640357450966461*^9, 3.6403575185669527`*^9}, {3.640357554773597*^9, 
   3.6403576259707336`*^9}, {3.64035773983939*^9, 3.6403577553151417`*^9}, {
   3.640357948801448*^9, 3.64035804194906*^9}, {3.640358084656719*^9, 
   3.6403580879057198`*^9}, {3.640358741791851*^9, 3.640358760829155*^9}, {
   3.640358813280654*^9, 3.640358911302412*^9}, {3.640359075068368*^9, 
   3.640359083889865*^9}, {3.640359125986897*^9, 3.640359211956931*^9}, {
   3.6403595091946583`*^9, 3.6403595485725727`*^9}, {3.640359598242543*^9, 
   3.640359888681971*^9}, {3.6403601331960583`*^9, 3.640360229827072*^9}, {
   3.640360289209734*^9, 3.6403603305652657`*^9}, {3.640360505582443*^9, 
   3.64036054627055*^9}, {3.640360584490816*^9, 3.640360601539401*^9}, {
   3.640360633387582*^9, 3.640360688942257*^9}, 3.6403607744799223`*^9, {
   3.640360994926755*^9, 3.640361142010734*^9}, {3.6403612522855177`*^9, 
   3.640361277276492*^9}, {3.6403613575592318`*^9, 3.640361379705567*^9}, {
   3.640361417047084*^9, 3.640361419472415*^9}, {3.64036147334734*^9, 
   3.6403614864912643`*^9}, {3.64036152608766*^9, 3.640361587559589*^9}, {
   3.640361645737547*^9, 3.6403616938037367`*^9}, {3.640361803083959*^9, 
   3.6403618233121853`*^9}, {3.6403618615734463`*^9, 
   3.6403618654665613`*^9}, {3.640361939834105*^9, 3.640361941135859*^9}, {
   3.640362190666901*^9, 3.64036222762678*^9}, {3.640362273118473*^9, 
   3.640362313790707*^9}, {3.640362388527878*^9, 3.640362628070826*^9}, {
   3.64036274899098*^9, 3.640362838254945*^9}, {3.640362916943989*^9, 
   3.640362922055914*^9}, {3.640362972923603*^9, 3.64036302056569*^9}, {
   3.6403631298567963`*^9, 3.6403631608712807`*^9}, {3.640363195223998*^9, 
   3.640363302421465*^9}, {3.640363356591498*^9, 3.640363358714779*^9}, {
   3.640363501818535*^9, 3.640363508402088*^9}, {3.6403635819581003`*^9, 
   3.640363612600016*^9}, {3.640363673368355*^9, 3.6403636776625347`*^9}, {
   3.640363885548841*^9, 3.6403639693240957`*^9}, {3.6403640106364803`*^9, 
   3.640364016109646*^9}, 3.640364057199299*^9, {3.640364140048483*^9, 
   3.640364142670578*^9}, {3.640364191808016*^9, 3.6403641932281857`*^9}, {
   3.640364277253845*^9, 3.640364331001861*^9}, {3.6403643791087437`*^9, 
   3.640364380453887*^9}, {3.640364565329461*^9, 3.640364676781233*^9}, {
   3.640364721010119*^9, 3.6403648002838163`*^9}, {3.640364832179255*^9, 
   3.6403648354452467`*^9}, {3.640364866787819*^9, 3.640364901486033*^9}, {
   3.6403650554757013`*^9, 3.640365059988278*^9}, {3.640365109405051*^9, 
   3.640365109833934*^9}, {3.640365212531066*^9, 3.640365261708846*^9}, {
   3.640365325206254*^9, 3.640365411601869*^9}, {3.6403654528484697`*^9, 
   3.640365455509006*^9}, {3.6403654940192013`*^9, 3.6403655011848307`*^9}, {
   3.640365550060113*^9, 3.640365559623929*^9}, 3.6403656274121313`*^9, {
   3.640365683080049*^9, 3.6403657214167013`*^9}, {3.640365908560165*^9, 
   3.640366025890338*^9}, {3.6403660656260147`*^9, 3.640366087103065*^9}, {
   3.6403663093108*^9, 3.640366448435203*^9}, {3.640366486659733*^9, 
   3.640366562690737*^9}, {3.640366800353792*^9, 3.6403669709732*^9}, {
   3.6403670348086557`*^9, 3.6403670373106194`*^9}, {3.6403671085316267`*^9, 
   3.640367109850305*^9}, {3.6403671459314117`*^9, 3.640367220413625*^9}, {
   3.640367346386013*^9, 3.6403673813465023`*^9}, {3.640367450871738*^9, 
   3.640367480594851*^9}, {3.640367690220345*^9, 3.6403677557807493`*^9}, {
   3.640367791130526*^9, 3.640367855800762*^9}, {3.640367932792798*^9, 
   3.640368052432527*^9}, 3.640368107882627*^9, 3.640368214843377*^9, {
   3.6403697163086977`*^9, 3.6403697168858557`*^9}}]
}, Open  ]]
},
WindowSize->{1061, 1020},
WindowMargins->{{Automatic, 626}, {71, Automatic}},
FrontEndVersion->"10.0 for Linux x86 (64-bit) (June 27, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 125, 1, 96, "Title"],
Cell[CellGroupData[{
Cell[730, 27, 119, 1, 31, "Item"],
Cell[852, 30, 170, 2, 31, "Item"],
Cell[1025, 34, 100, 1, 31, "Item"]
}, Open  ]],
Cell[1140, 38, 1108, 24, 77, "Text"],
Cell[2251, 64, 3635, 56, 385, "Text"],
Cell[5889, 122, 12805, 318, 399, "Output"],
Cell[18697, 442, 30290, 651, 2708, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
