unit Uapr1_1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Abra: TImage;
    ButtonKilepes: TButton;
    Label1: TLabel;
    EditN: TEdit;
    ButtonMehet: TButton;
    Label2: TLabel;
    LabelD: TLabel;
    procedure ButtonMehetClick(Sender: TObject);
    procedure ButtonKilepesClick(Sender: TObject);
    procedure EditNChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ButtonMehetClick(Sender: TObject);
  var
    n,i:Integer;
    sx,sy,x,y,d:Extended;
begin
  n:=StrToInt(EditN.Text);
  d:=0;
  For i:=1 To n do
    d:=d+1/i;
  d:=(d)/2;
  LabelD.Caption:=FloatToStrF(d,ffNumber,15,4);
  Abra.Canvas.Pen.Color:=clLtGray;
  For i:=0 to trunc(d)+1 do begin
    Abra.Canvas.MoveTo(150+i*100,480);
    Abra.Canvas.LineTo(150+i*100,0);
  end;
  Abra.Canvas.Pen.Color:=clBlack;
  x:=150+100*d;
  y:=405-5*n;
  For i:=1 To n do begin
    Abra.Canvas.Brush.Color:=clGreen;
    Abra.Canvas.Rectangle(round(x),round(y),round(x-100),round(y-5));
    Abra.Canvas.Brush.Color:=clYellow;
    Abra.Canvas.Rectangle(round(x-49),round(y-1),round(x-51),round(y-4));
    x:=x-50/i;
    y:=y+5;
  end;
  sx:=150;
  sy:=400-5*n/2;
  Abra.Canvas.Brush.Color:=clRed;
  Abra.Canvas.Rectangle(round(sx-2*sqrt(n)/3),round(sy-2*sqrt(n)/3),round(sx+2*sqrt(n)/3),round(sy+2*sqrt(n)/3));
end;

procedure TForm1.ButtonKilepesClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.EditNChange(Sender: TObject);
begin
  LabelD.Caption:='?';
  Abra.Canvas.Brush.Color:=clWhite;
  Abra.Canvas.Rectangle(0,0,640,480);
  Abra.Canvas.Brush.Color:=clYellow;
  Abra.Canvas.Rectangle(0,480,150,400);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Abra.Canvas.Brush.Color:=clWhite;
  Abra.Canvas.Rectangle(0,0,640,480);
  Abra.Canvas.Brush.Color:=clYellow;
  Abra.Canvas.Rectangle(0,480,150,400);
end;

end.
